/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.ResourcePointManager;
import org.kingdoms.utils.string.StringUtils;

public class CommandTradable
extends KingdomsCommand {
    public CommandTradable() {
        super("tradable", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        boolean isEmpty = item.getType() == Material.AIR;
        long worth = isEmpty ? 0L : ResourcePointManager.getWorth(item, 1);
        String worthString = worth == 0L ? KingdomsLang.COMMAND_TRADABLE_NOT_SPECIAL.parse(new Object[0]) : StringUtils.toFancyNumber(worth);
        YamlConfigAccessor section = KingdomsConfig.ResourcePoints.CUSTOM.getManager().getSection();
        StringBuilder list2 = new StringBuilder(100);
        for (String materials : section.getKeys()) {
            Optional<XMaterial> matOpt = XMaterial.matchXMaterial(materials);
            if (!matOpt.isPresent()) continue;
            int special = section.getInt(materials);
            list2.append(KingdomsLang.COMMAND_TRADABLE_ITEM.parse("material", KingdomsLang.translateMaterial(matOpt.get()), "worth", special)).append('\n');
        }
        context.sendMessage(KingdomsLang.COMMAND_TRADABLE_MESSAGE, "amount", isEmpty ? 0 : item.getAmount(), "total", StringUtils.toFancyNumber((long)item.getAmount() * worth), "worth", worthString, "list", list2);
    }
}

