/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc.map;

import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.managers.land.KingdomsMap;
import org.kingdoms.utils.string.StringUtils;

public class CommandMapSettings
extends KingdomsCommand {
    public CommandMapSettings(KingdomsParentCommand parent) {
        super("settings", parent, PermissionDefault.TRUE);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.MAP$SETTINGS.getGUIPath(), new MessageBuilder().raw("auto_map_enabled", kp.isAutoMap()).raw("scoreboard_enabled", KingdomsMap.isUsingScoreboard(player)).withContext(player));
        gui.push("reset", () -> {
            int height = KingdomsConfig.Map.HEIGHT.getManager().getInt();
            int width = KingdomsConfig.Map.WIDTH.getManager().getInt();
            kp.setMapSize(Pair.of(height, width));
            KingdomsLang.COMMAND_MAP_SIZE_RESET.sendMessage((CommandSender)player);
            this.execute(context);
        }, new Object[0]);
        gui.push("auto", () -> {
            kp.setAutoMap(!kp.isAutoMap());
            KingdomsLang msg = kp.isAutoMap() ? KingdomsLang.COMMAND_MAP_AUTO_ENABLED : KingdomsLang.COMMAND_MAP_AUTO_DISABLED;
            msg.sendMessage((CommandSender)player);
            this.execute(context);
        }, new Object[0]);
        gui.push("resize", () -> {
            KingdomsLang.NEXUS_RANK_EDITOR_ENTER_VALUE.sendMessage((CommandSender)player);
            gui.startConversation("resize");
        }, input -> {
            int height;
            int width;
            String[] args = input.contains(",") ? StringUtils.splitArray(input, ',') : (input.contains(" ") ? StringUtils.splitArray(input, ' ') : new String[]{input, input});
            if (args.length != 2) {
                KingdomsLang.COMMAND_MAP_INVALID_HEIGHT.sendMessage((CommandSender)player, "height", args[0]);
                return;
            }
            try {
                width = Integer.parseInt(args[0].trim());
            }
            catch (NumberFormatException ignored) {
                KingdomsLang.COMMAND_MAP_INVALID_WIDTH.sendMessage((CommandSender)player, "width", args[0]);
                width = KingdomsConfig.Map.WIDTH.getManager().getInt();
            }
            try {
                height = Integer.parseInt(args[1].trim());
            }
            catch (NumberFormatException ignored) {
                KingdomsLang.COMMAND_MAP_INVALID_HEIGHT.sendMessage((CommandSender)player, "height", args[1]);
                height = KingdomsConfig.Map.HEIGHT.getManager().getInt();
            }
            if (!kp.isAdmin()) {
                int maxHeight = KingdomsConfig.Map.LIMIT_HEIGHT.getManager().getInt();
                if (height > maxHeight) {
                    KingdomsLang.COMMAND_MAP_MAX_HEIGHT.sendMessage((CommandSender)player, "limit", maxHeight);
                    return;
                }
                int maxWidth = KingdomsConfig.Map.LIMIT_WIDTH.getManager().getInt();
                if (width > maxWidth) {
                    KingdomsLang.COMMAND_MAP_MAX_WIDTH.sendMessage((CommandSender)player, "limit", maxWidth);
                    return;
                }
            }
            KingdomsLang.COMMAND_MAP_SIZE_CHANGED.sendMessage((CommandSender)player, "new_height", height, "new_width", width);
            kp.setMapSize(Pair.of(height, width));
            gui.endConversation();
            this.execute(context);
        }, new Object[0]);
        gui.push("scoreboard", () -> {
            if (!XMaterial.supports(13)) {
                context.sendError(KingdomsLang.COMMAND_MAP_SCOREBOARD_NOT_SUPPORTED, new Object[0]);
                return;
            }
            if (KingdomsMap.SCOREBOARDS.remove(player.getUniqueId()) != null) {
                player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
            } else {
                kp.buildMap().displayAsScoreboard();
            }
            this.execute(context);
        }, new Object[0]);
        gui.push("gui", () -> kp.buildMap().displayAsGUI(), new Object[0]);
        gui.open();
    }
}

