/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.resourcepoints.transfer;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.resourcepoints.transfer.CommandResourcePointsTransfer;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandResourcePointsTransferNation
extends KingdomsCommand {
    public CommandResourcePointsTransferNation(KingdomsParentCommand parent) {
        super("nation", parent);
    }

    @Override
    public CommandResult executeX(CommandContext context) {
        CommandResourcePointsTransfer.ResourcePointsTransfer transfer = new CommandResourcePointsTransfer.ResourcePointsTransfer();
        CommandResult result = transfer.handleBasics(context);
        if (result != CommandResult.SUCCESS) {
            return result;
        }
        Kingdom kingdom = context.getKingdom();
        Nation nation = kingdom.getNation();
        long amount = transfer.amount;
        if (!kingdom.hasResourcePoints(amount)) {
            context.sendError(KingdomsLang.COMMAND_RESOURCEPOINTS_NOT_ENOUGH_RESOURCE_POINTS, new Object[0]);
            return CommandResult.FAILED;
        }
        nation.addResourcePoints(amount);
        kingdom.addResourcePoints(-amount);
        context.sendMessage(KingdomsLang.COMMAND_RESOURCEPOINTS_TRANSFER_SUCCESS_NATION, new Object[0]);
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return CommandResourcePointsTransferNation.tabComplete("<amount>");
        }
        return CommandResourcePointsTransferNation.emptyTab();
    }
}

