/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.nation.CommandNationRename;
import org.kingdoms.commands.nation.spawn.CommandNationSetSpawn;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.string.StringUtils;

public class CommandNationCreate
extends KingdomsCommand {
    private static final Cooldown<Integer> CONFIRMATION_COOLDOWN = new Cooldown();

    public CommandNationCreate(KingdomsParentCommand parent) {
        super("create", parent);
    }

    @Override
    public void execute(CommandContext context) {
        Land land;
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.getRank().isKing()) {
            context.fail(KingdomsLang.COMMAND_NATION_CREATE_KING_ONLY, new Object[0]);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom.hasNation()) {
            KingdomsLang.COMMAND_NATION_CREATE_ALREADY_IN_NATION.sendMessage((CommandSender)player);
            return;
        }
        String name = context.arg(0);
        if (context.assertArgs(2)) {
            name = StringUtils.buildArguments(context.args, KingdomsConfig.NATION_NAME_ALLOW_SPACES.getBoolean() ? " " : "");
        }
        if (!kp.isAdmin()) {
            double cost;
            if (!CommandNationRename.checkName(name, player)) {
                return;
            }
            if (ServiceHandler.bankServiceAvailable() && (cost = KingdomsConfig.ECONOMY_COSTS_CREATE_NATION.getDouble()) > 0.0) {
                if (!ServiceVault.hasMoney((OfflinePlayer)player, cost)) {
                    KingdomsLang.COMMAND_NATION_CREATE_COST.sendMessage((CommandSender)player, "cost", cost);
                    return;
                }
                if (!CONFIRMATION_COOLDOWN.add((Integer)player.getEntityId(), KingdomsConfig.ECONOMY_CREATE_CONFIRMATION.getTimeMillis())) {
                    KingdomsLang.COMMAND_CREATE_CONFIRMATION.sendMessage((CommandSender)player, "cost", cost);
                    return;
                }
                ServiceVault.withdraw((OfflinePlayer)player, cost);
            }
        }
        Nation nation = new Nation(kingdom, name);
        long protection = KingdomsConfig.CREATION_NATIONS_NEWBIE_PROTECTION.getTimeMillis(TimeUnit.HOURS);
        if (protection > 0L) {
            kingdom.activateShield(protection);
        }
        if (KingdomsConfig.ANNOUNCEMENTS_CREATE_NATION.getBoolean()) {
            for (Player online : Bukkit.getOnlinePlayers()) {
                KingdomsLang.COMMAND_NATION_CREATE_ANNOUNCE.sendMessage((CommandSender)online, (OfflinePlayer)player, new Object[]{"nation", name});
            }
        } else {
            KingdomsLang.COMMAND_NATION_CREATE_SUCCESS.sendMessage((CommandSender)player, "nation", name);
        }
        XSound.play(player, KingdomsConfig.CREATION_NATIONS_SOUND.getString());
        boolean claimed = kingdom.isClaimed(SimpleChunkLocation.of(player.getLocation()));
        if (KingdomsConfig.HOME_SET_ON_CREATE.getBoolean()) {
            if (KingdomsConfig.HOME_CLAIMED.getBoolean()) {
                if (claimed) {
                    CommandNationSetSpawn.setSpawn(nation, kp, player.getLocation().clone().add(0.0, 1.0, 0.0));
                }
            } else {
                CommandNationSetSpawn.setSpawn(nation, kp, player.getLocation().clone().add(0.0, 1.0, 0.0));
            }
        }
        if (KingdomsConfig.NEXUS_PLACE_ON_CREATE.getBoolean() && claimed && ((land = Land.getLand(player.getLocation())) == null || land.getStructures().isEmpty()) && !LocationUtils.exceedsBuildLimit(player.getLocation())) {
            nation.placeOrMoveNexus(player.getLocation(), kp);
        }
        CONFIRMATION_COOLDOWN.stop(player.getEntityId());
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return Collections.singletonList("<name>");
        }
        return new ArrayList<String>();
    }
}

