/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;

public class CommandNationTop
extends KingdomsCommand {
    public CommandNationTop(KingdomsParentCommand parent) {
        super("top", parent);
    }

    @Override
    public void execute(CommandContext context) {
        String[] args = context.args;
        CommandSender sender = context.getSender();
        KingdomsLang.COMMAND_NATION_TOP_LOADING.sendMessage(sender);
        Kingdoms.taskScheduler().async().execute(() -> {
            int page = args.length == 0 ? 1 : context.getInt(0);
            int nextPage = page + 1;
            int previousPage = page - 1;
            Object[] edits = new Object[]{"page", page, "next_page", nextPage, "previous_page", previousPage};
            if (page - 1 < 0) {
                KingdomsLang.COMMAND_NATION_TOP_NEGATIVE.sendMessage(sender, edits);
                return;
            }
            int limit = KingdomsConfig.TOP_NATIONS_AMOUNT.getInt();
            int skip = (page - 1) * limit;
            List<Nation> nations = KingdomsDataCenter.get().getNationManager().getTopNations(skip, limit);
            if (nations.isEmpty()) {
                KingdomsLang.COMMAND_NATION_TOP_NO_MORE_PAGES.sendMessage(sender, edits);
                return;
            }
            KingdomsLang.COMMAND_NATION_TOP_HEADER.sendMessage(sender);
            int ranking = skip;
            for (Nation nation : nations) {
                int finalRanking = ++ranking;
                KingdomsLang.COMMAND_NATION_TOP_ENTRY.sendMessage(context.getSender(), new MessageBuilder().withContext(nation).raws("rank", finalRanking, "page", page, "next_page", nextPage, "previous_page", previousPage));
            }
            KingdomsLang.COMMAND_NATION_TOP_FOOTER.sendMessage(sender, edits);
        });
    }
}

