/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.relations;

import java.util.List;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.RelationUtil;

public class HandlerNationRel
extends KingdomsCommand {
    private final KingdomRelation relation;
    private final boolean needsRequest;

    private HandlerNationRel(KingdomsParentCommand parent, KingdomRelation relation) {
        super(relation.name().toLowerCase(Locale.ENGLISH), parent);
        this.relation = relation;
        this.needsRequest = relation != KingdomRelation.ENEMY;
    }

    public static void register(KingdomsParentCommand parent) {
        new HandlerNationRel(parent, KingdomRelation.ALLY);
        new HandlerNationRel(parent, KingdomRelation.TRUCE);
        new HandlerNationRel(parent, KingdomRelation.ENEMY);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return;
        }
        Nation nation = kingdom.getNation();
        if (nation == null) {
            context.sendError(KingdomsLang.NO_NATION, new Object[0]);
            return;
        }
        int maxRelations = RelationUtil.maxRelationsExceeded(nation, this.relation);
        if (maxRelations > 0) {
            context.sendError(this.lang("limit"), "max", maxRelations);
            return;
        }
        Nation to = Nation.getNation(context.arg(0));
        if (to == null) {
            KingdomsLang.NOT_FOUND_NATION.sendMessage((CommandSender)player, "nation", context.arg(0));
            return;
        }
        context.var("nation", to.getName());
        if (nation.getId().equals(to.getId())) {
            context.sendError(this.lang("self"), "nation", to.getName());
            return;
        }
        if (nation.getRelationWith(to) == this.relation) {
            context.sendError(this.lang("already"), "nation", to.getName());
            return;
        }
        if (to.getRelationshipRequests().containsKey(nation.getId())) {
            context.sendError(this.lang("already-requested"), "nation", to.getName());
            return;
        }
        KingdomRelationshipRequest request = nation.getRelationshipRequests().remove(to.getId());
        if (!this.needsRequest || request != null) {
            if (this.needsRequest && request.getRelation() != this.relation) {
                context.sendError(this.lang("another-request"), "nation", to.getName(), "relation", this.relation.getColor() + this.relation.getName().buildPlain(context.getSettings()));
                return;
            }
            if (RelationUtil.event(kp, nation, to, this.relation)) {
                return;
            }
            for (Player member : nation.getOnlineMembers()) {
                context.sendMessage((CommandSender)member, this.lang("success"), new Object[0]);
            }
            for (Player member : to.getOnlineMembers()) {
                context.sendMessage((CommandSender)member, this.lang("success"), new Object[0]);
            }
            nation.getRelations().put(to.getId(), this.relation);
            to.getRelations().put(nation.getId(), this.relation);
            to.getRelationshipRequests().remove(nation.getId());
            RelationUtil.eachOther(nation, to, this.relation);
            return;
        }
        nation.sendRelationshipRequest(kp, to, this.relation);
        context.sendMessage(this.lang("sender"), new Object[0]);
        for (Player member : to.getOnlineMembers()) {
            context.sendMessage((CommandSender)member, this.lang("receiver"), new Object[0]);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isPlayer()) {
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return HandlerNationRel.emptyTab();
            }
            Nation nation = kingdom.getNation();
            if (nation == null) {
                return HandlerNationRel.emptyTab();
            }
            return context.getNations(0, null);
        }
        return HandlerNationRel.emptyTab();
    }
}

