/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.config.managers;

import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.config.managers.FileWatchEvent;
import org.kingdoms.config.managers.FileWatcher;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.objects.GUIObject;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.placeholders.StandardKingdomsPlaceholder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.ResourcePointManager;
import org.kingdoms.scheduler.ScheduledTask;
import org.kingdoms.utils.cache.CacheHandler;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.internal.ExpirableSet;

public final class ConfigWatcher {
    protected static final WatchService WATCH_SERVICE;
    private static final ExpirableSet<String> HANDLER_COOLDOWN;
    private static final Cache<String, ScheduledTask> DELAYED_FTP_UPLOADS;
    private static final Map<WatchKey, BiConsumer<Path, WatchEvent.Kind<?>>> WATCHED_KEYS;
    private static final Kingdoms plugin;
    private static final Path PLUGIN_FOLDER_PATH;
    private static final String WINSCP_FILEPARTS_EXTENSION = ".filepart";
    private static boolean accepting;
    protected static final Map<String, FileWatcher> NORMAL_WATCHERS;

    public static void setAccepting(boolean accepting) {
        ConfigWatcher.accepting = accepting;
    }

    public static void reload(YamlResource config, String file) {
        MessageHandler.sendConsolePluginMessage("&2Detected changes for&6 " + file + "&2, reloading...");
        config.reload();
        if (KingdomsConfig.UPDATES_CONFIGS.getBoolean()) {
            config.update();
        }
        ConfigManager.validate(config);
    }

    public static WatchKey register(Path dir, BiConsumer<Path, WatchEvent.Kind<?>> handler) {
        try {
            WatchKey key = dir.register(WATCH_SERVICE, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            WATCHED_KEYS.put(key, handler);
            return key;
        }
        catch (IOException e) {
            KLogger.warn("Failed to register config watchers for: " + dir);
            throw new RuntimeException(e);
        }
    }

    public static void unregister(WatchKey key) {
        Objects.requireNonNull(key);
        key.cancel();
        WATCHED_KEYS.remove(key);
    }

    public static void registerGUIWatchers(SupportedLanguage language) {
        Path guiPath = language.getGUIFolder();
        if (!Files.exists(guiPath, new LinkOption[0])) {
            return;
        }
        final BiConsumer<Path, WatchEvent.Kind<?>> handler = ConfigWatcher.generateGUIHandlerForLang(language);
        try {
            Files.walkFileTree(guiPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    ConfigWatcher.register(dir, handler);
                    return super.preVisitDirectory(dir, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static void setupWatchService() {
        if (WATCH_SERVICE == null) {
            return;
        }
        Path mainDir = Kingdoms.getFolder();
        ConfigWatcher.register(mainDir, ConfigWatcher::handleNormalConfigs);
        ConfigWatcher.register(mainDir.resolve("Turrets"), ConfigWatcher::handleTurrets);
        ConfigWatcher.register(mainDir.resolve("Structures"), ConfigWatcher::handleStructures);
        ConfigWatcher.register(LanguageManager.LANG_FOLDER, ConfigWatcher::handleLanguageFile);
        for (SupportedLanguage lang : SupportedLanguage.VALUES) {
            if (!lang.isInstalled()) continue;
            ConfigWatcher.registerGUIWatchers(lang);
        }
        Kingdoms.taskScheduler().executeAsync(ConfigWatcher::processWatchedKeys);
    }

    protected static void beforeWrite(YamlContainer adapter) {
        String name = Kingdoms.getFolder().relativize(adapter.getFile().toPath()).toString();
        name = ConfigWatcher.toCooldownHandlerName(name);
        HANDLER_COOLDOWN.add(name);
    }

    static String toCooldownHandlerName(String path) {
        return path.substring(0, path.length() - 4);
    }

    static void processWatchedKeys() {
        while (true) {
            WatchKey key;
            try {
                key = WATCH_SERVICE.take();
            }
            catch (InterruptedException | ClosedWatchServiceException e) {
                KLogger.info("Config watcher service has stopped.");
                break;
            }
            List<WatchEvent<?>> events = key.pollEvents();
            if (accepting) {
                for (WatchEvent<?> event : events) {
                    long size;
                    Path resolvedPath;
                    Path relativePath;
                    String shortName;
                    Path eventPath = (Path)event.context();
                    if (eventPath.toString().endsWith(WINSCP_FILEPARTS_EXTENSION) || HANDLER_COOLDOWN.contains(shortName = ConfigWatcher.toCooldownHandlerName((relativePath = PLUGIN_FOLDER_PATH.relativize(resolvedPath = ((Path)key.watchable()).resolve(eventPath))).toString()))) continue;
                    boolean wasDeleted = event.kind() == StandardWatchEventKinds.ENTRY_DELETE || !Files.exists(resolvedPath, new LinkOption[0]);
                    try {
                        if (Files.isDirectory(resolvedPath, new LinkOption[0]) || Files.isHidden(resolvedPath)) {
                            continue;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        size = wasDeleted ? -100L : Files.size(resolvedPath);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        size = -10000000L;
                    }
                    ScheduledTask previousFTPHandler = (ScheduledTask)DELAYED_FTP_UPLOADS.getIfPresent((Object)shortName);
                    if (previousFTPHandler != null) {
                        previousFTPHandler.cancel();
                    }
                    if (previousFTPHandler != null || !wasDeleted && size <= 0L) {
                        DELAYED_FTP_UPLOADS.put((Object)shortName, (Object)Kingdoms.taskScheduler().asyncLater(Duration.ofSeconds(5L), () -> {
                            try {
                                DELAYED_FTP_UPLOADS.invalidate((Object)shortName);
                                BiConsumer<Path, WatchEvent.Kind<?>> handler = WATCHED_KEYS.get(key);
                                Objects.requireNonNull(handler, () -> "Handler for file " + resolvedPath + " (" + eventPath + ") is null");
                                handler.accept(relativePath, event.kind());
                            }
                            catch (Throwable ex) {
                                KLogger.error("Failed to handle FTP automatic reload for file: " + relativePath);
                                ex.printStackTrace();
                            }
                        }));
                        continue;
                    }
                    HANDLER_COOLDOWN.add(shortName);
                    try {
                        BiConsumer<Path, WatchEvent.Kind<?>> handler = WATCHED_KEYS.get(key);
                        Objects.requireNonNull(handler, () -> "Handler for file " + resolvedPath + " (" + eventPath + ") is null");
                        handler.accept(relativePath, event.kind());
                    }
                    catch (Throwable ex) {
                        KLogger.error("Failed to handle automatic reload for file: " + relativePath);
                        ex.printStackTrace();
                    }
                }
            }
            key.reset();
        }
    }

    static void handleStructures(Path path, WatchEvent.Kind<?> kind) {
        Path mainDir = plugin.getDataFolder().toPath();
        Path structureDir = mainDir.relativize(mainDir.resolve("Structures"));
        path = structureDir.relativize(path);
        String file = path.toString();
        file = file.substring(0, file.length() - 4);
        StructureStyle style = StructureRegistry.getStyle(file);
        MessageHandler.sendConsolePluginMessage("&2Detected changes for structure&8: &9" + file + (style == null ? " &4which is not a registered structure style, ignoring." : ""));
        if (style != null) {
            style.getConfig().reload();
            StructureRegistry.validate(file, style.getConfig());
            style.loadSettings();
        }
    }

    static void handleTurrets(Path path, WatchEvent.Kind<?> kind) {
        Path mainDir = plugin.getDataFolder().toPath();
        Path turretsDir = mainDir.relativize(mainDir.resolve("Turrets"));
        path = turretsDir.relativize(path);
        String file = path.toString();
        file = file.substring(0, file.length() - 4);
        TurretStyle style = TurretRegistry.getStyle(file);
        MessageHandler.sendConsolePluginMessage("&2Detected changes for turret&8: &9" + file + (style == null ? " &4which is not a registered turret style, ignoring." : ""));
        if (style != null) {
            style.getAdapter().reload();
            TurretRegistry.validate(file, style.getAdapter());
            style.loadSettings();
        }
    }

    static void handleLanguageFile(Path path, WatchEvent.Kind<?> kind) {
        String file = path.getFileName().toString();
        SupportedLanguage lang = LanguageManager.getLanguageOrWarn(file = file.substring(0, file.length() - 4));
        if (lang == null) {
            return;
        }
        if (!lang.isInstalled()) {
            return;
        }
        MessageHandler.sendConsolePluginMessage("&2Detected changes for language file&8: &9" + file);
        LanguageManager.load(lang);
    }

    public static BiConsumer<Path, WatchEvent.Kind<?>> generateGUIHandlerForLang(final SupportedLanguage language) {
        return new BiConsumer<Path, WatchEvent.Kind<?>>(){
            private final Path folder;
            {
                this.folder = Kingdoms.getFolder().relativize(GUIConfig.getFolder().resolve(language.getLowerCaseName()));
            }

            @Override
            public void accept(Path paths, WatchEvent.Kind<?> kind) {
                if (!language.isInstalled()) {
                    return;
                }
                Path relative = this.folder.relativize(paths);
                if (Files.isDirectory(relative, new LinkOption[0]) || !relative.toString().endsWith(".yml")) {
                    return;
                }
                String guiName = relative.toString().replace('\\', '/');
                guiName = guiName.substring(0, guiName.length() - 4);
                GUIObject gui = language.getGUI(guiName);
                boolean isRegistered = SupportedLanguage.EN.getGUI(guiName) != null;
                MessageHandler.sendConsolePluginMessage("&2Detected changes for GUI&8: &9" + language.getLowerCaseName() + '/' + guiName + (!isRegistered ? " &8(&4which is an unknown GUI&8)" : ""));
                if (gui == null) {
                    Path path = language.getGUIFolder().resolve(guiName + ".yml");
                    File repoFile = language.getRepoPath().resolve("guis").resolve(guiName + ".yml").toFile();
                    YamlWithDefaults adapter = GUIConfig.createAdapter(path.toFile(), repoFile);
                    GUIConfig.loadAndRegisterGUI(language, adapter, guiName);
                } else {
                    GUIConfig.reload(gui, language);
                }
            }
        };
    }

    public static void handleNormalConfigs(Path path, WatchEvent.Kind<?> kind) {
        String file = path.toString();
        String simpleConfigName = file.toLowerCase(Locale.ENGLISH).replace('\\', '/').substring(0, file.length() - ".yml".length());
        FileWatcher custom = NORMAL_WATCHERS.get(simpleConfigName);
        if (custom != null) {
            custom.handle(new FileWatchEvent(path, kind));
            return;
        }
        switch (simpleConfigName) {
            case "config": {
                ConfigWatcher.reload(KingdomsConfig.MAIN, file);
                StandardKingdomsPlaceholder.init();
                return;
            }
            case "claims": {
                ConfigWatcher.reload(KingdomsConfig.CLAIMS, file);
                return;
            }
            case "invasions": {
                ConfigWatcher.reload(KingdomsConfig.INVASIONS, file);
                return;
            }
            case "map": {
                ConfigWatcher.reload(KingdomsConfig.MAP, file);
                return;
            }
            case "ranks": {
                ConfigWatcher.reload(KingdomsConfig.RANKS, file);
                Rank.init();
                return;
            }
            case "structures": {
                ConfigWatcher.reload(KingdomsConfig.STRUCTURES, file);
                StructureRegistry.getStyles().values().forEach(style -> {
                    style.getConfig().reload();
                    style.loadSettings();
                });
                return;
            }
            case "turrets": {
                ConfigWatcher.reload(KingdomsConfig.TURRETS, file);
                return;
            }
            case "protection-signs": {
                ConfigWatcher.reload(KingdomsConfig.PROTECTION_SIGNS, file);
                return;
            }
            case "relations": {
                ConfigWatcher.reload(KingdomsConfig.RELATIONS, file);
                KingdomRelation.init();
                return;
            }
            case "champion-upgrades": {
                ConfigWatcher.reload(KingdomsConfig.CHAMPION_UPGRADES, file);
                return;
            }
            case "misc-upgrades": {
                ConfigWatcher.reload(KingdomsConfig.MISC_UPGRADE, file);
                return;
            }
            case "chat": {
                ConfigWatcher.reload(KingdomsConfig.CHAT, file);
                KingdomsChatChannel.registerChannels();
                return;
            }
            case "powers": {
                ConfigWatcher.reload(KingdomsConfig.POWERS, file);
                Powerup.init();
                return;
            }
            case "resource-points": {
                ConfigWatcher.reload(KingdomsConfig.RESOURCE_POINTS, file);
                ResourcePointManager.loadSettings();
                return;
            }
        }
    }

    static {
        WatchService watchService;
        HANDLER_COOLDOWN = new ExpirableSet(3L, TimeUnit.SECONDS, false);
        DELAYED_FTP_UPLOADS = CacheHandler.newBuilder().expireAfterWrite(Duration.ofSeconds(5L)).build();
        WATCHED_KEYS = new IdentityHashMap();
        plugin = Kingdoms.get();
        PLUGIN_FOLDER_PATH = plugin.getDataFolder().toPath();
        accepting = true;
        Path basePath = Kingdoms.get().getDataFolder().toPath().toAbsolutePath();
        try {
            watchService = basePath.getFileSystem().newWatchService();
        }
        catch (IOException e) {
            KLogger.error("Failed to register config file watchers:");
            e.printStackTrace();
            watchService = null;
        }
        WATCH_SERVICE = watchService;
        NORMAL_WATCHERS = new HashMap<String, FileWatcher>();
    }
}

