/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.lands;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.internal.FastUUID;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0016\u0010,\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0016J\u0016\u00100\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020201H\u0016R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00063"}, d2={"Lorg/kingdoms/constants/group/model/logs/lands/LogKingdomInvade;", "Lorg/kingdoms/constants/group/model/logs/AuditLog;", "invasion", "Lorg/kingdoms/managers/invasions/Invasion;", "(Lorg/kingdoms/managers/invasions/Invasion;)V", "()V", "affectedLands", "", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "getAffectedLands", "()Ljava/util/Set;", "setAffectedLands", "(Ljava/util/Set;)V", "correspondingKingdom", "Ljava/util/UUID;", "getCorrespondingKingdom", "()Ljava/util/UUID;", "setCorrespondingKingdom", "(Ljava/util/UUID;)V", "invaderPlayer", "getInvaderPlayer", "setInvaderPlayer", "ransackMode", "", "getRansackMode", "()Z", "setRansackMode", "(Z)V", "result", "Lorg/kingdoms/managers/invasions/Invasion$Result;", "getResult", "()Lorg/kingdoms/managers/invasions/Invasion$Result;", "setResult", "(Lorg/kingdoms/managers/invasions/Invasion$Result;)V", "startLocation", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "getStartLocation", "()Lorg/kingdoms/constants/land/location/SimpleLocation;", "setStartLocation", "(Lorg/kingdoms/constants/land/location/SimpleLocation;)V", "addEdits", "", "builder", "Lorg/kingdoms/locale/provider/MessageBuilder;", "deserialize", "context", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "core"})
public abstract class LogKingdomInvade
extends AuditLog {
    private boolean ransackMode;
    public Set<? extends SimpleChunkLocation> affectedLands;
    public SimpleLocation startLocation;
    public UUID invaderPlayer;
    public UUID correspondingKingdom;
    public Invasion.Result result;

    public LogKingdomInvade() {
    }

    public final boolean getRansackMode() {
        return this.ransackMode;
    }

    public final void setRansackMode(boolean bl) {
        this.ransackMode = bl;
    }

    @NotNull
    public final Set<SimpleChunkLocation> getAffectedLands() {
        Set<SimpleChunkLocation> set = this.affectedLands;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"affectedLands");
        return null;
    }

    public final void setAffectedLands(@NotNull Set<? extends SimpleChunkLocation> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.affectedLands = set;
    }

    @NotNull
    public final SimpleLocation getStartLocation() {
        SimpleLocation simpleLocation = this.startLocation;
        if (simpleLocation != null) {
            return simpleLocation;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"startLocation");
        return null;
    }

    public final void setStartLocation(@NotNull SimpleLocation simpleLocation) {
        Intrinsics.checkNotNullParameter((Object)simpleLocation, (String)"<set-?>");
        this.startLocation = simpleLocation;
    }

    @NotNull
    public final UUID getInvaderPlayer() {
        UUID uUID = this.invaderPlayer;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"invaderPlayer");
        return null;
    }

    public final void setInvaderPlayer(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.invaderPlayer = uUID;
    }

    @NotNull
    public final UUID getCorrespondingKingdom() {
        UUID uUID = this.correspondingKingdom;
        if (uUID != null) {
            return uUID;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"correspondingKingdom");
        return null;
    }

    public final void setCorrespondingKingdom(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.correspondingKingdom = uUID;
    }

    @NotNull
    public final Invasion.Result getResult() {
        Invasion.Result result = this.result;
        if (result != null) {
            return result;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"result");
        return null;
    }

    public final void setResult(@NotNull Invasion.Result result) {
        Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"<set-?>");
        this.result = result;
    }

    public LogKingdomInvade(@NotNull Invasion invasion) {
        Intrinsics.checkNotNullParameter((Object)invasion, (String)"invasion");
        this();
        this.ransackMode = invasion.isRansackMode();
        Set<SimpleChunkLocation> set = invasion.getAffectedLands();
        Intrinsics.checkNotNullExpressionValue(set, (String)"invasion.affectedLands");
        this.setAffectedLands(set);
        SimpleLocation simpleLocation = SimpleLocation.of(invasion.getStartLocation());
        Intrinsics.checkNotNullExpressionValue((Object)simpleLocation, (String)"of(invasion.startLocation)");
        this.setStartLocation(simpleLocation);
        UUID uUID = invasion.getInvaderPlayer().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"invasion.invaderPlayer.uniqueId");
        this.setInvaderPlayer(uUID);
        UUID uUID2 = invasion.getDefender().getDataKey();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"invasion.defender.dataKey");
        this.setCorrespondingKingdom(uUID2);
        Invasion.Result result = invasion.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)result), (String)"invasion.result");
        this.setResult(result);
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.ransackMode = json.get("ransackMode").asBoolean();
        SimpleLocation simpleLocation = SimpleLocation.fromString(json.get("startLocation").asString());
        Intrinsics.checkNotNullExpressionValue((Object)simpleLocation, (String)"fromString(json[\"startLocation\"].asString())");
        this.setStartLocation(simpleLocation);
        this.setAffectedLands(json.get("affectedLands").asCollection((Collection)new HashSet(), LogKingdomInvade::deserialize$lambda-0));
        UUID uUID = FastUUID.fromString(json.get("invaderPlayer").asString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(json[\"invaderPlayer\"].asString())");
        this.setInvaderPlayer(uUID);
        UUID uUID2 = FastUUID.fromString(json.get("correspondingKingdom").asString());
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(json[\"corresp\u2026dingKingdom\"].asString())");
        this.setCorrespondingKingdom(uUID2);
        String string = json.get("result").asString();
        Intrinsics.checkNotNull((Object)string);
        this.setResult(Invasion.Result.valueOf(string));
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        SectionableDataSetter $this$serialize_u24lambda_u2d2 = sectionableDataSetter = context.getDataProvider();
        boolean bl = false;
        $this$serialize_u24lambda_u2d2.setBoolean("ransackMode", this.ransackMode);
        $this$serialize_u24lambda_u2d2.setString("startLocation", this.getStartLocation().toString());
        $this$serialize_u24lambda_u2d2.get("affectedLands").setCollection((Collection)this.getAffectedLands(), LogKingdomInvade::serialize$lambda-2$lambda-1);
        $this$serialize_u24lambda_u2d2.setUUID("invaderPlayer", this.getInvaderPlayer());
        $this$serialize_u24lambda_u2d2.setUUID("correspondingKingdom", this.getCorrespondingKingdom());
        $this$serialize_u24lambda_u2d2.setString("result", this.getResult().name());
    }

    @Override
    public void addEdits(@NotNull MessageBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.addEdits(builder);
        builder.raw("ransack-mode", this.ransackMode ? KingdomsLang.ENABLED.parse(new Object[0]) : KingdomsLang.DISABLED.parse(new Object[0]));
        builder.parse("affected-lands", "{$s}" + CollectionsKt.joinToString$default((Iterable)this.getAffectedLands(), (CharSequence)"{$sep},\n {$s}", null, null, (int)0, null, null, (int)62, null));
        builder.parse("start-location", LocationUtils.parseLocation(this.getStartLocation()));
        builder.parse("chunk", LocationUtils.parseChunk(this.getStartLocation().toSimpleChunkLocation()));
        String string = this.getResult().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        builder.parse("result", string);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.getInvaderPlayer());
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getOfflinePlayer(invaderPlayer)");
        OfflinePlayer invaderPlayer = offlinePlayer;
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer(invaderPlayer);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(invaderPlayer)");
        KingdomPlayer invaderPlayerKp = kingdomPlayer;
        Kingdom kingdom = Kingdom.getKingdom(this.getCorrespondingKingdom());
        if (Intrinsics.areEqual((Object)this.getCorrespondingKingdom(), (Object)invaderPlayerKp.getKingdomId())) {
            builder.withContext(invaderPlayer);
        } else {
            builder.withContext(kingdom);
        }
    }

    private static final void deserialize$lambda-0(HashSet c, SectionableDataGetter ele) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        c.add(ele.asSimpleChunkLocation());
    }

    private static final void serialize$lambda-2$lambda-1(SectionCreatableDataSetter eleProvider, SimpleChunkLocation ele) {
        Intrinsics.checkNotNullParameter((Object)eleProvider, (String)"eleProvider");
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        eleProvider.setSimpleChunkLocation(ele);
    }
}

