/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc.challenge;

import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.group.model.logs.misc.challenge.LogKingdomChallenger;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.time.TimeUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0016\u0010\u0013\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/constants/group/model/logs/misc/challenge/LogKingdomChallenge;", "Lorg/kingdoms/constants/group/model/logs/misc/LogPlayerOperator;", "()V", "kingdom", "Lorg/kingdoms/constants/group/Kingdom;", "challenger", "Lorg/kingdoms/constants/player/KingdomPlayer;", "startTime", "", "(Lorg/kingdoms/constants/group/Kingdom;Lorg/kingdoms/constants/player/KingdomPlayer;J)V", "Ljava/util/UUID;", "addEdits", "", "builder", "Lorg/kingdoms/locale/provider/MessageBuilder;", "deserialize", "context", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "core"})
public abstract class LogKingdomChallenge
extends LogPlayerOperator {
    private UUID kingdom;
    private long startTime;

    protected LogKingdomChallenge() {
    }

    public LogKingdomChallenge(@NotNull Kingdom kingdom, @NotNull KingdomPlayer challenger, long startTime) {
        Intrinsics.checkNotNullParameter((Object)kingdom, (String)"kingdom");
        Intrinsics.checkNotNullParameter((Object)challenger, (String)"challenger");
        super(challenger.getId());
        UUID uUID = kingdom.getDataKey();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"kingdom.dataKey");
        this.kingdom = uUID;
        this.startTime = startTime;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        UUID uUID = json.get("kingdom").asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        this.kingdom = uUID;
        this.startTime = json.get("startTime").asLong();
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        UUID uUID = this.kingdom;
        if (uUID == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"kingdom");
            uUID = null;
        }
        json.setUUID("kingdom", uUID);
        json.setLong("startTime", this.startTime);
    }

    @Override
    public void addEdits(@NotNull MessageBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.addEdits(builder);
        builder.raw("start_time", TimeUtils.getDateAndTime(this.startTime));
        OfflinePlayer offlinePlayer = this.getPlayer().getOfflinePlayer();
        Intrinsics.checkNotNullExpressionValue((Object)offlinePlayer, (String)"getPlayer().offlinePlayer");
        OfflinePlayer player = offlinePlayer;
        KingdomPlayer kingdomPlayer = KingdomPlayer.getKingdomPlayer(player);
        Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayer, (String)"getKingdomPlayer(player)");
        KingdomPlayer kp = kingdomPlayer;
        if (this instanceof LogKingdomChallenger) {
            UUID uUID = this.kingdom;
            if (uUID == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"kingdom");
                uUID = null;
            }
            Kingdom kingdom = Kingdom.getKingdom(uUID);
            builder.withContext(player).other(kingdom);
        } else {
            UUID uUID = kp.getKingdomId();
            UUID uUID2 = this.kingdom;
            if (uUID2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"kingdom");
                uUID2 = null;
            }
            if (!Intrinsics.areEqual((Object)uUID, (Object)uUID2)) {
                UUID uUID3 = this.kingdom;
                if (uUID3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"kingdom");
                    uUID3 = null;
                }
                Kingdom kingdom = Kingdom.getKingdom(uUID3);
                builder.withContext(kingdom).raw("player", player.getName());
            } else {
                builder.withContext(player);
            }
        }
    }
}

