/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.purchases.kingdomitem;

import java.util.UUID;
import org.kingdoms.constants.group.model.logs.purchases.LogResourcePoints;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.provider.MessageBuilder;

public abstract class LogKingdomItemPurchase
extends LogResourcePoints {
    private KingdomItemStyle<?, ?, ?> style;
    private int amount;

    public LogKingdomItemPurchase() {
    }

    public LogKingdomItemPurchase(long resourcePoints, UUID player, KingdomItemStyle<?, ?, ?> style, int amount) {
        super(resourcePoints, player);
        this.style = style;
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.amount = json.get("amount").asInt();
        this.style = this.getStyleFromString(json.get("style").asString());
    }

    public KingdomItemStyle<?, ?, ?> getStyle() {
        return this.style;
    }

    protected abstract KingdomItemStyle<?, ?, ?> getStyleFromString(String var1);

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setInt("amount", this.amount);
        json.setString("style", this.style.getName());
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        builder.raw("amount", this.amount);
        builder.raw("item_style_display_name", this.style.getDisplayName());
    }
}

