/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.purchases.kingdomitem;

import java.util.UUID;
import org.kingdoms.constants.group.model.logs.purchases.LogKingdomUpgrade;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.LanguageEntryWithContext;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.LocationUtils;

public abstract class LogKingdomItemUpgrade
extends LogKingdomUpgrade {
    private SimpleLocation location;
    private String name;
    private KingdomItemStyle<?, ?, ?> style;

    public LogKingdomItemUpgrade() {
    }

    public LogKingdomItemUpgrade(long resourcePoints, UUID player, int oldLevel, int newLevel, SimpleLocation location, String name, KingdomItemStyle<?, ?, ?> style) {
        super(resourcePoints, player, oldLevel, newLevel);
        this.location = location;
        this.name = name;
        this.style = style;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.location = json.get("location").asSimpleLocation();
        this.style = this.getStyleFromString(json.get("style").asString());
        String name = json.get("name").asString();
        if (name != null) {
            this.name = name;
        }
    }

    protected abstract KingdomItemStyle<?, ?, ?> getStyleFromString(String var1);

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.get("location").setSimpleLocation(this.location);
        json.setString("name", this.name);
        json.setString("style", this.style.getName());
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        builder.raw("location", new LanguageEntryWithContext(KingdomsLang.LOCATIONS_NORMAL, LocationUtils.getLocationEdits(this.location, "")));
        builder.parse("item_name", this.name);
        builder.raw("item_style_display_name", this.style.getDisplayName());
    }
}

