/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable;

import org.kingdoms.config.EnumConfig;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.upgradable.StandardKingdomUpgrade;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.string.StringUtils;

public enum Powerup implements StandardKingdomUpgrade
{
    DAMAGE_BOOST,
    DAMAGE_REDUCTION,
    REGENERATION_BOOST,
    ARROW_BOOST;

    public static final Powerup[] VALUES;
    private boolean ownLandOnly;

    public static void init() {
        for (Powerup powerup : Powerup.values()) {
            powerup.ownLandOnly = KingdomsConfig.Powers.POWERUPS_OWN_LAND_ONLY.getManager().withOption("upgrade", StringUtils.configOption(powerup)).getBoolean();
        }
    }

    public String toString() {
        return StringUtils.capitalize(this.name());
    }

    @Override
    public String getDataName() {
        return this.name();
    }

    public boolean isOwnLandOnly() {
        return this.ownLandOnly;
    }

    @Override
    public EnumConfig getEnabledOption() {
        return KingdomsConfig.Powers.POWERUPS_ENABLED;
    }

    @Override
    public EnumConfig getScalingOption() {
        return KingdomsConfig.Powers.POWERUPS_SCALING;
    }

    @Override
    public EnumConfig getUpgradeCostOption() {
        return KingdomsConfig.Powers.POWERUPS_COST;
    }

    @Override
    public EnumConfig getMaxLevelOption() {
        return KingdomsConfig.Powers.POWERUPS_MAX_LEVEL;
    }

    @Override
    public EnumConfig getDefaultLevelOption() {
        return KingdomsConfig.Powers.POWERUPS_DEFAULT_LEVEL;
    }

    @Override
    public Messenger getDisplayName() {
        return new LanguageEntryMessenger("upgrades", "powerup", StringUtils.configOption(this.name()), "name");
    }

    static {
        VALUES = Powerup.values();
    }
}

