/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.managers.protectionsign.ProtectionSignManager;
import org.kingdoms.utils.BCrypt;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.internal.ExpirableSet;
import org.kingdoms.utils.internal.FastUUID;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class ProtectionSign
extends KingdomsObject<SimpleLocation> {
    private static final long COOKIES = KingdomsConfig.ProtectionSigns.PASSWORDS_COOKIES.getManager().getTimeMillis();
    private final transient @NonNull SimpleLocation location;
    private final @NonNull SimpleLocation sign;
    private final long since;
    private @Nullable String password;
    private @NonNull UUID owner;
    private @NonNull Map<UUID, Boolean> players;
    private @NonNull Map<UUID, Boolean> kingdoms;
    private transient @NonNull ExpirableSet<UUID> temporarilyTrusted = new ExpirableSet(COOKIES, TimeUnit.MILLISECONDS, true);
    private ProtectionType protectionType;

    public ProtectionSign(@NonNull SimpleLocation location, @NonNull SimpleLocation sign, @NonNull UUID owner, @NonNull ProtectionType protectionType, @Nullable String password, long since, @NonNull Map<UUID, Boolean> players, @NonNull Map<UUID, Boolean> kingdoms) {
        this.location = Objects.requireNonNull(location, "Protection Sign location cannot be null");
        this.sign = Objects.requireNonNull(sign, "Protection Sign's sign location cannot be null");
        this.owner = Objects.requireNonNull(owner, "Protection Sign owner cannot be null");
        this.protectionType = Objects.requireNonNull(protectionType, "Protection type cannot be null");
        this.password = password;
        this.since = since;
        this.players = Objects.requireNonNull(players, "Protection Sign players cannot be null");
        this.kingdoms = Objects.requireNonNull(kingdoms, "Protection Sign kingdoms cannot be null");
    }

    public static boolean isProtected(@NonNull Block block) {
        return ProtectionSign.getProtection(block).isPresent();
    }

    public static boolean canBlockBeProtected(@NonNull Block block) {
        return XBlock.isOneOf(block, KingdomsConfig.ProtectionSigns.BLOCKS.getManager().getStringList());
    }

    public static @NonNull ProtectionSign placeProtection(@Nullable Land land, @NonNull Block block, @NonNull Block sign, @NonNull Player player, ProtectionType protectionType) {
        SimpleLocation location = SimpleLocation.of(block);
        ProtectionSign protection = new ProtectionSign(location, SimpleLocation.of(sign), player.getUniqueId(), protectionType, null, System.currentTimeMillis(), new HashMap<UUID, Boolean>(), new HashMap<UUID, Boolean>());
        if (land == null) {
            land = new Land(location.toSimpleChunkLocation());
        }
        land.getProtectedBlocks().put(location, protection);
        return protection;
    }

    public boolean shouldRemoveProtectionAfterBreak(Block block) {
        return !(block.getState() instanceof Chest) || SimpleLocation.of(block).equalsIgnoreWorld(this.location);
    }

    public static @NonNull Optional<ProtectionSign> getProtection(@NonNull Block block) {
        Objects.requireNonNull(block, "Cannot get protection of a null block");
        if (ProtectionSign.isSign(block)) {
            if ((block = VersionSupport.getAttachedBlock(block)) == null) {
                return Optional.empty();
            }
            SimpleLocation location = SimpleLocation.of(block);
            Land land = location.toSimpleChunkLocation().getLand();
            if (land == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(land.getProtectedBlocks().get(location));
        }
        SimpleLocation location = SimpleLocation.of(block);
        Land land = location.toSimpleChunkLocation().getLand();
        if (land == null) {
            return Optional.empty();
        }
        ProtectionSign protection = land.getProtectedBlocks().get(location);
        if (protection == null) {
            Chest chest;
            Inventory inventory;
            BlockState state = block.getState();
            Block otherHalf = VersionSupport.getOtherHalfIfDoor(state);
            if (otherHalf != null) {
                protection = land.getProtectedBlocks().get(SimpleLocation.of(otherHalf));
            } else if (state instanceof Chest && (inventory = (chest = (Chest)state).getInventory()) instanceof DoubleChestInventory) {
                DoubleChest doubleChest = (DoubleChest)inventory.getHolder();
                Chest leftChest = (Chest)doubleChest.getLeftSide();
                Chest rightChest = (Chest)doubleChest.getRightSide();
                SimpleChunkLocation mainChunk = SimpleChunkLocation.of(block);
                Block rightBlock = rightChest.getBlock();
                SimpleChunkLocation otherChunk = SimpleChunkLocation.of(block = LocationUtils.equalsIgnoreWorld(block, rightBlock) ? leftChest.getBlock() : rightBlock);
                if (!otherChunk.equalsIgnoreWorld(mainChunk) && (land = otherChunk.getLand()) == null) {
                    return Optional.empty();
                }
                location = SimpleLocation.of(block);
                protection = land.getProtectedBlocks().get(location);
            }
        }
        return Optional.ofNullable(protection);
    }

    public static boolean isSign(@NonNull Block block) {
        return block.getType().name().endsWith("SIGN");
    }

    public boolean isContainer() {
        BlockState state = this.getBlock().getState();
        return state instanceof Container;
    }

    public long getSince() {
        return this.since;
    }

    public int hashCode() {
        int prime = 31;
        int result = 14;
        result = prime * result + this.location.hashCode();
        result = prime * result + this.owner.hashCode();
        result = prime * result + this.players.hashCode();
        result = prime * result + this.kingdoms.hashCode();
        result = prime * result + this.protectionType.ordinal();
        return result;
    }

    public void updateSign() {
        List<String> lines = ProtectionSignManager.getProtectionTypeSignLines(this.protectionType);
        Block signBlock = this.sign.getBlock();
        Sign state = (Sign)signBlock.getState();
        MessageBuilder settings = new MessageBuilder().withContext(this.getOwnerPlayer());
        for (int i = 0; i < lines.size(); ++i) {
            String line = MessageCompiler.compile(lines.get(i)).buildPlain(settings);
            state.setLine(i, line);
        }
        state.update();
    }

    @Override
    public @NonNull SimpleLocation getDataKey() {
        return this.location;
    }

    @Override
    public @NonNull String getCompressedData() {
        return FastUUID.toString(this.owner) + this.protectionType.ordinal() + (this.password == null ? "" : this.password) + KingdomsObject.compressMap(this.players, this.players.size() * 16, FastUUID::toString, v -> v != false ? Character.valueOf('1') : "") + KingdomsObject.compressMap(this.kingdoms, this.kingdoms.size() * 16, FastUUID::toString, v -> v != false ? Character.valueOf('1') : "");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtectionSign)) {
            return false;
        }
        ProtectionSign sign = (ProtectionSign)obj;
        return this.protectionType == sign.protectionType && this.owner.equals(sign.owner) && this.location.equals(sign.location);
    }

    public boolean isOwner(@NonNull OfflinePlayer player) {
        return this.owner.equals(player.getUniqueId());
    }

    public @NonNull ProtectionSign removeProtection() {
        Land land = this.location.toSimpleChunkLocation().getLand();
        return land.getProtectedBlocks().remove(this.location);
    }

    public @NonNull UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@NonNull UUID owner) {
        this.owner = Objects.requireNonNull(owner, "Protection Sign owner cannot be null");
    }

    public @NonNull OfflinePlayer getOwnerPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.owner);
    }

    public @NonNull Map<UUID, Boolean> getPlayers() {
        return this.players;
    }

    public void setPlayers(@NonNull Map<UUID, Boolean> players) {
        this.players = Objects.requireNonNull(players, "Protection Sign players cannot be null");
    }

    public @NonNull Map<UUID, Boolean> getKingdoms() {
        return this.kingdoms;
    }

    public void setKingdoms(@NonNull Map<UUID, Boolean> kingdoms) {
        this.kingdoms = Objects.requireNonNull(kingdoms, "Protection Sign kingdoms cannot be null");
    }

    public @NonNull SimpleLocation getSign() {
        return this.sign;
    }

    public AccessResult canAccess(@NonNull OfflinePlayer player) {
        return this.canAccess(player.getUniqueId());
    }

    public AccessResult canAccess(@NonNull UUID player) {
        Boolean kingdomAllowed;
        Objects.requireNonNull(player, "Cannot check protected block access for a null player");
        if (this.owner.equals(player)) {
            return AccessResult.ACCEPTED;
        }
        Boolean allowed = this.players.get(player);
        if (allowed != null) {
            return allowed != false ? AccessResult.ACCEPTED : AccessResult.DENIED;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
        if (kp.hasKingdom() && (kingdomAllowed = this.kingdoms.get(kp.getKingdomId())) != null) {
            return kingdomAllowed != false ? AccessResult.ACCEPTED : AccessResult.DENIED;
        }
        if (this.temporarilyTrusted.contains(player)) {
            return AccessResult.ACCEPTED;
        }
        switch (this.protectionType) {
            case PROTECTED: {
                return this.hasPassword() ? AccessResult.PASSWORD : AccessResult.DENIED;
            }
            case EVERYONE: {
                return AccessResult.ACCEPTED;
            }
            case EVERYONE_IN_KINGDOM: {
                KingdomPlayer ownerKp = KingdomPlayer.getKingdomPlayer(this.owner);
                return Objects.equals(ownerKp.getKingdomId(), kp.getKingdomId()) ? AccessResult.ACCEPTED : (this.hasPassword() ? AccessResult.PASSWORD : AccessResult.DENIED);
            }
        }
        throw new AssertionError((Object)("Unhandled protection type: " + this.protectionType.name()));
    }

    public @NonNull ProtectionType getProtectionType() {
        return this.protectionType;
    }

    public void setProtectionType(@NonNull ProtectionType protectionType) {
        this.protectionType = Objects.requireNonNull(protectionType, "Protection type cannot be null");
    }

    public @NonNull Land getLand() {
        return Objects.requireNonNull(this.location.toSimpleChunkLocation().getLand(), "Unexpected null land data for a protected block");
    }

    public @NonNull SimpleLocation getLocation() {
        return this.location;
    }

    public @NonNull Block getBlock() {
        return this.location.toBukkitLocation().getBlock();
    }

    public @NonNull ExpirableSet<UUID> getTemporarilyTrusted() {
        return this.temporarilyTrusted;
    }

    public void setTemporarilyTrusted(@NonNull ExpirableSet<UUID> temporarilyTrusted) {
        this.temporarilyTrusted = Objects.requireNonNull(temporarilyTrusted, "Temporarily trusted protection sign cannot be null");
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setHashedPassword(@Nullable String password) {
        if (password.isEmpty()) {
            throw new IllegalArgumentException("Hashed password cannot be empty");
        }
        this.password = password;
    }

    public void changePassword(@Nullable String password) {
        this.temporarilyTrusted.clear();
        this.password = password == null ? null : this.hashPassword(password);
    }

    public boolean verifyPassword(@NonNull String password) {
        if (Strings.isNullOrEmpty((String)password)) {
            throw new IllegalArgumentException("Cannot check null or empty password: " + password);
        }
        Objects.requireNonNull(this.password, "Cannot check password for a chest with no password");
        return BCrypt.checkpw(password, this.password);
    }

    public String hashPassword(String password) {
        return BCrypt.hashpw(password, BCrypt.gensalt());
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    public static enum ProtectionType {
        PROTECTED,
        EVERYONE_IN_KINGDOM,
        EVERYONE;


        public String getDisplayname() {
            ConfigAccessor config = KingdomsConfig.PROTECTION_SIGNS.accessor();
            switch (this) {
                case PROTECTED: {
                    return config.getString("displayname");
                }
                case EVERYONE_IN_KINGDOM: {
                    return config.getString("everyone-in-kingdom", "displayname");
                }
                case EVERYONE: {
                    return config.getString("everyone", "displayname");
                }
            }
            throw new AssertionError((Object)("Unhandled protection type displayname: " + this.name()));
        }
    }

    public static enum AccessResult {
        ACCEPTED,
        DENIED,
        PASSWORD;

    }
}

