/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.abstraction;

import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KeyedConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.upgradable.Upgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.KingdomItemType;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.gui.objects.GUIOptionParser;
import org.kingdoms.libs.xseries.SkullUtils;
import org.kingdoms.libs.xseries.XBiome;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.UnsafeLocations;
import org.kingdoms.utils.UnsafeSimpleChunkLocation;
import org.kingdoms.utils.UnsafeSimpleLocation;

public abstract class KingdomItemStyle<I extends KingdomItem<S>, S extends KingdomItemStyle<I, S, T>, T extends KingdomItemType<I, S, T>>
implements Upgrade {
    protected final String name;
    protected final T type;

    public KingdomItemStyle(String name, T type) {
        this.name = name;
        this.type = type;
    }

    public abstract KeyedConfigAccessor getOption(String ... var1);

    private static SimpleLocation createFakeLocation(Kingdom kingdom) {
        Land land = new Land(UnsafeLocations.UNSAFE_CHUNK_LOCATION, null, null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), System.currentTimeMillis());
        land.setKingdom(kingdom.getId());
        return new UnsafeSimpleLocation(new UnsafeSimpleChunkLocation(land));
    }

    public ItemStack buildItem(Kingdom kingdom) {
        KingdomItemBuilder builder = new KingdomItemBuilder(this, KingdomItemStyle.createFakeLocation(kingdom));
        return ((KingdomItem)((KingdomItemType)this.type).build(builder)).getItem(kingdom);
    }

    public boolean hasItem() {
        return this.getOption("item").getSection() != null;
    }

    public T getType() {
        return this.type;
    }

    public void loadSettings() {
    }

    public boolean canBePlacedOn(Block block) {
        XMaterial mat;
        boolean contains;
        List<String> blocks = this.getOption("placing", "blocks").getStringList();
        boolean whitelist = this.getOption("placing", "whitelist").getBoolean();
        return whitelist == (contains = (mat = XMaterial.matchXMaterial(block.getType())).isOneOf(blocks));
    }

    public double getCost(Kingdom kingdom) {
        return MathUtils.eval(this.getOption("cost").getString(), kingdom, new Object[0]);
    }

    @Override
    public double getUpgradeCost(PlaceholderContextProvider placeholders) {
        return MathUtils.eval(this.getOption("upgrade-cost").getMathExpression(), placeholders);
    }

    @Override
    public int getMaxLevel(PlaceholderContextProvider placeholders) {
        return (int)MathUtils.eval(this.getOption("max-level").getMathExpression(), placeholders);
    }

    @Override
    public String getDataName() {
        return this.name;
    }

    @Override
    public int getDefaultLevel(PlaceholderContextProvider placeholders) {
        return 1;
    }

    public String getHologramName() {
        KeyedConfigAccessor option = this.getOption("hologram", "name");
        return option == null ? null : option.getString();
    }

    public double getHologramHeight() {
        KeyedConfigAccessor option = this.getOption("hologram", "height");
        return option == null ? 0.0 : option.getDouble();
    }

    public String getSkull(int level) {
        ConfigAccessor section = this.getOption("skull").getSection();
        if (section == null) {
            return null;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, level);
        return section.getString(String.valueOf(entry));
    }

    public boolean hideHolograms() {
        return this.getOption("hide-holograms").getBoolean();
    }

    public boolean canBePlacedInBiome(Location location) {
        XBiome biome;
        ConfigAccessor worldSettings = this.getOption("biomes", location.getWorld().getName()).getSection();
        if (worldSettings == null) {
            return true;
        }
        boolean whitelist = worldSettings.getBoolean("whitelist");
        List<String> biomes = worldSettings.getStringList("list");
        return whitelist == biomes.contains((biome = XBiome.matchXBiome(location.getBlock().getBiome())).name());
    }

    public void setSkin(Block block, int level) {
        String skull = this.getSkull(level);
        if (skull == null) {
            return;
        }
        SkullUtils.setSkin(block, skull);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Messenger getDisplayName() {
        return new StaticMessenger(this.getOption("name").getString());
    }

    public void droppedItemName(Item item) {
        item.setCustomName(this.getDisplayName().getMessageObject(SupportedLanguage.EN).buildPlain(new MessageBuilder()));
        item.setCustomNameVisible(true);
    }

    public XMaterial getBlockMaterial(int level) {
        String block;
        ConfigAccessor section = this.getOption("block").getSection();
        if (section == null) {
            block = this.getOption("block").getString();
        } else {
            int entry = KingdomsConfig.getClosestLevelSection(section, level);
            block = section.getString(String.valueOf(entry));
        }
        return GUIOptionParser.unsupportedMaterial(XMaterial.matchXMaterial(block).orElseThrow(() -> new IllegalArgumentException("Unknown material for kingdom item: " + this.name)));
    }

    public String toString() {
        return "KingdomItemStyle:{" + this.name + '}';
    }

    public long getSellCost(int lvl, Kingdom kingdom) {
        String option = this.getOption("sell").getString();
        if (option == null) {
            return 0L;
        }
        return (long)MathUtils.evaluateEquation(option, "lvl", lvl, "cost", this.getCost(kingdom));
    }

    public List<String> getHolograms(int level) {
        KeyedConfigAccessor option = this.getOption("hologram");
        ConfigAccessor section = option.getSection();
        if (section == null) {
            return null;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, level);
        return section.getStringList(String.valueOf(entry), "lines");
    }

    public double getHologramHeight(int level) {
        KeyedConfigAccessor option = this.getOption("hologram");
        ConfigAccessor section = option.getSection();
        if (section == null) {
            return 0.0;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, level);
        return section.getDouble(String.valueOf(entry), "height");
    }
}

