/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.abstraction;

import java.util.HashSet;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.utils.nbt.ItemNBT;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;

public abstract class KingdomItemType<I extends KingdomItem<S>, S extends KingdomItemStyle<I, S, T>, T extends KingdomItemType<I, S, T>> {
    protected final String name;

    public KingdomItemType(String name) {
        this.name = name;
    }

    public static Pair<KingdomItemStyle<?, ?, ?>, Integer> getTypeOf(ItemStack item) {
        NBTWrappers.NBTTagCompound nbt = ItemNBT.getTag(item);
        if ((nbt = nbt.getCompound("Kingdoms")) != null) {
            String tag = nbt.get("Structure", NBTType.STRING);
            if (tag != null) {
                return Pair.of(StructureRegistry.getStyle(tag), nbt.get("Level", NBTType.INTEGER));
            }
            tag = nbt.get("Turret", NBTType.STRING);
            if (tag != null) {
                return Pair.of(TurretRegistry.getStyle(tag), nbt.get("Level", NBTType.INTEGER));
            }
        }
        return null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return super.toString() + '{' + this.name + '}';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KingdomItemType)) {
            return false;
        }
        KingdomItemType type = (KingdomItemType)obj;
        return this.name.equals(type.name);
    }

    public String getName() {
        return this.name;
    }

    public abstract InteractiveGUI open(KingdomItemGUIContext<I> var1);

    public abstract I build(KingdomItemBuilder<I, S, T> var1);

    public void deserialize(I item, DeserializationContext<SectionableDataGetter> context) {
        SectionableDataGetter provider = context.getDataProvider();
        ((KingdomItem)item).level = provider.getInt("level");
        ((KingdomItem)item).setHolograms(provider.get("holograms").asCollection(new HashSet(), (c, e) -> c.add(e.asUUID())));
        DataHandlerMetadata.deserializeMetadata(provider, item);
    }
}

