/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures;

import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;

public class Structure
extends KingdomItem<StructureStyle> {
    private String name;

    public Structure(String world, int x, int y, int z, StructureStyle type) {
        this(type, new SimpleLocation(world, x, y, z));
    }

    public Structure(@NonNull StructureStyle style, @NonNull SimpleLocation location) {
        super("Structure", style, location);
        this.name = style.getOption("default-name").getString();
    }

    @Override
    public KingdomItemBreakEvent<?> remove(KingdomItemRemoveContext context) {
        Kingdom kingdom = this.getLand().getKingdom();
        boolean isNexus = false;
        if (((StructureType)((StructureStyle)this.style).getType()).isNationalNexus()) {
            Nation nation = kingdom.getNation();
            isNexus = true;
            if (nation != null) {
                nation.setNexus(null);
            }
        } else if (((StructureType)((StructureStyle)this.style).getType()).isNexus()) {
            isNexus = true;
            kingdom.setNexus(null);
        }
        if (isNexus) {
            context.setDropsItem(false);
        }
        return super.remove(context);
    }

    public String getDisplayName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameOrDefault() {
        if (this.name != null) {
            return this.name;
        }
        return ((StructureStyle)this.style).getOption("default-name").getString();
    }

    @Override
    public void setDataFromNBT(NBTTagCompound tag) {
        super.setDataFromNBT(tag);
        this.name = tag.get("Name", NBTType.STRING);
    }

    public String toString() {
        return "Structure:{type=" + ((StructureStyle)this.style).getName() + ", location=" + this.location + '}';
    }

    @Override
    protected void removeData() {
        this.getLand().getStructures().remove(this.location);
    }

    @Override
    public MessageBuilder getEdits(Kingdom kingdom) {
        MessageBuilder edits = super.getEdits(kingdom);
        if (this.name != null) {
            edits.parse("structure-custom-name", this.name);
        } else {
            edits.raw("structure-custom-name", KingdomsLang.NONE);
        }
        return edits;
    }

    @Override
    public Pair<ItemStack, NBTTagCompound> getTags() {
        Pair<ItemStack, NBTTagCompound> pair = super.getTags();
        if (pair == null) {
            return null;
        }
        NBTWrappers.NBTTagCompound tag = (NBTWrappers.NBTTagCompound)pair.getValue();
        tag = tag.getCompound("Kingdoms");
        if (this.name != null) {
            tag.set("Name", NBTType.STRING, this.name);
        }
        return pair;
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter provider = context.getDataProvider();
        provider.setString("name", this.name);
        provider.get("location").setSimpleLocation(this.location);
    }
}

