/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.type.StructureExtractor;
import org.kingdoms.constants.land.structures.type.StructureOutpost;
import org.kingdoms.constants.land.structures.type.StructurePowercell;
import org.kingdoms.constants.land.structures.type.StructureRegulator;
import org.kingdoms.constants.land.structures.type.StructureSiegeCannon;
import org.kingdoms.constants.land.structures.type.StructureWarpPad;
import org.kingdoms.constants.land.structures.type.nexus.StructureKingdomNexus;
import org.kingdoms.constants.land.structures.type.nexus.StructureNationNexus;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.Validator;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.config.CustomConfigValidators;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.string.StringUtils;

public class StructureRegistry {
    private static final Map<String, StructureType> TYPES = new HashMap<String, StructureType>();
    private static final Map<String, StructureStyle> STYLES = new HashMap<String, StructureStyle>();
    protected static final NodeValidator SCHEMA;
    public static final Path STRUCTURES_PATH;

    public static void init() {
        STYLES.clear();
        TurretRegistry.register("Structure", "Structures", (name, adapter) -> {
            StructureRegistry.validate(name, adapter);
            StructureRegistry.registerStyle(new StructureStyle((String)name, (YamlResource)adapter));
        });
    }

    public static void validate(String name, YamlContainer adapter) {
        ConfigManager.warnAboutValidation("Structures/" + name, Validator.validate(adapter.getConfig().getNode(), SCHEMA, CustomConfigValidators.getValidators()));
    }

    public static StructureStyle registerStyle(StructureStyle style) {
        style.loadSettings();
        return STYLES.put(style.getName(), style);
    }

    public static Map<String, StructureType> getTypes() {
        return TYPES;
    }

    public static StructureType getType(String name) {
        return TYPES.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static void registerType(StructureType type) {
        Objects.requireNonNull(type, "Cannot register structure type with null type");
        String name = type.getName();
        name = StringUtils.deleteWhitespace(name.toLowerCase(Locale.ENGLISH));
        Validate.isTrue(!TYPES.containsKey(name), "Structure type '" + name + "' is already registered");
        TYPES.put(name, type);
    }

    public static Map<String, StructureStyle> getStyles() {
        return STYLES;
    }

    public static StructureStyle getStyle(String turret) {
        return STYLES.get(turret);
    }

    static {
        StructureRegistry.registerType(new StructureKingdomNexus());
        StructureRegistry.registerType(new StructureNationNexus());
        StructureRegistry.registerType(new StructureExtractor());
        StructureRegistry.registerType(new StructureWarpPad());
        StructureRegistry.registerType(new StructureRegulator());
        StructureRegistry.registerType(new StructurePowercell());
        StructureRegistry.registerType(new StructureOutpost());
        StructureRegistry.registerType(new StructureSiegeCannon());
        SCHEMA = YamlContainer.parseValidator("Structure Schema", "schemas/Structures/structure.yml");
        STRUCTURES_PATH = Kingdoms.getPath("Structures");
    }
}

