/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.objects;

import com.google.common.base.Enums;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;

public class Regulator
extends Structure {
    private Map<UUID, Set<Attribute>> attributes = new HashMap<UUID, Set<Attribute>>();
    private Map<UUID, Set<Interactable>> interactions = new HashMap<UUID, Set<Interactable>>();
    private Set<Rule> rules = new QuickEnumSet((Enum[])Rule.access$000());
    public static final Namespace NS = Namespace.kingdoms("REGULATOR");

    public Regulator(StructureStyle type, SimpleLocation location) {
        super(type, location);
    }

    public static Interactable detectInteractableType(Material material) {
        String name = material.name();
        if (name.contains("DOOR")) {
            return Interactable.DOORS;
        }
        if (name.contains("BUTTON") || name.contains("LEVER")) {
            return Interactable.BUTTONS_AND_LEVERS;
        }
        if (name.contains("ENCHANT") && name.contains("TABLE")) {
            return Interactable.ENCHANTMENT_TABLE;
        }
        if (name.contains("ANVIL")) {
            return Interactable.ANVILS;
        }
        if (name.contains("CHEST") || name.contains("BARREL")) {
            return Interactable.CHESTS;
        }
        if (name.contains("BED")) {
            return Interactable.BEDS;
        }
        if (name.contains("FURNACE")) {
            return Interactable.FURNACES;
        }
        if (name.contains("PLATE")) {
            return Interactable.PLATES;
        }
        return (Interactable)((Object)Enums.getIfPresent(Interactable.class, (String)name).orNull());
    }

    public Set<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Set<Rule> rules) {
        this.rules = Objects.requireNonNull(rules, "Regulator rules cannot be null");
    }

    public Map<UUID, Set<Interactable>> getInteractions() {
        return this.interactions;
    }

    public void setInteractions(Map<UUID, Set<Interactable>> interactions) {
        this.interactions = Objects.requireNonNull(interactions, "Regulator interaction settings cannot be null");
    }

    public boolean hasRule(Rule rule) {
        return this.rules.contains((Object)rule);
    }

    public Boolean hasAttribute(OfflinePlayer player, Attribute attribute) {
        Set<Attribute> list2 = this.attributes.get(player.getUniqueId());
        if (list2 == null) {
            return null;
        }
        return list2.contains((Object)Attribute.ALL) || list2.contains((Object)attribute);
    }

    public Boolean canInteract(OfflinePlayer player, Block block) {
        Set<Interactable> list2 = this.interactions.get(player.getUniqueId());
        if (list2 == null) {
            return null;
        }
        if (list2.contains((Object)Interactable.ALL)) {
            return true;
        }
        Interactable interactable = Regulator.detectInteractableType(block.getType());
        return interactable != null && list2.contains((Object)interactable);
    }

    public Map<UUID, Set<Attribute>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<UUID, Set<Attribute>> attributes) {
        this.attributes = Objects.requireNonNull(attributes, "Regulator attributes cannot be null");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + super.hashCode();
        result = prime * result + this.rules.hashCode();
        result = prime * result + this.attributes.hashCode();
        result = prime * result + this.interactions.hashCode();
        return result;
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.get("rules").setCollection(this.rules, (elementProvider, element) -> elementProvider.setString(element.name()));
        json.get("attributes").setMap(this.attributes, (key, keyProvider, value) -> {
            keyProvider.setUUID((UUID)key);
            keyProvider.getValueProvider().setCollection(value, (elementProvider, element) -> elementProvider.setString(element.name()));
        });
        json.get("interactions").setMap(this.interactions, (key, keyProvider, value) -> {
            keyProvider.setUUID((UUID)key);
            keyProvider.getValueProvider().setCollection(value, (elementProvider, element) -> elementProvider.setString(element.name()));
        });
    }

    public static enum Rule {
        DISABLE_MOB_SPAWNING,
        DISABLE_ANIMAL_SPAWNING,
        DISABLE_TURRETS,
        AUTO_FILL_TURRETS,
        ALLOW_EXPLOSIONS,
        ALLOW_FIRE;

        private static final Rule[] VALUES;

        static /* synthetic */ Rule[] access$000() {
            return VALUES;
        }

        static {
            VALUES = Rule.values();
        }
    }

    public static enum Interactable {
        ALL,
        DOORS,
        BUTTONS_AND_LEVERS,
        SHULKER_BOXES,
        ENCHANTMENT_TABLE,
        CRAFTING_TABLE,
        CHESTS,
        BEDS,
        LOOM,
        JIGSAW,
        HOPPER,
        DISPENSER,
        SMOKER,
        FURNACES,
        DROPPER,
        BEACON,
        ANVILS,
        BREWING_STAND,
        CARTOGRAPHY_TABLES,
        SMITHING_TABLE,
        PLATES;

    }

    public static enum Attribute {
        ALL,
        BUILD,
        FLY,
        TURRET_CEASEFIRE,
        MANAGE_TURRETS;

    }
}

