/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.objects;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.objects.RangedTurret;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.XEntity;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityRegistry;
import org.kingdoms.managers.entity.types.KingdomTurretEntity;
import org.kingdoms.managers.turrets.SoldierManager;
import org.kingdoms.services.ServiceMythicMobs;
import org.kingdoms.services.managers.SoftService;

public class SoldierTurret
extends RangedTurret {
    public SoldierTurret(TurretStyle type, SimpleLocation location) {
        super(type, location);
    }

    @Override
    public void activate(LivingEntity target, Kingdom kingdom) {
        super.activate(target, kingdom);
        this.spawnSoldiers(target, kingdom, this.level);
    }

    @Override
    public boolean targetCheckup(LivingEntity target) {
        return super.targetCheckup(target) || SoldierManager.getSoldiers().containsKey(target);
    }

    public List<LivingEntity> spawnSoldiers(LivingEntity target, Kingdom kingdom, int lvl) {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("soldiers").getSection();
        if (section == null) {
            return null;
        }
        int closest = KingdomsConfig.getClosestLevelSection(section, lvl);
        section = section.gotoSection(String.valueOf(closest));
        ArrayList<LivingEntity> soldiers = new ArrayList<LivingEntity>(10);
        Location location = target.getLocation();
        if (!kingdom.isClaimed(this.location.toSimpleChunkLocation())) {
            return null;
        }
        for (String soldierKey : section.getKeys()) {
            ConfigAccessor soldierSection = section.gotoSection(soldierKey);
            String mm = soldierSection.getString("mythicmob");
            boolean isCustom = mm != null && SoftService.MYTHIC_MOBS.isAvailable();
            int total = Math.max(0, soldierSection.getInt("amount"));
            for (int i = 0; i < total; ++i) {
                Entity soldier;
                Entity entity = soldier = isCustom ? ((ServiceMythicMobs)SoftService.MYTHIC_MOBS.getService()).spawnMythicMob(location, mm, section.getInt("lvl")) : XEntity.spawn(location, soldierSection.toBukkitConfigurationSection());
                if (soldier == null) {
                    MessageHandler.sendConsolePluginMessage("&4Unable to parse soldier entity with entry &e" + soldierSection.getCurrentPath() + "&8:");
                    soldierSection.getEntries().forEach((k, v) -> MessageHandler.sendConsolePluginMessage("&6" + k + "&8: &e" + (v instanceof ConfigurationSection ? "" : v)));
                    continue;
                }
                if (!(soldier instanceof Monster)) continue;
                Monster monster = (Monster)soldier;
                soldiers.add((LivingEntity)monster);
                KingdomEntityRegistry.addMob(new KingdomTurretEntity((Entity)monster, this, target));
                monster.setTarget(target);
            }
        }
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            Pair<BukkitTask, List<LivingEntity>> guards = SoldierManager.getSoldiers().remove(target);
            if (guards == null) {
                return;
            }
            ParticleDisplay display = ParticleDisplay.simple(null, Particle.SPELL_WITCH);
            for (LivingEntity guard : guards.getValue()) {
                if (!guard.isValid()) continue;
                display.spawn(guard.getLocation());
                guard.setHealth(0.0);
                KingdomEntityRegistry.removeMob(guard);
            }
        }, 1200L);
        SoldierManager.getSoldiers().put(target, Pair.of(task, soldiers));
        return soldiers;
    }
}

