/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.types;

import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.objects.InfernoTurret;
import org.kingdoms.constants.land.turrets.types.TurretTypeRanged;
import org.kingdoms.data.Pair;
import org.kingdoms.events.items.turrets.TurretActivateEvent;

public class TurretInferno
extends TurretTypeRanged {
    public TurretInferno() {
        super("inferno", true, false);
    }

    @Override
    public boolean activate(TurretActivateEvent event) {
        Pair<Location, Vector> dir = this.shootingDirection(event);
        if (this.cantReachTarget(event, dir.getKey(), dir.getValue())) {
            return false;
        }
        if (TurretInferno.call(event)) {
            return false;
        }
        LivingEntity target = event.getTarget();
        event.getTurret().activate(target, event.getKingdom());
        return true;
    }

    @Override
    public InfernoTurret build(KingdomItemBuilder<Turret, TurretStyle, TurretType> builder) {
        return new InfernoTurret(builder.getStyle(), builder.getLocation());
    }
}

