/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.metadata;

import java.util.Objects;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.metadata.KingdomMetadata;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespaceContainer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;

public abstract class KingdomMetadataHandler
implements NamespaceContainer {
    private final @NonNull Namespace namespace;

    protected KingdomMetadataHandler(@NonNull Namespace namespace) {
        this.namespace = Objects.requireNonNull(namespace);
        if (namespace.getNamespace().equals("kingdoms")) {
            throw new IllegalArgumentException("Metadata handler namespace cannot be kingdoms");
        }
    }

    @Override
    public @NonNull Namespace getNamespace() {
        return this.namespace;
    }

    public abstract @NonNull KingdomMetadata deserialize(@NonNull KingdomsObject<?> var1, @NonNull DeserializationContext<SectionableDataGetter> var2);

    public int hashCode() {
        return this.namespace.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KingdomMetadataHandler)) {
            return false;
        }
        return this.namespace.equals(((KingdomMetadataHandler)obj).namespace);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.namespace.asString() + ']';
    }
}

