/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.entity.Player;
import org.kingdoms.config.KeyedConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.data.Pair;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.LanguageEntryWithContext;
import org.kingdoms.locale.compiler.builders.MessageObjectBuilder;
import org.kingdoms.locale.compiler.container.MessageContainer;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextBuilder;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.ConditionProcessor;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.config.ConfigSection;

public class KingdomsChatChannel {
    private static final Map<String, KingdomsChatChannel> CHANNELS = new HashMap<String, KingdomsChatChannel>(5);
    private final String id;
    private final String dataId;
    private final MessageObject color;
    private final ConditionalCompiler.LogicalOperand recipientCondition;
    private final Collection<Pair<ConditionalCompiler.LogicalOperand, Messenger>> useConditions;
    private final MessageContainer formats;
    private final List<Pair<ConditionalCompiler.LogicalOperand, String>> adminFormats;
    public static final String GLOBAL = "global";
    public static final String GLOBAL_DATA_ID = "GLOBAL";
    public static final String NATION = "nation";

    public static void registerChannels() {
        CHANNELS.clear();
        ConfigSection section = KingdomsConfig.Chat.CHANNELS.getManager().getSection().getSection();
        for (Map.Entry<String, ConfigSection> channel : section.getSections().entrySet()) {
            String id = channel.getKey();
            KeyedConfigAccessor channelSection = KingdomsConfig.Chat.CHANNELS.getManager().withProperty(id).applyProperties();
            MessageObject color = MessageCompiler.compile(KingdomsConfig.Chat.CHANNELS_COLOR.getManager().withOption("channel", id).getString());
            String recCond = KingdomsConfig.Chat.CHANNELS_RECIPIENTS_CONDITION.getManager().withOption("channel", id).getString();
            ConditionalCompiler.LogicalOperand recipientCondition = recCond == null ? null : ConditionalCompiler.compile(recCond).evaluate();
            KeyedYamlConfigAccessor useConditionsOption = KingdomsConfig.Chat.CHANNELS_USE_CONDITIONS.getManager().withOption("channel", id);
            YamlConfigAccessor sectionCond = useConditionsOption.getSection();
            Collection<Pair<ConditionalCompiler.LogicalOperand, Messenger>> useConditions = null;
            if (sectionCond != null) {
                useConditions = ConditionProcessor.translatableConditions(sectionCond.getSection());
            } else {
                String singleCondition = useConditionsOption.getString();
                if (singleCondition != null) {
                    useConditions = Collections.singletonList(Pair.of(ConditionalCompiler.compile(singleCondition).evaluate(), new LanguageEntryMessenger("channels", "default-permission-fail")));
                }
            }
            KingdomsChatChannel chan = new KingdomsChatChannel(id, color, recipientCondition, useConditions, MessageContainer.parse(channelSection.withProperty("formats")), MessageContainer.parseRaw(channelSection.clearExtras().withProperty("admin-formats")));
            CHANNELS.put(chan.id, chan);
            CHANNELS.put(chan.dataId, chan);
        }
    }

    public static KingdomsChatChannel getChannelUserFriendly(String name, MessageBuilder settings) {
        name = name.toLowerCase();
        for (KingdomsChatChannel chan : CHANNELS.values()) {
            if (name.equals(chan.id.toLowerCase())) {
                return chan;
            }
            if (name.equals(chan.getName().buildPlain(settings).toLowerCase())) {
                return chan;
            }
            if (!name.equals(chan.getShortName().buildPlain(settings).toLowerCase())) continue;
            return chan;
        }
        return null;
    }

    public static Map<String, KingdomsChatChannel> getChannels() {
        return CHANNELS;
    }

    public KingdomsChatChannel(String id, MessageObject color, ConditionalCompiler.LogicalOperand recipientCondition, Collection<Pair<ConditionalCompiler.LogicalOperand, Messenger>> useConditions, MessageContainer formats, List<Pair<ConditionalCompiler.LogicalOperand, String>> adminFormats) {
        this.id = id;
        this.dataId = id.toUpperCase(Locale.ENGLISH);
        this.color = color;
        this.recipientCondition = recipientCondition;
        this.useConditions = useConditions;
        this.formats = formats;
        this.adminFormats = adminFormats;
    }

    public static KingdomsChatChannel fromId(String id) {
        return CHANNELS.get(id);
    }

    public static KingdomsChatChannel getGlobalChannel() {
        return KingdomsChatChannel.fromId(GLOBAL);
    }

    public List<Pair<ConditionalCompiler.LogicalOperand, String>> getAdminFormat() {
        return this.adminFormats;
    }

    private MessageObjectBuilder getMessageObject(String entry) {
        return new LanguageEntryWithContext("channels", this.id, entry);
    }

    public MessageObjectBuilder getName() {
        return this.getMessageObject("name");
    }

    public MessageObjectBuilder getShortName() {
        return this.getMessageObject("short-name");
    }

    public MessageContainer getFormats() {
        return this.formats;
    }

    public MessageObject getColor() {
        return this.color;
    }

    public String getBypassPrefix() {
        return this.getOption(KingdomsConfig.Chat.CHANNELS_RANGED_BYPASS_PREFIX).getString();
    }

    public ConditionalCompiler.LogicalOperand getRecipientCondition() {
        return this.recipientCondition;
    }

    public Collection<Pair<ConditionalCompiler.LogicalOperand, Messenger>> getUseConditions() {
        return this.useConditions;
    }

    public Messenger canUse(Player player) {
        if (this.useConditions == null) {
            return null;
        }
        PlaceholderContextBuilder settings = new PlaceholderContextBuilder().withContext(player);
        for (Pair<ConditionalCompiler.LogicalOperand, Messenger> useCondition : this.useConditions) {
            if (ConditionProcessor.process(useCondition.getKey(), settings)) continue;
            return useCondition.getValue();
        }
        return null;
    }

    public boolean isGlobal() {
        return this.id.equals(GLOBAL);
    }

    private KeyedYamlConfigAccessor getOption(KingdomsConfig.Chat cfg) {
        return cfg.getManager().withOption("channel", this.id);
    }

    public String getId() {
        return this.id;
    }

    public String getDataId() {
        return this.dataId;
    }

    public String toString() {
        return "KingdomsChatChannel{" + this.id + '}';
    }
}

