/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public class RankMap
implements Cloneable {
    protected final @NonNull Map<String, Rank> main;
    protected final @NonNull TreeMap<Integer, Rank> sorted;

    public RankMap() {
        this.main = new NonNullMap<String, Rank>();
        this.sorted = new TreeMap(Integer::compareTo);
    }

    protected void clear() {
        this.main.clear();
        this.sorted.clear();
    }

    public RankMap(@NonNull Map<String, Rank> main, @NonNull TreeMap<Integer, Rank> sorted) {
        Validate.isTrue(main.size() == sorted.size(), "The rank map size doesn't match the sorted map size: " + main.size() + " - " + sorted.size());
        this.main = Objects.requireNonNull(main, "Ranks map cannot be null");
        this.sorted = Objects.requireNonNull(sorted, "Ranks sorted map cannot be null");
    }

    public RankMap(@NonNull Map<String, Rank> main) {
        this.main = Objects.requireNonNull(main, "Ranks map cannot be null");
        this.sorted = new TreeMap(Integer::compareTo);
        for (Rank rank : main.values()) {
            this.sorted.put(rank.getPriority(), rank);
        }
        Validate.isTrue(main.size() == this.sorted.size(), "The rank map size doesn't match the sorted map size: " + main.size() + " - " + this.sorted.size());
    }

    public RankMap(@NonNull TreeMap<Integer, Rank> sorted) {
        this.sorted = Objects.requireNonNull(sorted, "Ranks map cannot be null");
        this.main = new NonNullMap<String, Rank>(sorted.size());
        for (Rank rank : sorted.values()) {
            this.main.put(rank.getNode(), rank);
        }
        Validate.isTrue(this.main.size() == sorted.size(), "The rank map size doesn't match the sorted map size: " + this.main.size() + " - " + sorted.size());
    }

    public static void fixDuplicates(@NonNull Map<String, Rank> ranks) {
        HashSet priorities = new HashSet(ranks.size());
        ranks.values().removeIf(rank -> !priorities.add(rank.getPriority()));
    }

    public static void fixDuplicates(@NonNull TreeMap<Integer, Rank> sorted) {
        HashSet priorities = new HashSet(sorted.size());
        sorted.values().removeIf(rank -> !priorities.add(rank.getNode()));
    }

    public @Nullable Rank get(int priority) {
        return this.sorted.get(priority);
    }

    public @Nullable Rank get(@NonNull String node) {
        return this.main.get(node);
    }

    public boolean has(int priority) {
        return this.sorted.containsKey(priority);
    }

    public boolean has(@NonNull String node) {
        return this.main.containsKey(node);
    }

    public void updateNode(@NonNull String node, @NonNull String newNode) {
        Rank rank = Objects.requireNonNull(this.main.remove(node), "Cannot update a rank's node that's not in the map");
        rank.setNode(newNode);
        this.main.put(newNode, rank);
        this.sorted.put(rank.getPriority(), rank);
    }

    public @NonNull Pair<Rank, Rank> addOrReplace(@NonNull Rank rank) {
        Rank prioritizedRank = this.sorted.put(rank.getPriority(), rank);
        Rank nodeRank = this.main.put(rank.getNode(), rank);
        if (!(prioritizedRank == null && nodeRank == null || prioritizedRank == null == (nodeRank == null) && prioritizedRank.getPriority() == nodeRank.getPriority())) {
            if (prioritizedRank == null) {
                this.sorted.remove(rank.getPriority());
            } else {
                this.sorted.put(prioritizedRank.getPriority(), prioritizedRank);
            }
            if (nodeRank == null) {
                this.main.remove(rank.getNode());
            } else {
                this.main.put(nodeRank.getNode(), nodeRank);
            }
            throw new IllegalArgumentException("The specified rank's node and priority doesn't match with the map: " + rank.getNode() + " (" + rank.getPriority() + ") - " + (prioritizedRank == null ? "null" : prioritizedRank.getNode() + " (" + prioritizedRank.getPriority() + ')' + " - ") + (nodeRank == null ? "null" : nodeRank.getNode() + " (" + nodeRank.getPriority() + ')'));
        }
        return Pair.of(nodeRank, prioritizedRank);
    }

    public void push(int priority, @NonNull Rank rank) {
        Validate.isTrue(priority >= 0, "Invalid rank priority to push: " + priority);
        if (rank.getPriority() != priority) {
            Validate.isTrue(this.main.containsKey(rank.getNode()), "Cannot relocate a rank that's not in the map");
            Rank previous = this.sorted.put(priority, rank);
            if (previous != null) {
                previous.setPriority(rank.getPriority());
                this.sorted.put(rank.getPriority(), previous);
            }
            rank.setPriority(priority);
            return;
        }
        rank.setPriority(priority);
        ArrayList<Rank> removedRanks = new ArrayList<Rank>(this.size() - priority + 1);
        boolean finalPush = false;
        while (true) {
            Rank removed;
            if ((removed = this.sorted.remove(priority)) != null) {
                finalPush = false;
                removed.setPriority(priority + 1);
                this.main.get(removed.getNode()).setPriority(priority + 1);
                removedRanks.add(removed);
            } else {
                if (finalPush) break;
                finalPush = true;
            }
            ++priority;
        }
        for (Rank removed : removedRanks) {
            this.sorted.put(removed.getPriority(), removed);
        }
        this.main.put(rank.getNode(), rank);
        this.sorted.put(rank.getPriority(), rank);
    }

    public int size() {
        return this.main.size();
    }

    public @NonNull RankMap clone() {
        NonNullMap<String, Rank> cloneMain = new NonNullMap<String, Rank>(this.main.size());
        TreeMap<Integer, Rank> cloneSorted = new TreeMap<Integer, Rank>(Integer::compareTo);
        for (Map.Entry<String, Rank> entry : this.main.entrySet()) {
            Rank rank = entry.getValue().clone();
            cloneMain.put(entry.getKey(), rank);
            cloneSorted.put(rank.getPriority(), rank);
        }
        return new RankMap(cloneMain, cloneSorted);
    }

    public @NonNull Map<String, Rank> getRanks() {
        return Collections.unmodifiableMap(this.main);
    }

    public @Nullable Rank remove(@NonNull String node) {
        Rank rank = this.main.remove(node);
        if (rank == null) {
            return null;
        }
        Objects.requireNonNull(this.sorted.remove(rank.getPriority()), () -> "Sorted rank map does not contain a rank with '" + rank.getNode() + "' node and " + rank.getPriority() + " priority");
        this.bump(rank.getPriority());
        return rank;
    }

    public void bump(int priority) {
        Validate.isTrue(!this.sorted.containsKey(priority), "Cannot bump ranks to a location with a rank assigned to it: " + priority);
        int size = this.size();
        ++priority;
        while (priority < size + 1) {
            Rank removed = this.sorted.remove(priority);
            if (removed != null) {
                removed.setPriority(priority - 1);
                this.sorted.put(removed.getPriority(), removed);
                this.main.get(removed.getNode()).setPriority(priority - 1);
            }
            ++priority;
        }
    }

    public @Nullable Rank remove(@NonNull Rank rank) {
        return this.remove(rank.getPriority());
    }

    public @Nullable Rank remove(int priority) {
        Rank rank = this.sorted.remove(priority);
        if (rank == null) {
            return null;
        }
        return Objects.requireNonNull(this.main.remove(rank.getNode()), () -> "Main rank map does not contain a rank with '" + rank.getNode() + "' node and " + rank.getPriority() + " priority");
    }

    public @NonNull SortedMap<Integer, Rank> getSortedRanks() {
        return Collections.unmodifiableSortedMap(this.sorted);
    }

    public @NonNull Rank getLowestRank() {
        return this.sorted.lastEntry().getValue();
    }

    public @NonNull Rank getHighestRank() {
        return this.sorted.firstEntry().getValue();
    }

    public boolean isMemberRank(@NonNull Rank rank) {
        return rank.getPriority() == this.size() - 1;
    }
}

