/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.data.database.KingdomsDatabase;
import org.kingdoms.libs.caffeine.cache.CacheLoader;
import org.kingdoms.libs.caffeine.cache.Caffeine;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.cache.CacheHandler;
import org.kingdoms.utils.cache.CaffeineWrapper;
import org.kingdoms.utils.cache.JavaMapWrapper;
import org.kingdoms.utils.cache.PeekableMap;

public abstract class DataManager<K, T extends KingdomsObject<K>> {
    private final String displayName;
    public static final boolean SMART = KingdomsConfig.DATABASE_SMART_SAVE.getBoolean();
    protected static final long INTERVAL = KingdomsConfig.DATABASE_AUTO_SAVE_INTERVAL.getTimeMillis();
    protected final PeekableMap<K, T> cache;
    protected final Set<K> doesntExist;
    protected KingdomsDatabase<K, T> database;
    private boolean savingState = true;

    public DataManager(String displayName, KingdomsDatabase<K, T> database) {
        this(displayName, database, false);
    }

    public DataManager(String displayName, KingdomsDatabase<K, T> database, boolean cacheExistence) {
        this(displayName, database, cacheExistence, true);
    }

    public DataManager(String displayName, final KingdomsDatabase<K, T> database, boolean cacheExistence, boolean timedCache) {
        Object loader;
        this.displayName = displayName;
        this.database = database;
        this.doesntExist = cacheExistence ? new HashSet<K>() : null;
        Object object = loader = cacheExistence ? new CacheLoader<K, T>(){

            public @Nullable T load(@NonNull K key) {
                if (DataManager.this.doesntExist.contains(key)) {
                    return null;
                }
                Object data = database.load(key);
                if (data == null) {
                    DataManager.this.doesntExist.add(key);
                }
                if (data != null) {
                    DataManager.this.onLoad(data);
                }
                return data;
            }
        } : new CacheLoader<K, T>(){

            public @Nullable T load(@NonNull K key) {
                Object data = database.load(key);
                if (data != null) {
                    DataManager.this.onLoad(data);
                }
                return data;
            }
        };
        if (!timedCache || KingdomsConfig.DATABASE_LOAD_ALL_DATA_ON_STARTUP.getBoolean()) {
            this.cache = new JavaMapWrapper<K, T>(new ConcurrentHashMap(), loader);
        } else {
            Caffeine<Object, Object> builder = CacheHandler.newBuilder();
            builder.expireAfterAccess(INTERVAL * 2L, TimeUnit.MILLISECONDS);
            this.cache = new CaffeineWrapper<K, T>(builder.build((CacheLoader)loader));
        }
    }

    public void delete(@NonNull K identifier) {
        this.unload(identifier);
        this.database.delete(identifier);
        if (this.doesntExist != null) {
            this.doesntExist.add(identifier);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void clear() {
        this.cache.clear();
        if (this.doesntExist != null) {
            this.doesntExist.clear();
        }
    }

    public void deleteAllData() {
        this.clear();
        this.database.deleteAllData();
    }

    public void setSavingState(boolean savingState) {
        this.savingState = savingState;
    }

    public void copyCacheTo(DataManager<K, T> dataManager) {
        dataManager.cache.putAll(this.cache);
    }

    public void emptyCache() {
        this.cache.clear();
    }

    public int loadAllData() {
        Collection<T> datas = this.database.loadAllData();
        for (KingdomsObject data : datas) {
            this.load(data);
        }
        return datas.size();
    }

    public Collection<T> load(Collection<K> keys) {
        Collection<K> chosenKeys = keys;
        ArrayList<KingdomsObject> loaded = new ArrayList<KingdomsObject>(keys.size());
        for (K key : keys) {
            KingdomsObject data = (KingdomsObject)this.cache.getIfPresent(key);
            if (data == null) continue;
            loaded.add(data);
            if (chosenKeys == keys) {
                chosenKeys = new HashSet<K>(keys);
            }
            chosenKeys.remove(key);
        }
        this.database.load(chosenKeys, loaded, this);
        return loaded;
    }

    protected void autoSave(@NonNull Kingdoms plugin) {
        long ticks = INTERVAL / 1000L * 20L;
        new BukkitRunnable(){

            public void run() {
                DataManager.this.saveAll(true);
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, ticks, ticks);
    }

    public void saveAll(boolean smart) {
        if (smart) {
            if (!this.savingState) {
                KLogger.info("Saving state was turned off for " + this.displayName + ", skipping saving data...");
                return;
            }
            ArrayList<KingdomsObject> datas = new ArrayList<KingdomsObject>(this.cache.size());
            for (KingdomsObject data : this.cache.values()) {
                if (SMART && !data.shouldSave()) continue;
                datas.add(data);
            }
            this.database.save(datas);
        } else {
            this.database.save(this.cache.values());
        }
    }

    public void loadAndSave(@NonNull K key, @NonNull T data) {
        this.load(data);
        this.database.save(data);
    }

    public T getDataIfLoaded(K key) {
        return (T)((KingdomsObject)this.cache.getIfPresent(key));
    }

    public boolean isLoaded(K key) {
        return this.cache.containsKey(key);
    }

    protected void onLoad(T value) {
    }

    protected void unload(@NonNull K key) {
        this.cache.remove(key);
    }

    public void load(@NonNull T data) {
        Object key = ((KingdomsObject)data).getDataKey();
        this.cache.put(key, data);
        this.onLoad(data);
        if (this.doesntExist != null) {
            this.doesntExist.remove(key);
        }
    }

    public @Nullable T peek(@NonNull K identifier) {
        KingdomsObject<Object> data = (KingdomsObject)this.cache.peek(identifier);
        if (data == null) {
            data = this.database.load(identifier);
        }
        return (T)data;
    }

    public boolean exists(K identifier) {
        if (this.doesntExist.contains(identifier)) {
            return false;
        }
        if (this.cache.containsKey(identifier)) {
            return true;
        }
        return this.database.hasData(identifier);
    }

    public @Nullable T getData(@NonNull K identifier) {
        return (T)((KingdomsObject)this.cache.get(identifier));
    }

    public int size() {
        return this.cache.size();
    }

    public Collection<T> getLoadedData() {
        return this.cache.values();
    }

    public Collection<T> peekAllData() {
        if (KingdomsConfig.DATABASE_LOAD_ALL_DATA_ON_STARTUP.getBoolean()) {
            return this.getLoadedData();
        }
        Collection<K> keys = this.database.getDataKeys();
        ArrayList<Object> vals = new ArrayList<Object>(keys.size());
        vals.addAll(this.cache.values());
        for (K identifier : keys) {
            if (this.cache.get(identifier) != null) continue;
            T data = this.database.load(identifier);
            if (data == null) {
                throw new NullPointerException("Peeked data cannot be null with a valid key: " + identifier);
            }
            vals.add(data);
        }
        return vals;
    }
}

