/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.database.KingdomsDatabase;
import org.kingdoms.data.database.flatfile.json.JsonDatabase;
import org.kingdoms.data.database.flatfile.yaml.YamlDatabase;
import org.kingdoms.data.database.mongo.MongoDBDatabase;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLConnectionProvider;
import org.kingdoms.data.database.sql.SQLDatabase;
import org.kingdoms.data.database.sql.SQLHikariConnectionProvider;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.data.managers.KingdomManager;
import org.kingdoms.data.managers.KingdomPlayerManager;
import org.kingdoms.data.managers.LandManager;
import org.kingdoms.data.managers.MessageTransferAgent;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.string.StringUtils;

public final class KingdomsDataCenter {
    public static final String DATA_FOLDER_NAME = "data";
    public static final Path DATA_FOLDER = Kingdoms.getPath("data");
    private DatabaseType databaseType;
    private static KingdomsDataCenter instance;
    private final KingdomManager kingdomManager;
    private final NationManager nationManager;
    private final LandManager landManager;
    private final KingdomPlayerManager kingdomPlayerManager;
    private final MessageTransferAgent mtg;

    public KingdomsDataCenter(Kingdoms plugin) {
        instance = this;
        this.nationManager = new NationManager(this);
        this.kingdomManager = new KingdomManager(this);
        this.landManager = new LandManager(this);
        this.kingdomPlayerManager = new KingdomPlayerManager(this);
        this.mtg = new MessageTransferAgent(this);
        long time = DataManager.INTERVAL;
        time = TimeUnit.MILLISECONDS.toSeconds(time);
        new BukkitRunnable(){

            public void run() {
                MessageHandler.sendConsolePluginMessage("&2Auto saving... Checking &6" + KingdomsDataCenter.this.nationManager.size() + " &2nations, &6" + KingdomsDataCenter.this.kingdomManager.size() + " &2kingdoms, &6" + KingdomsDataCenter.this.landManager.size() + " &2lands and &6" + KingdomsDataCenter.this.kingdomPlayerManager.size() + " &2players.");
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, time *= 20L, time);
    }

    private static void loadDatabaseLibraries(String name, List<Dependency> dependencies) {
        if (SQLDatabase.ranSchema) {
            return;
        }
        KLogger.info("Loading libraries for " + name + " database...");
        Kingdoms.get().getDependencyManager().loadDependencies(dependencies);
        KLogger.info("Loaded all libraries.");
    }

    public <K, T extends KingdomsObject<K>> KingdomsDatabase<K, T> constructDatabase(String name, String table, DataHandler<K, T> dataHandler) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(table);
        Objects.requireNonNull(dataHandler);
        String db = StringUtils.deleteWhitespace(KingdomsConfig.DATABASE_METHOD.getString()).toLowerCase(Locale.ENGLISH);
        Path path = Kingdoms.getFolder();
        if (KingdomsConfig.DATABASE_USE_DATA_FOLDER.getManager().noDefault().getBoolean()) {
            path = Kingdoms.getPath(DATA_FOLDER_NAME);
        }
        if (db.equals("json")) {
            return new JsonDatabase<K, T>(path.resolve(name), dataHandler);
        }
        if (db.equals("yaml")) {
            return new YamlDatabase<K, T>(path.resolve(name), dataHandler);
        }
        boolean wasFirstTime = this.databaseType == null;
        this.databaseType = Arrays.stream(DatabaseType.values()).filter(x -> x.name().toLowerCase().equals(db)).findFirst().orElse(null);
        if (this.databaseType != null) {
            if (this.databaseType == DatabaseType.MongoDB) {
                if (!wasFirstTime) {
                    KingdomsDataCenter.loadDatabaseLibraries(db, Arrays.asList(DatabaseType.MongoDB.getDependencies()));
                }
                return MongoDBDatabase.withCollection(table, dataHandler);
            }
            if (wasFirstTime) {
                ArrayList<Dependency> dependencies = new ArrayList<Dependency>(Arrays.asList(this.databaseType.getDependencies()));
                dependencies.add(Dependency.HIKARI);
                dependencies.add(Dependency.SLF4J_SIMPLE);
                KingdomsDataCenter.loadDatabaseLibraries(db, dependencies);
            }
            SQLConnectionProvider.setDefaultProviderIfNull(path, this.databaseType);
            return new SQLDatabase<K, T>(this.databaseType, table, dataHandler, SQLHikariConnectionProvider.getDefaultProvider());
        }
        throw new IllegalArgumentException("Unknown database type: " + db);
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public List<DataManager<?, ?>> getAllDataManagers() {
        return Arrays.asList(this.kingdomManager, this.nationManager, this.landManager, this.kingdomPlayerManager, this.mtg);
    }

    public MessageTransferAgent getMTG() {
        return this.mtg;
    }

    public static KingdomsDataCenter get() {
        return instance;
    }

    public KingdomManager getKingdomManager() {
        return this.kingdomManager;
    }

    public NationManager getNationManager() {
        return this.nationManager;
    }

    public LandManager getLandManager() {
        return this.landManager;
    }

    public KingdomPlayerManager getKingdomPlayerManager() {
        return this.kingdomPlayerManager;
    }
}

