/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.dataprovider;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.database.dataprovider.MappedIdSetter;
import org.kingdoms.data.database.dataprovider.MappingSetterHandler;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.KotlinNothingValueException;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.internal.FastUUID;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\r\u001a\u00020\n\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u001dH\u0016J<\u0010\u001e\u001a\u00020\n\"\u0004\b\u0000\u0010\u001f\"\u0004\b\u0001\u0010\u000e2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H\u000e0!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u0002H\u000e0#H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010'H\u0016J\u0012\u0010(\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010)\u001a\u00020\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020\nH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/kingdoms/data/database/dataprovider/StringMappedIdSetter;", "Lorg/kingdoms/data/database/dataprovider/MappedIdSetter;", "dataSetterConstructor", "Lorg/kingdoms/libs/kotlin/Function1;", "", "Lorg/kingdoms/data/database/dataprovider/SectionCreatableDataSetter;", "(Lkotlin/jvm/functions/Function1;)V", "id", "getValueProvider", "setBoolean", "", "value", "", "setCollection", "V", "collection", "", "elementHandler", "Ljava/util/function/BiConsumer;", "setDouble", "", "setFloat", "", "setInt", "", "", "setLocation", "Lorg/bukkit/Location;", "setLong", "", "setMap", "K", "map", "", "handler", "Lorg/kingdoms/data/database/dataprovider/MappingSetterHandler;", "setSimpleChunkLocation", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "setSimpleLocation", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "setString", "setUUID", "Ljava/util/UUID;", "unsupportedId", "core"})
public final class StringMappedIdSetter
implements MappedIdSetter {
    @NotNull
    private final Function1<String, SectionCreatableDataSetter> dataSetterConstructor;
    @Nullable
    private String id;

    public StringMappedIdSetter(@NotNull Function1<? super String, ? extends SectionCreatableDataSetter> dataSetterConstructor) {
        Intrinsics.checkNotNullParameter(dataSetterConstructor, (String)"dataSetterConstructor");
        this.dataSetterConstructor = dataSetterConstructor;
    }

    private final Void unsupportedId() {
        throw new UnsupportedOperationException("This ID type is not supported");
    }

    @Override
    @NotNull
    public SectionCreatableDataSetter getValueProvider() {
        if (this.id == null) {
            throw new IllegalStateException("Cannot get value provider before setting the ID");
        }
        String string = this.id;
        Intrinsics.checkNotNull((Object)string);
        return (SectionCreatableDataSetter)this.dataSetterConstructor.invoke((Object)string);
    }

    @Override
    public void setString(@Nullable String value) {
        String string = value;
        Intrinsics.checkNotNull((Object)string);
        this.id = string;
    }

    @Override
    public void setInt(int value) {
        this.id = String.valueOf(value);
    }

    @NotNull
    public Void setLocation(@Nullable Location value) {
        this.unsupportedId();
        throw new KotlinNothingValueException();
    }

    @Override
    public void setSimpleLocation(@Nullable SimpleLocation value) {
        this.id = String.valueOf(value);
    }

    @Override
    public void setSimpleChunkLocation(@NotNull SimpleChunkLocation value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.id = value.toString();
    }

    @Override
    public void setLong(long value) {
        this.id = String.valueOf(value);
    }

    @NotNull
    public Void setFloat(float value) {
        this.unsupportedId();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Void setDouble(double value) {
        this.unsupportedId();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Void setBoolean(boolean value) {
        this.unsupportedId();
        throw new KotlinNothingValueException();
    }

    @Override
    public void setUUID(@Nullable UUID value) {
        this.id = FastUUID.toString(value);
    }

    @NotNull
    public <V> Void setCollection(@NotNull Collection<? extends V> collection, @NotNull BiConsumer<SectionCreatableDataSetter, V> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        this.unsupportedId();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public <K, V> Void setMap(@NotNull Map<K, ? extends V> map, @NotNull MappingSetterHandler<K, V> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.unsupportedId();
        throw new KotlinNothingValueException();
    }
}

