/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.flatfile.json;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Collectors;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.database.flatfile.FlatFileDatabase;
import org.kingdoms.data.database.flatfile.json.KingdomsGson;
import org.kingdoms.data.database.flatfile.json.NamedJsonDataProvider;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.main.KLogger;

public final class JsonDatabase<K, T extends KingdomsObject<K>>
extends FlatFileDatabase<K, T> {
    public JsonDatabase(@NotNull Path folder, @NotNull DataHandler<K, T> dataHandler) {
        super("json", folder, dataHandler);
    }

    @Override
    @Nullable
    public T load(@NotNull K key, @NotNull BufferedReader reader) {
        Path path = this.fileFromKey(key);
        try {
            JsonObject obj = KingdomsGson.parse(reader);
            KingdomsObject data = (KingdomsObject)this.getDataHandler().load(new NamedJsonDataProvider(null, obj), key);
            if (data == null) {
                KLogger.error("Could not load data for '" + key + "' with adapter " + this.getDataHandler() + " JSON:(" + Files.lines(path).collect(Collectors.joining()) + ") Deleting their data...");
                Files.delete(path);
                return null;
            }
            if (DataManager.SMART) {
                data.setSaveMeta();
            }
            return (T)data;
        }
        catch (JsonSyntaxException ex) {
            try {
                String lines = Files.lines(path).collect(Collectors.joining());
                KLogger.error("Malformed JSON data '" + path.toAbsolutePath() + "' with adapter " + this.getDataHandler() + " JSON:(" + lines + ") Deleting their data...");
                if (lines.length() <= 2) {
                    Files.delete(path);
                }
                ex.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public void save(@NotNull T data, @NotNull BufferedWriter writer) {
        JsonObject object = new JsonObject();
        this.getDataHandler().save(new NamedJsonDataProvider(null, object), data);
        try {
            KingdomsGson.toJson(object, writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

