/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.mongo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.database.KingdomsDatabase;
import org.kingdoms.data.database.mongo.MongoDataProvider;
import org.kingdoms.data.database.mongo.MongoIdQueryContainer;
import org.kingdoms.data.database.mongo.SimpleChunkLocationEncoder;
import org.kingdoms.data.database.mongo.SimpleLocationEncoder;
import org.kingdoms.data.database.sql.DatabaseProperties;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.libs.bson.BsonDocumentReader;
import org.kingdoms.libs.bson.BsonReader;
import org.kingdoms.libs.bson.Document;
import org.kingdoms.libs.bson.UuidRepresentation;
import org.kingdoms.libs.bson.codecs.Codec;
import org.kingdoms.libs.bson.codecs.DecoderContext;
import org.kingdoms.libs.bson.codecs.configuration.CodecRegistries;
import org.kingdoms.libs.bson.codecs.configuration.CodecRegistry;
import org.kingdoms.libs.bson.conversions.Bson;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.libs.mongodb.ConnectionString;
import org.kingdoms.libs.mongodb.MongoClientSettings;
import org.kingdoms.libs.mongodb.MongoCredential;
import org.kingdoms.libs.mongodb.ServerApi;
import org.kingdoms.libs.mongodb.ServerApiVersion;
import org.kingdoms.libs.mongodb.client.FindIterable;
import org.kingdoms.libs.mongodb.client.MongoClient;
import org.kingdoms.libs.mongodb.client.MongoClients;
import org.kingdoms.libs.mongodb.client.MongoCollection;
import org.kingdoms.libs.mongodb.client.MongoDatabase;
import org.kingdoms.libs.mongodb.client.model.BulkWriteOptions;
import org.kingdoms.libs.mongodb.client.model.ReplaceOneModel;
import org.kingdoms.libs.mongodb.client.model.ReplaceOptions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 +*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005:\u0001+B)\b\u0002\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010\u001f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010 J>\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00010\u001b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010$H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010\u001bH\u0016J\u0015\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010(J\u0016\u0010&\u001a\u00020\u000f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010\u001bH\u0016J\u0015\u0010)\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/kingdoms/data/database/mongo/MongoDBDatabase;", "K", "", "T", "Lorg/kingdoms/constants/metadata/KingdomsObject;", "Lorg/kingdoms/data/database/KingdomsDatabase;", "dataHandler", "Lorg/kingdoms/data/handlers/DataHandler;", "collection", "Lorg/kingdoms/libs/mongodb/client/MongoCollection;", "Lorg/kingdoms/libs/bson/Document;", "(Lorg/kingdoms/data/handlers/DataHandler;Lcom/mongodb/client/MongoCollection;)V", "maxEntries", "", "close", "", "constructIdContainer", "Lorg/kingdoms/data/database/mongo/MongoIdQueryContainer;", "id", "(Ljava/lang/Object;)Lorg/kingdoms/data/database/mongo/MongoIdQueryContainer;", "decode", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "delete", "(Ljava/lang/Object;)V", "deleteAllData", "getDataKeys", "", "hasData", "", "(Ljava/lang/Object;)Z", "load", "(Ljava/lang/Object;)Lorg/kingdoms/constants/metadata/KingdomsObject;", "keys", "to", "dataManager", "Lorg/kingdoms/data/DataManager;", "loadAllData", "save", "data", "(Lorg/kingdoms/constants/metadata/KingdomsObject;)V", "sectionWithId", "(Ljava/lang/Object;)Lorg/bson/Document;", "Companion", "core"})
public final class MongoDBDatabase<K, T extends KingdomsObject<K>>
implements KingdomsDatabase<K, T> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final DataHandler<K, T> dataHandler;
    @NotNull
    private final MongoCollection<Document> collection;
    private int maxEntries;
    @NotNull
    private static final MongoClient CLIENT;
    @NotNull
    private static final MongoDatabase DATABASE;
    private static final ReplaceOptions UPSERT;
    @NotNull
    private static final String PRIMARY_KEY_ID = "_id";
    private static final DecoderContext DEFAULT_DECODER_CONTEXT;

    private MongoDBDatabase(DataHandler<K, T> dataHandler, MongoCollection<Document> collection) {
        this.dataHandler = dataHandler;
        this.collection = collection;
        this.maxEntries = 10;
    }

    private final MongoIdQueryContainer<K> constructIdContainer(K id) {
        return new MongoIdQueryContainer<K>(id, this.dataHandler.getIdHandler().getKlass());
    }

    private final Document sectionWithId(K id) {
        return new Document(PRIMARY_KEY_ID, id);
    }

    @Override
    @Nullable
    public T load(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Document document = (Document)this.collection.find((Bson)this.constructIdContainer(key)).first();
        if (document == null) {
            return null;
        }
        Document doc = document;
        MongoDataProvider provider = new MongoDataProvider(null, doc);
        return (T)((KingdomsObject)this.dataHandler.load(provider, key));
    }

    private final K decode(Object key) {
        if (key instanceof Document) {
            Codec codec = this.collection.getCodecRegistry().get(this.dataHandler.getIdHandler().getKlass());
            Intrinsics.checkNotNull((Object)codec);
            Codec codec2 = codec;
            Object object = codec2.decode((BsonReader)new BsonDocumentReader(((Document)key).toBsonDocument()), DEFAULT_DECODER_CONTEXT);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"codec.decode(BsonDocumen\u2026 DEFAULT_DECODER_CONTEXT)");
            return (K)object;
        }
        Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type K of org.kingdoms.data.database.mongo.MongoDBDatabase");
        return (K)key;
    }

    @Override
    @NotNull
    public Collection<T> load(@NotNull Collection<K> keys, @NotNull Collection<T> to, @NotNull DataManager<K, T> dataManager) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Intrinsics.checkNotNullParameter(dataManager, (String)"dataManager");
        if (keys.isEmpty()) {
            return to;
        }
        Document ids = new Document(PRIMARY_KEY_ID, (Object)new Document("$in", keys));
        FindIterable result = this.collection.find((Bson)ids);
        for (Document document : result) {
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            MongoDataProvider provider = new MongoDataProvider(null, document);
            Object object = document.get((Object)PRIMARY_KEY_ID);
            Intrinsics.checkNotNull((Object)object);
            K id = this.decode(object);
            KingdomsObject data = (KingdomsObject)this.dataHandler.load(provider, id);
            to.add(data);
            dataManager.load(data);
        }
        return to;
    }

    @Override
    public void save(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object k = ((KingdomsObject)data).getDataKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"data.dataKey");
        MongoIdQueryContainer id = this.constructIdContainer(k);
        Object k2 = ((KingdomsObject)data).getDataKey();
        Intrinsics.checkNotNullExpressionValue(k2, (String)"data.dataKey");
        Document document = this.sectionWithId(k2);
        MongoDataProvider provider = new MongoDataProvider(null, document);
        this.dataHandler.save(provider, data);
        this.collection.replaceOne((Bson)id, (Object)document, UPSERT);
    }

    @Override
    public void delete(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.collection.deleteOne((Bson)this.constructIdContainer(key));
    }

    @Override
    public boolean hasData(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.collection.find((Bson)this.constructIdContainer(key)).first() != null;
    }

    @Override
    @NotNull
    public Collection<K> getDataKeys() {
        List list2 = new ArrayList((int)this.collection.estimatedDocumentCount());
        for (Document document : this.collection.find()) {
            Object object = document.get((Object)PRIMARY_KEY_ID);
            Intrinsics.checkNotNull((Object)object);
            K id = this.decode(object);
            list2.add(id);
        }
        return list2;
    }

    @Override
    public void deleteAllData() {
        this.collection.drop();
    }

    @Override
    @NotNull
    public Collection<T> loadAllData() {
        List list2 = new ArrayList(this.maxEntries);
        for (Document document : this.collection.find()) {
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            MongoDataProvider provider = new MongoDataProvider(null, document);
            Object object = document.get((Object)PRIMARY_KEY_ID);
            Intrinsics.checkNotNull((Object)object);
            K key = this.decode(object);
            list2.add(this.dataHandler.load(provider, key));
        }
        this.maxEntries = RangesKt.coerceAtLeast((int)this.maxEntries, (int)list2.size());
        return list2;
    }

    @Override
    public void save(@NotNull Collection<T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (data.isEmpty()) {
            return;
        }
        List replacingModels = new ArrayList(data.size());
        for (KingdomsObject datum : data) {
            Object k = datum.getDataKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"datum.dataKey");
            MongoIdQueryContainer id = this.constructIdContainer(k);
            Object k2 = datum.getDataKey();
            Intrinsics.checkNotNullExpressionValue(k2, (String)"datum.dataKey");
            Document document = this.sectionWithId(k2);
            MongoDataProvider provider = new MongoDataProvider(null, document);
            this.dataHandler.save(provider, datum);
            replacingModels.add(new ReplaceOneModel((Bson)id, (Object)document, UPSERT));
        }
        this.collection.bulkWrite(replacingModels, new BulkWriteOptions().ordered(false).comment("Save batch data of " + data.size()));
    }

    @Override
    public void close() {
        CLIENT.close();
    }

    @JvmStatic
    @NotNull
    public static final <K, T extends KingdomsObject<K>> MongoDBDatabase<K, T> withCollection(@NotNull String name, @NotNull DataHandler<K, T> dataHandler) {
        return Companion.withCollection(name, dataHandler);
    }

    public /* synthetic */ MongoDBDatabase(DataHandler dataHandler, MongoCollection collection, DefaultConstructorMarker $constructor_marker) {
        this(dataHandler, (MongoCollection<Document>)collection);
    }

    static {
        MongoClientSettings.Builder builder;
        Companion = new Companion(null);
        UPSERT = new ReplaceOptions().upsert(true);
        DEFAULT_DECODER_CONTEXT = DecoderContext.builder().build();
        DatabaseProperties props = DatabaseProperties.Companion.defaults(DatabaseType.MongoDB);
        MongoClientSettings.Builder $this$_init__u24lambda_u2d0 = builder = MongoClientSettings.builder();
        boolean bl = false;
        $this$_init__u24lambda_u2d0.applicationName("KingdomsX");
        String fullURL = KingdomsConfig.DATABASE_URI.getString();
        Object object = (CodecRegistry[])fullURL;
        if (!(object == null || object.length() == 0)) {
            $this$_init__u24lambda_u2d0.applyConnectionString(new ConnectionString(fullURL));
        } else {
            object = KingdomsConfig.DATABASE_USERNAME.getString();
            if (!(object == null || object.length() == 0)) {
                String string = props.getUser();
                String string2 = props.getDatabaseName();
                char[] cArray = props.getPassword().toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                $this$_init__u24lambda_u2d0.credential(MongoCredential.createCredential((String)string, (String)string2, (char[])cArray));
            }
        }
        $this$_init__u24lambda_u2d0.retryReads(false);
        $this$_init__u24lambda_u2d0.retryWrites(true);
        $this$_init__u24lambda_u2d0.uuidRepresentation(UuidRepresentation.STANDARD);
        $this$_init__u24lambda_u2d0.serverApi(ServerApi.builder().version(ServerApiVersion.V1).deprecationErrors(true).strict(true).build());
        object = new CodecRegistry[2];
        object[0] = MongoClientSettings.getDefaultCodecRegistry();
        Codec[] codecArray = new Codec[]{new SimpleChunkLocationEncoder(), new SimpleLocationEncoder()};
        object[1] = CodecRegistries.fromCodecs((Codec[])codecArray);
        $this$_init__u24lambda_u2d0.codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])object));
        MongoClientSettings.Builder settings = builder;
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings.build(), null);
        Intrinsics.checkNotNullExpressionValue((Object)mongoClient, (String)"create(settings.build(), null)");
        CLIENT = mongoClient;
        MongoDatabase mongoDatabase = CLIENT.getDatabase(props.getDatabaseName());
        Intrinsics.checkNotNullExpressionValue((Object)mongoDatabase, (String)"CLIENT.getDatabase(props.databaseName)");
        DATABASE = mongoDatabase;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u000f\"\b\b\u0002\u0010\u0010*\u00020\u0001\"\u000e\b\u0003\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u00110\u0015H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/data/database/mongo/MongoDBDatabase$Companion;", "", "()V", "CLIENT", "Lorg/kingdoms/libs/mongodb/client/MongoClient;", "DATABASE", "Lorg/kingdoms/libs/mongodb/client/MongoDatabase;", "DEFAULT_DECODER_CONTEXT", "Lorg/kingdoms/libs/bson/codecs/DecoderContext;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "PRIMARY_KEY_ID", "", "UPSERT", "Lorg/kingdoms/libs/mongodb/client/model/ReplaceOptions;", "withCollection", "Lorg/kingdoms/data/database/mongo/MongoDBDatabase;", "K", "T", "Lorg/kingdoms/constants/metadata/KingdomsObject;", "name", "dataHandler", "Lorg/kingdoms/data/handlers/DataHandler;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <K, T extends KingdomsObject<K>> MongoDBDatabase<K, T> withCollection(@NotNull String name, @NotNull DataHandler<K, T> dataHandler) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
            String collectionName = KingdomsConfig.DATABASE_TABLE_PREFIX.getString() + '_' + name;
            MongoCollection mongoCollection = DATABASE.getCollection(collectionName);
            Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"DATABASE.getCollection(collectionName)");
            return new MongoDBDatabase(dataHandler, mongoCollection, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

