/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.mongo;

import org.kingdoms.libs.bson.BsonDocument;
import org.kingdoms.libs.bson.BsonDocumentWrapper;
import org.kingdoms.libs.bson.BsonWriter;
import org.kingdoms.libs.bson.codecs.Encoder;
import org.kingdoms.libs.bson.codecs.EncoderContext;
import org.kingdoms.libs.bson.codecs.configuration.CodecRegistry;
import org.kingdoms.libs.bson.conversions.Bson;
import org.kingdoms.utils.internal.Fn;

public final class MongoIdQueryContainer<K>
implements Bson {
    private final K _id;
    private final Class<K> idClass;

    public MongoIdQueryContainer(K id, Class<K> idClass) {
        this._id = id;
        this.idClass = idClass;
    }

    public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
        return new BsonDocumentWrapper((Object)this, (Encoder)new BsonEncoder(codecRegistry));
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this._id + ']';
    }

    private final class BsonEncoder
    implements Encoder<MongoIdQueryContainer<K>> {
        private static final String ID_FIELD_NAME = "_id";
        private final CodecRegistry codecRegistry;

        private BsonEncoder(CodecRegistry codecRegistry) {
            this.codecRegistry = codecRegistry;
        }

        public void encode(BsonWriter writer, MongoIdQueryContainer<K> value, EncoderContext encoderContext) {
            writer.writeStartDocument();
            writer.writeName(ID_FIELD_NAME);
            encoderContext.encodeWithChildContext((Encoder)this.codecRegistry.get(value.idClass), writer, value._id);
            writer.writeEndDocument();
        }

        public Class<MongoIdQueryContainer<K>> getEncoderClass() {
            return (Class)Fn.cast(MongoIdQueryContainer.class);
        }
    }
}

