/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.IdDataTypeHandler;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.flatfile.json.JsonElementDataProvider;
import org.kingdoms.data.database.flatfile.json.KingdomsGson;
import org.kingdoms.data.database.flatfile.json.NamedJsonDataProvider;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLDataProvider;
import org.kingdoms.data.database.sql.statements.getters.SimpleResultSetQuery;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.internal.TriConsumer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003BU\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\u00020\u000f2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u0016j\b\u0012\u0004\u0012\u00020\u000f`\u0017H\u0016J?\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0001\u0010\u001a\"\u000e\b\u0002\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u001a0\u001b2\u0006\u0010\u001c\u001a\u0002H\u00192\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\u00030\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ \u0010 \u001a\u00020!2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020!0\u0016j\b\u0012\u0004\u0012\u00020!`\u0017H\u0016J \u0010\"\u001a\u00020#2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020#0\u0016j\b\u0012\u0004\u0012\u00020#`\u0017H\u0016J \u0010$\u001a\u00020%2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020%0\u0016j\b\u0012\u0004\u0012\u00020%`\u0017H\u0016J\n\u0010&\u001a\u0004\u0018\u00010'H\u0016J \u0010(\u001a\u00020)2\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020)0\u0016j\b\u0012\u0004\u0012\u00020)`\u0017H\u0016JQ\u0010*\u001a\u0002H+\"\u0004\b\u0001\u0010\u0001\"\u0004\b\u0002\u0010\u001a\"\u0014\b\u0003\u0010+*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u001a0,2\u0006\u0010-\u001a\u0002H+2\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00030/H\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u0003H\u0016J\b\u00103\u001a\u000204H\u0016J\n\u00105\u001a\u0004\u0018\u000106H\u0016J&\u00107\u001a\u0004\u0018\u00010\f2\u001a\u0010\u0015\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0016j\n\u0012\u0006\u0012\u0004\u0018\u00010\f`\u0017H\u0016J\n\u00108\u001a\u0004\u0018\u000109H\u0016J\u0011\u0010:\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\fH\u0096\u0002R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/kingdoms/data/database/sql/SQLDataGetterProvider;", "K", "Lorg/kingdoms/data/database/sql/SQLDataProvider;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "id", "idType", "Lorg/kingdoms/data/database/dataprovider/IdDataTypeHandler;", "connection", "Ljava/sql/Connection;", "table", "", "name", "isInsideSingularEntity", "", "nameIsSection", "statement", "Lorg/kingdoms/data/database/sql/statements/getters/SimpleResultSetQuery;", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/Object;Lorg/kingdoms/data/database/dataprovider/IdDataTypeHandler;Ljava/sql/Connection;Ljava/lang/String;Ljava/lang/String;ZZLorg/kingdoms/data/database/sql/statements/getters/SimpleResultSetQuery;)V", "asBoolean", "default", "Lorg/kingdoms/libs/kotlin/Function0;", "Lorg/kingdoms/data/database/dataprovider/Supply;", "asCollection", "C", "V", "", "collection", "elementHandler", "Ljava/util/function/BiConsumer;", "(Ljava/util/Collection;Ljava/util/function/BiConsumer;)Ljava/util/Collection;", "asDouble", "", "asFloat", "", "asInt", "", "asLocation", "Lorg/bukkit/Location;", "asLong", "", "asMap", "M", "", "map", "handler", "Lorg/kingdoms/utils/internal/TriConsumer;", "Lorg/kingdoms/data/database/dataprovider/DataGetter;", "(Ljava/util/Map;Lorg/kingdoms/utils/internal/TriConsumer;)Ljava/util/Map;", "asSection", "asSimpleChunkLocation", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "asSimpleLocation", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "asString", "asUUID", "Ljava/util/UUID;", "get", "core"})
public final class SQLDataGetterProvider<K>
extends SQLDataProvider<K>
implements SectionableDataGetter {
    @NotNull
    private final SimpleResultSetQuery statement;

    public SQLDataGetterProvider(@NotNull DatabaseType databaseType, K id, @NotNull IdDataTypeHandler<K> idType, @NotNull Connection connection, @NotNull String table, @Nullable String name, boolean isInsideSingularEntity, boolean nameIsSection, @NotNull SimpleResultSetQuery statement) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter(idType, (String)"idType");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        super(databaseType, id, idType, connection, table, name, isInsideSingularEntity, nameIsSection);
        this.statement = statement;
    }

    @Override
    @NotNull
    public SectionableDataGetter asSection() {
        return new SQLDataGetterProvider(this.getDatabaseType$core(), this.getId$core(), this.getIdType$core(), this.getConnection$core(), this.getTable$core(), this.getName$core(), false, true, this.statement);
    }

    @Override
    @NotNull
    public SectionableDataGetter get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.getName$core() != null && !this.getNameIsSection$core()) {
            throw new IllegalStateException("Attempting to get() without specifying the previous ones type: " + this.getTable$core() + " -> " + this.getName$core() + " -> " + name);
        }
        return new SQLDataGetterProvider(this.getDatabaseType$core(), this.getId$core(), this.getIdType$core(), this.getConnection$core(), this.getTable$core(), this.nameSepOrEmpty$core() + name, false, false, this.statement);
    }

    @Override
    @Nullable
    public String asString(@NotNull Function0<String> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        String string = this.statement.getString(this.getNamed$core());
        if (string == null) {
            string = (String)function0.invoke();
        }
        return string;
    }

    @Override
    @Nullable
    public UUID asUUID() {
        return this.statement.getUUID(this.getNamed$core());
    }

    @Override
    @Nullable
    public SimpleLocation asSimpleLocation() {
        SectionableDataGetter $this$asSimpleLocation_u24lambda_u2d0 = this.asSection();
        boolean bl = false;
        String string = $this$asSimpleLocation_u24lambda_u2d0.getString("world");
        if (string == null) {
            return null;
        }
        return new SimpleLocation(string, $this$asSimpleLocation_u24lambda_u2d0.getInt("x"), $this$asSimpleLocation_u24lambda_u2d0.getInt("y"), $this$asSimpleLocation_u24lambda_u2d0.getInt("z"));
    }

    @Override
    @NotNull
    public SimpleChunkLocation asSimpleChunkLocation() {
        SectionableDataGetter $this$asSimpleChunkLocation_u24lambda_u2d1 = this.asSection();
        boolean bl = false;
        String string = $this$asSimpleChunkLocation_u24lambda_u2d1.getString("world");
        Intrinsics.checkNotNull((Object)string);
        return new SimpleChunkLocation(string, $this$asSimpleChunkLocation_u24lambda_u2d1.getInt("x"), $this$asSimpleChunkLocation_u24lambda_u2d1.getInt("z"));
    }

    @Override
    @Nullable
    public Location asLocation() {
        SectionableDataGetter $this$asLocation_u24lambda_u2d2 = this.asSection();
        boolean bl = false;
        String string = $this$asLocation_u24lambda_u2d2.getString("world");
        if (string == null) {
            return null;
        }
        String world = string;
        return new Location(Bukkit.getWorld((String)world), $this$asLocation_u24lambda_u2d2.getDouble("x"), $this$asLocation_u24lambda_u2d2.getDouble("y"), $this$asLocation_u24lambda_u2d2.getDouble("z"), $this$asLocation_u24lambda_u2d2.getFloat("yaw"), $this$asLocation_u24lambda_u2d2.getFloat("pitch"));
    }

    @Override
    public int asInt(@NotNull Function0<Integer> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        return this.statement.getInt(this.getNamed$core());
    }

    @Override
    public long asLong(@NotNull Function0<Long> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        return this.statement.getLong(this.getNamed$core());
    }

    @Override
    public float asFloat(@NotNull Function0<Float> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        return this.statement.getFloat(this.getNamed$core());
    }

    @Override
    public double asDouble(@NotNull Function0<Double> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        return this.statement.getDouble(this.getNamed$core());
    }

    @Override
    public boolean asBoolean(@NotNull Function0<Boolean> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        return this.statement.getBoolean(this.getNamed$core());
    }

    @Override
    @NotNull
    public <V, C extends Collection<V>> C asCollection(@NotNull C collection, @NotNull BiConsumer<C, SectionableDataGetter> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        String string = this.statement.getString(this.getNamed$core());
        if (string == null) {
            return collection;
        }
        String str = string;
        JsonElement jsonElement = KingdomsGson.fromString(str);
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonArray");
        JsonArray array = (JsonArray)jsonElement;
        for (JsonElement element : array) {
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"element");
            elementHandler.accept(collection, NamedJsonDataProvider.Companion.createProvider$core(element));
        }
        return collection;
    }

    @Override
    @NotNull
    public <K, V, M extends Map<K, V>> M asMap(@NotNull M map, @NotNull TriConsumer<M, DataGetter, SectionableDataGetter> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        String string = this.statement.getString(this.getNamed$core());
        if (string == null) {
            return map;
        }
        String str = string;
        JsonElement jsonElement = KingdomsGson.fromString(str);
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
        JsonObject obj = (JsonObject)jsonElement;
        for (Map.Entry entry : obj.entrySet()) {
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"obj.entrySet()");
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            JsonElementDataProvider jsonElementDataProvider = new JsonElementDataProvider((JsonElement)new JsonPrimitive(key));
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            handler.accept(map, jsonElementDataProvider, NamedJsonDataProvider.Companion.createProvider$core(value));
        }
        return map;
    }
}

