/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.database.dataprovider.IdDataTypeHandler;
import org.kingdoms.data.database.dataprovider.MappingSetterHandler;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StringMappedIdSetter;
import org.kingdoms.data.database.flatfile.json.JsonElementDataProvider;
import org.kingdoms.data.database.flatfile.json.NamedJsonDataProvider;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLDataProvider;
import org.kingdoms.data.database.sql.statements.setters.PreparedNamedSetterStatement;
import org.kingdoms.data.database.sql.statements.setters.RawSimplePreparedStatement;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jdk7.AutoCloseableKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003BU\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0011\u0010\u0018\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\fH\u0096\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J0\u0010\u001b\u001a\u00020\u0015\"\u0004\b\u0001\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002H\u001c0 H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010)H\u0016J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020+H\u0016J<\u0010,\u001a\u00020\u0015\"\u0004\b\u0001\u0010\u0001\"\u0004\b\u0002\u0010\u001c2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u001c0.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u001c00H\u0016J\u0010\u00101\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u000202H\u0016J\u0012\u00103\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u000104H\u0016J\u0012\u00105\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u00106\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u000107H\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/kingdoms/data/database/sql/SQLDataSetterProvider;", "K", "Lorg/kingdoms/data/database/sql/SQLDataProvider;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "id", "idType", "Lorg/kingdoms/data/database/dataprovider/IdDataTypeHandler;", "connection", "Ljava/sql/Connection;", "table", "", "name", "isInsideSingularEntity", "", "nameIsSection", "statement", "Lorg/kingdoms/data/database/sql/statements/setters/PreparedNamedSetterStatement;", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/Object;Lorg/kingdoms/data/database/dataprovider/IdDataTypeHandler;Ljava/sql/Connection;Ljava/lang/String;Ljava/lang/String;ZZLorg/kingdoms/data/database/sql/statements/setters/PreparedNamedSetterStatement;)V", "checkNullName", "", "createSection", "deleteAssociatedData", "get", "setBoolean", "value", "setCollection", "V", "collection", "", "elementHandler", "Ljava/util/function/BiConsumer;", "Lorg/kingdoms/data/database/dataprovider/SectionCreatableDataSetter;", "setDouble", "", "setFloat", "", "setInt", "", "setLocation", "Lorg/bukkit/Location;", "setLong", "", "setMap", "map", "", "handler", "Lorg/kingdoms/data/database/dataprovider/MappingSetterHandler;", "setSimpleChunkLocation", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "setSimpleLocation", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "setString", "setUUID", "Ljava/util/UUID;", "core"})
public final class SQLDataSetterProvider<K>
extends SQLDataProvider<K>
implements SectionableDataSetter {
    @NotNull
    private final PreparedNamedSetterStatement statement;

    public SQLDataSetterProvider(@NotNull DatabaseType databaseType, K id, @NotNull IdDataTypeHandler<K> idType, @NotNull Connection connection, @NotNull String table, @Nullable String name, boolean isInsideSingularEntity, boolean nameIsSection, @NotNull PreparedNamedSetterStatement statement) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter(idType, (String)"idType");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        super(databaseType, id, idType, connection, table, name, isInsideSingularEntity, nameIsSection);
        this.statement = statement;
    }

    private final void checkNullName() {
        if (this.getName$core() != null && !this.getNameIsSection$core()) {
            throw new IllegalStateException("Specified name is not given a type: " + this.getTable$core() + " -> " + this.getName$core());
        }
    }

    @Override
    @NotNull
    public SectionableDataSetter get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkNullName();
        return new SQLDataSetterProvider(this.getDatabaseType$core(), this.getId$core(), this.getIdType$core(), this.getConnection$core(), this.getTable$core(), this.nameSepOrEmpty$core() + name, this.isInsideSingularEntity$core(), false, this.statement);
    }

    @Override
    public void setString(@Nullable String value) {
        this.statement.setString(this.getNamed$core(), value);
    }

    @Override
    public void setInt(int value) {
        this.statement.setInt(this.getNamed$core(), value);
    }

    @Override
    public void setLocation(@Nullable Location value) {
        PreparedNamedSetterStatement preparedNamedSetterStatement;
        if (value == null) {
            return;
        }
        PreparedNamedSetterStatement $this$setLocation_u24lambda_u2d0 = preparedNamedSetterStatement = this.statement;
        boolean bl = false;
        String string = this.getNamed$core() + "_world";
        World world = value.getWorld();
        Intrinsics.checkNotNull((Object)world);
        $this$setLocation_u24lambda_u2d0.setString(string, world.getName());
        $this$setLocation_u24lambda_u2d0.setDouble(this.getNamed$core() + "_x", value.getX());
        $this$setLocation_u24lambda_u2d0.setDouble(this.getNamed$core() + "_y", value.getY());
        $this$setLocation_u24lambda_u2d0.setDouble(this.getNamed$core() + "_z", value.getZ());
        $this$setLocation_u24lambda_u2d0.setFloat(this.getNamed$core() + "_yaw", value.getYaw());
        $this$setLocation_u24lambda_u2d0.setFloat(this.getNamed$core() + "_pitch", value.getPitch());
    }

    @Override
    public void setSimpleLocation(@Nullable SimpleLocation value) {
        PreparedNamedSetterStatement preparedNamedSetterStatement;
        if (value == null) {
            return;
        }
        PreparedNamedSetterStatement $this$setSimpleLocation_u24lambda_u2d1 = preparedNamedSetterStatement = this.statement;
        boolean bl = false;
        String string = this.getNamed$core() + "_world";
        String string2 = value.getWorld();
        Intrinsics.checkNotNull((Object)string2);
        $this$setSimpleLocation_u24lambda_u2d1.setString(string, string2);
        $this$setSimpleLocation_u24lambda_u2d1.setInt(this.getNamed$core() + "_x", value.getX());
        $this$setSimpleLocation_u24lambda_u2d1.setInt(this.getNamed$core() + "_y", value.getY());
        $this$setSimpleLocation_u24lambda_u2d1.setInt(this.getNamed$core() + "_z", value.getZ());
    }

    @Override
    public void setSimpleChunkLocation(@NotNull SimpleChunkLocation value) {
        PreparedNamedSetterStatement preparedNamedSetterStatement;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PreparedNamedSetterStatement $this$setSimpleChunkLocation_u24lambda_u2d2 = preparedNamedSetterStatement = this.statement;
        boolean bl = false;
        $this$setSimpleChunkLocation_u24lambda_u2d2.setString(this.getNamed$core() + "_world", value.getWorld());
        $this$setSimpleChunkLocation_u24lambda_u2d2.setInt(this.getNamed$core() + "_x", value.getX());
        $this$setSimpleChunkLocation_u24lambda_u2d2.setInt(this.getNamed$core() + "_z", value.getZ());
    }

    @Override
    public void setLong(long value) {
        this.statement.setLong(this.getNamed$core(), value);
    }

    @Override
    public void setFloat(float value) {
        this.statement.setFloat(this.getNamed$core(), value);
    }

    @Override
    public void setDouble(double value) {
        this.statement.setDouble(this.getNamed$core(), value);
    }

    @Override
    public void setBoolean(boolean value) {
        this.statement.setBoolean(this.getNamed$core(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void deleteAssociatedData(String table) {
        AutoCloseable autoCloseable = this.getConnection$core().prepareStatement("DELETE FROM `" + table + "` WHERE " + this.getIdType$core().getWhereClause());
        Throwable throwable = null;
        try {
            PreparedStatement it = (PreparedStatement)autoCloseable;
            boolean bl = false;
            IdDataTypeHandler idDataTypeHandler = this.getIdType$core();
            DatabaseType databaseType = this.getDatabaseType$core();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            idDataTypeHandler.setSQL(new RawSimplePreparedStatement(databaseType, it), this.getId$core());
            boolean bl2 = it.execute();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public <V> void setCollection(@NotNull Collection<? extends V> collection, @NotNull BiConsumer<SectionCreatableDataSetter, V> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        if (collection.isEmpty()) {
            this.statement.addParameterIfNotExist(this.getNamed$core());
            this.statement.setJson(this.getNamed$core(), null);
            return;
        }
        JsonArray array = new JsonArray();
        JsonElementDataProvider arrayProvider = new JsonElementDataProvider((JsonElement)array);
        for (V element : collection) {
            elementHandler.accept(arrayProvider, element);
        }
        this.statement.setJson(this.getNamed$core(), (JsonElement)array);
    }

    @Override
    public <K, V> void setMap(@NotNull Map<K, ? extends V> map, @NotNull MappingSetterHandler<K, V> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (map.isEmpty()) {
            this.statement.addParameterIfNotExist(this.getNamed$core());
            this.statement.setJson(this.getNamed$core(), null);
            return;
        }
        JsonObject obj = new JsonObject();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            handler.map(key, new StringMappedIdSetter((Function1<? super String, ? extends SectionCreatableDataSetter>)((Function1)new Function1<String, SectionCreatableDataSetter>(obj){
                final /* synthetic */ JsonObject $obj;
                {
                    this.$obj = $obj;
                    super(1);
                }

                @NotNull
                public final SectionCreatableDataSetter invoke(@NotNull String id) {
                    Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                    return new NamedJsonDataProvider(id, this.$obj);
                }
            })), value);
        }
        this.statement.setJson(this.getNamed$core(), (JsonElement)obj);
    }

    @Override
    @NotNull
    public SectionableDataSetter createSection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.checkNullName();
        return new SQLDataSetterProvider(this.getDatabaseType$core(), this.getId$core(), this.getIdType$core(), this.getConnection$core(), this.getTable$core(), this.nameSepOrEmpty$core() + name, this.isInsideSingularEntity$core(), true, this.statement);
    }

    @Override
    public void setUUID(@Nullable UUID value) {
        this.statement.setUUID(this.getNamed$core(), value);
    }
}

