/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.statements.setters;

import java.sql.PreparedStatement;
import java.util.UUID;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLDatabase;
import org.kingdoms.data.database.sql.statements.setters.SimplePreparedStatement;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0016J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\b8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/data/database/sql/statements/setters/RawSimplePreparedStatement;", "Lorg/kingdoms/data/database/sql/statements/setters/SimplePreparedStatement;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "preparedStatement", "Ljava/sql/PreparedStatement;", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/sql/PreparedStatement;)V", "fromIndex", "", "(ILorg/kingdoms/data/database/sql/DatabaseType;Ljava/sql/PreparedStatement;)V", "index", "getIndex", "()I", "setBoolean", "", "name", "", "value", "", "setDouble", "", "setFloat", "", "setInt", "setLong", "", "setString", "setUUID", "Ljava/util/UUID;", "core"})
public final class RawSimplePreparedStatement
implements SimplePreparedStatement {
    @NotNull
    private final DatabaseType databaseType;
    @NotNull
    private final PreparedStatement preparedStatement;
    private int index;

    public RawSimplePreparedStatement(int fromIndex, @NotNull DatabaseType databaseType, @NotNull PreparedStatement preparedStatement) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)preparedStatement, (String)"preparedStatement");
        this.databaseType = databaseType;
        this.preparedStatement = preparedStatement;
        this.index = fromIndex;
    }

    private final int getIndex() {
        int n = this.index;
        this.index = n + 1;
        return n;
    }

    public RawSimplePreparedStatement(@NotNull DatabaseType databaseType, @NotNull PreparedStatement preparedStatement) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)preparedStatement, (String)"preparedStatement");
        this(1, databaseType, preparedStatement);
    }

    @Override
    public void setString(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setString(this.getIndex(), value);
    }

    @Override
    public void setInt(@NotNull String name, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setInt(this.getIndex(), value);
    }

    @Override
    public void setFloat(@NotNull String name, float value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setFloat(this.getIndex(), value);
    }

    @Override
    public void setLong(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setLong(this.getIndex(), value);
    }

    @Override
    public void setBoolean(@NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setBoolean(this.getIndex(), value);
    }

    @Override
    public void setDouble(@NotNull String name, double value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setDouble(this.getIndex(), value);
    }

    @Override
    public void setUUID(@NotNull String name, @Nullable UUID value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.databaseType == DatabaseType.PostgreSQL) {
            this.preparedStatement.setObject(this.getIndex(), value);
        } else {
            this.preparedStatement.setBytes(this.getIndex(), SQLDatabase.asBytes(value));
        }
    }
}

