/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.bukkit.Location;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.MappedIdSetter;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.data.handlers.DataHandlerRank;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerGroup;", "", "()V", "load", "Lorg/kingdoms/data/handlers/DataHandlerGroup$DataHolder;", "json", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "save", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "data", "Lorg/kingdoms/constants/group/Group;", "DataHolder", "core"})
public final class DataHandlerGroup {
    @NotNull
    public static final DataHandlerGroup INSTANCE = new DataHandlerGroup();

    private DataHandlerGroup() {
    }

    @JvmStatic
    public static final void save(@NotNull SectionableDataSetter provider, @NotNull Group data) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SectionableDataSetter $this$save_u24lambda_u2d8 = sectionableDataSetter = provider;
        boolean bl = false;
        $this$save_u24lambda_u2d8.setString("name", data.getName());
        $this$save_u24lambda_u2d8.setString("tag", data.getTag());
        $this$save_u24lambda_u2d8.setString("tax", data.getTax());
        $this$save_u24lambda_u2d8.setDouble("publicHomeCost", data.getPublicHomeCost());
        if (data.getFlag() != null) {
            $this$save_u24lambda_u2d8.setString("flag", data.getFlag());
        }
        if (data.getColor() != null) {
            $this$save_u24lambda_u2d8.setInt("color", data.getColor().getRGB());
        }
        $this$save_u24lambda_u2d8.setDouble("bank", data.getBank());
        $this$save_u24lambda_u2d8.setLong("resourcePoints", data.getResourcePoints());
        $this$save_u24lambda_u2d8.setLong("since", data.getSince());
        $this$save_u24lambda_u2d8.setLong("shieldSince", data.getShieldSince());
        $this$save_u24lambda_u2d8.setLong("shieldTime", data.getShieldTime());
        $this$save_u24lambda_u2d8.setBoolean("hidden", data.isHidden());
        $this$save_u24lambda_u2d8.setBoolean("publicHome", data.isHomePublic());
        $this$save_u24lambda_u2d8.setBoolean("permanent", data.isPermanent());
        $this$save_u24lambda_u2d8.setBoolean("requiresInvite", data.requiresInvite());
        if (data.getHome() != null) {
            SectionableDataSetter sectionableDataSetter2 = $this$save_u24lambda_u2d8.get("home");
            Location location = data.getHome();
            Intrinsics.checkNotNull((Object)location);
            sectionableDataSetter2.setLocation(location);
        }
        if (data.getNexus() != null) {
            SectionableDataSetter sectionableDataSetter3 = $this$save_u24lambda_u2d8.get("nexus");
            SimpleLocation simpleLocation = data.getNexus();
            Intrinsics.checkNotNull((Object)simpleLocation);
            sectionableDataSetter3.setSimpleLocation(simpleLocation);
        }
        SectionableDataSetter sectionableDataSetter4 = $this$save_u24lambda_u2d8.get("ranks");
        Map<String, Rank> map = data.getRanks().getRanks();
        Intrinsics.checkNotNullExpressionValue(map, (String)"data.ranks.ranks");
        sectionableDataSetter4.setMap(map, DataHandlerGroup::save$lambda-8$lambda-0);
        SectionableDataSetter sectionableDataSetter5 = $this$save_u24lambda_u2d8.get("attributes");
        Map<KingdomRelation, Set<RelationAttribute>> map2 = data.getAttributes();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"data.attributes");
        sectionableDataSetter5.setMap(map2, DataHandlerGroup::save$lambda-8$lambda-2);
        SectionableDataSetter sectionableDataSetter6 = $this$save_u24lambda_u2d8.get("relationshipRequests");
        Map<UUID, KingdomRelationshipRequest> map3 = data.getRelationshipRequests();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"data.relationshipRequests");
        sectionableDataSetter6.setMap(map3, DataHandlerGroup::save$lambda-8$lambda-4);
        SectionableDataSetter sectionableDataSetter7 = $this$save_u24lambda_u2d8.get("relations");
        Map<UUID, KingdomRelation> map4 = data.getRelations();
        Intrinsics.checkNotNullExpressionValue(map4, (String)"data.relations");
        sectionableDataSetter7.setMap(map4, DataHandlerGroup::save$lambda-8$lambda-5);
        SectionableDataSetter sectionableDataSetter8 = $this$save_u24lambda_u2d8.get("logs");
        LinkedList<AuditLog> linkedList = data.getLogs();
        Intrinsics.checkNotNullExpressionValue(linkedList, (String)"data.logs");
        sectionableDataSetter8.setCollection((Collection)linkedList, DataHandlerGroup::save$lambda-8$lambda-7);
        DataHandlerMetadata.serializeMetadata($this$save_u24lambda_u2d8, data);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final DataHolder load(@NotNull SectionableDataGetter json) {
        RankMap rankMap;
        void $this$load_u24lambda_u2d18_u24lambda_u2d92;
        DataHolder dataHolder;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        DataHolder $this$load_u24lambda_u2d18 = dataHolder = new DataHolder();
        boolean bl = false;
        String string = json.getString("name");
        Intrinsics.checkNotNull((Object)string);
        $this$load_u24lambda_u2d18.setName(string);
        $this$load_u24lambda_u2d18.setTag(json.getString("tag"));
        $this$load_u24lambda_u2d18.setTax(json.getString("tax"));
        $this$load_u24lambda_u2d18.setFlag(json.getString("flag"));
        $this$load_u24lambda_u2d18.setPublicHomeCost(json.getDouble("publicHomeCost"));
        int n = json.getInt("color");
        DataHolder dataHolder2 = $this$load_u24lambda_u2d18;
        boolean bl22 = false;
        dataHolder2.setColor($this$load_u24lambda_u2d18_u24lambda_u2d92 == false ? null : new Color((int)$this$load_u24lambda_u2d18_u24lambda_u2d92));
        $this$load_u24lambda_u2d18.setBank(json.getDouble("bank"));
        $this$load_u24lambda_u2d18.setResourcePoints(json.getLong("resourcePoints"));
        $this$load_u24lambda_u2d18.setSince(json.getLong("since"));
        $this$load_u24lambda_u2d18.setShieldSince(json.getLong("shieldSince"));
        $this$load_u24lambda_u2d18.setShieldTime(json.getLong("shieldTime"));
        $this$load_u24lambda_u2d18.setPublicHome(json.getBoolean("publicHome"));
        $this$load_u24lambda_u2d18.setPermanent(json.getBoolean("permanent"));
        $this$load_u24lambda_u2d18.setRequiresInvite(json.getBoolean("requiresInvite"));
        $this$load_u24lambda_u2d18.setHome(json.get("home").asLocation());
        $this$load_u24lambda_u2d18.setNexus(json.get("nexus").asSimpleLocation());
        HashMap rankMapping = json.get("ranks").asMap((Map)new HashMap(), DataHandlerGroup::load$lambda-18$lambda-10);
        DataHolder dataHolder3 = $this$load_u24lambda_u2d18;
        if (rankMapping.isEmpty()) {
            rankMap = Rank.copyDefaults();
        } else {
            void var15_17;
            void destination$iv;
            void $this$mapKeysTo$iv;
            HashMap $this$load_u24lambda_u2d18_u24lambda_u2d92 = rankMapping;
            Map bl22 = new TreeMap();
            HashMap hashMap = rankMapping;
            dataHolder2 = dataHolder3;
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv = $this$mapKeysTo$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv;
                var15_17 = destination$iv;
                boolean bl3 = false;
                Rank v = (Rank)entry.getValue();
                Map.Entry entry2 = (Map.Entry)element$iv$iv;
                Integer n2 = v.getPriority();
                entry = var15_17;
                boolean bl4 = false;
                Object v2 = it$iv.getValue();
                entry.put(n2, v2);
            }
            var15_17 = destination$iv;
            dataHolder3 = dataHolder2;
            TreeMap treeMap = (TreeMap)var15_17;
            HashMap hashMap2 = hashMap;
            rankMap = new RankMap(hashMap2, treeMap);
        }
        dataHolder3.setRanks(rankMap);
        $this$load_u24lambda_u2d18.setAttributes(json.get("attributes").asMap((Map)new QuickEnumMap((Enum[])KingdomRelation.VALUES), DataHandlerGroup::load$lambda-18$lambda-13));
        $this$load_u24lambda_u2d18.setRelationshipRequests(json.get("relationshipRequests").asMap((Map)new HashMap(), DataHandlerGroup::load$lambda-18$lambda-15));
        $this$load_u24lambda_u2d18.setRelations(json.get("relations").asMap((Map)new HashMap(), DataHandlerGroup::load$lambda-18$lambda-16));
        $this$load_u24lambda_u2d18.setLogs(json.get("logs").asCollection((Collection)new LinkedList(), (arg_0, arg_1) -> DataHandlerGroup.load$lambda-18$lambda-17($this$load_u24lambda_u2d18, arg_0, arg_1)));
        return dataHolder;
    }

    private static final void save$lambda-8$lambda-0(String key, MappedIdSetter keyProvider, Rank value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key);
        DataHandlerRank.serializeRank(value, keyProvider.getValueProvider().createSection());
    }

    private static final void save$lambda-8$lambda-2$lambda-1(SectionCreatableDataSetter elementProvider, RelationAttribute element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setString(element.getNamespace().asNormalizedString());
    }

    private static final void save$lambda-8$lambda-2(KingdomRelation key, MappedIdSetter keyProvider, Set value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key.name());
        SectionCreatableDataSetter sectionCreatableDataSetter = keyProvider.getValueProvider();
        Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
        sectionCreatableDataSetter.setCollection(value, DataHandlerGroup::save$lambda-8$lambda-2$lambda-1);
    }

    private static final void save$lambda-8$lambda-4(UUID key, MappedIdSetter keyProvider, KingdomRelationshipRequest value) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setUUID(key);
        SectionableDataSetter $this$save_u24lambda_u2d8_u24lambda_u2d4_u24lambda_u2d3 = sectionableDataSetter = keyProvider.getValueProvider().createSection();
        boolean bl = false;
        $this$save_u24lambda_u2d8_u24lambda_u2d4_u24lambda_u2d3.setString("relation", value.getRelation().name());
        $this$save_u24lambda_u2d8_u24lambda_u2d4_u24lambda_u2d3.setUUID("sender", value.getSender());
        $this$save_u24lambda_u2d8_u24lambda_u2d4_u24lambda_u2d3.setLong("acceptTime", value.getAcceptTime());
        $this$save_u24lambda_u2d8_u24lambda_u2d4_u24lambda_u2d3.setLong("timestamp", value.getTimestamp());
    }

    private static final void save$lambda-8$lambda-5(UUID key, MappedIdSetter keyProvider, KingdomRelation value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setUUID(key);
        keyProvider.getValueProvider().setString(value.name());
    }

    private static final void save$lambda-8$lambda-7(SectionCreatableDataSetter elementProvider, AuditLog element) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        SectionableDataSetter $this$save_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6 = sectionableDataSetter = elementProvider.createSection();
        boolean bl = false;
        $this$save_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6.setString("namespace", element.getProvider().getNamespace().asNormalizedString());
        element.serialize(new SerializationContext<DataSetter>($this$save_u24lambda_u2d8_u24lambda_u2d7_u24lambda_u2d6));
    }

    private static final void load$lambda-18$lambda-10(HashMap map, DataGetter key, SectionableDataGetter value) {
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        String node = string;
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        Map map2 = map;
        Rank rank = DataHandlerRank.deserializeRank(node, value);
        Intrinsics.checkNotNullExpressionValue((Object)rank, (String)"deserializeRank(node, value)");
        Rank rank2 = rank;
        map2.put(node, rank2);
    }

    private static final void load$lambda-18$lambda-13$lambda-12(HashSet set, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Namespace namespace = Namespace.fromString(element.asString());
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(element.asString())");
        Namespace ns = namespace;
        set.add(Kingdoms.get().getRelationAttributeRegistry().getRegistered(ns));
    }

    private static final void load$lambda-18$lambda-13(Map map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map.put(KingdomRelation.valueOf(string), value.asCollection((Collection)new HashSet(), DataHandlerGroup::load$lambda-18$lambda-13$lambda-12));
    }

    private static final void load$lambda-18$lambda-15(HashMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        Map map2 = map;
        UUID uUID = key.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        UUID uUID2 = uUID;
        SectionableDataGetter it = value;
        boolean bl = false;
        String string = it.getString("relation");
        Intrinsics.checkNotNull((Object)string);
        KingdomRelation relation = KingdomRelation.valueOf(string);
        UUID sender = it.get("sender").asUUID();
        long acceptTime = it.getLong("acceptTime");
        long timestamp = it.getLong("timestamp");
        KingdomRelationshipRequest kingdomRelationshipRequest = new KingdomRelationshipRequest(relation, sender, acceptTime, timestamp);
        map2.put(uUID2, kingdomRelationshipRequest);
    }

    private static final void load$lambda-18$lambda-16(HashMap map, DataGetter k, SectionableDataGetter v) {
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"map");
        Map map2 = map;
        UUID uUID = k.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        String string = v.asString();
        Intrinsics.checkNotNull((Object)string);
        map2.put(uUID, KingdomRelation.valueOf(string));
    }

    private static final void load$lambda-18$lambda-17(DataHolder $this_apply, LinkedList logs, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)logs, (String)"logs");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Namespace namespace = Namespace.fromString(element.get("namespace").asString());
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(element.get(\"namespace\").asString())");
        Namespace ns = namespace;
        AuditLogProvider provider = (AuditLogProvider)Kingdoms.get().getAuditLogRegistry().getRegistered(ns);
        if (provider == null) {
            KLogger.warn("No log provider found for '" + ns + "' in kingdom: " + $this_apply.getName());
            return;
        }
        try {
            AuditLog auditLog = provider.construct();
            Intrinsics.checkNotNullExpressionValue((Object)auditLog, (String)"provider.construct()");
            AuditLog auditLog2 = auditLog;
            auditLog2.deserialize(new DeserializationContext<DataGetter>(element));
            logs.add(auditLog2);
        }
        catch (Throwable ex) {
            KLogger.error("Error while deserializing " + ns.asString() + " log:");
            ex.printStackTrace();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R.\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\"\u0010*\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001b\"\u0004\b3\u0010\u001dR\u001c\u00104\u001a\u0004\u0018\u000105X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u001a\u0010:\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010!\"\u0004\b<\u0010#R\u001a\u0010=\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010!\"\u0004\b?\u0010#R\u001a\u0010@\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u000f\"\u0004\bB\u0010\u0011R\u001c\u0010C\u001a\u0004\u0018\u00010DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR(\u0010I\u001a\u0010\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\t\"\u0004\bL\u0010\u000bR(\u0010M\u001a\u0010\u0012\u0004\u0012\u00020J\u0012\u0004\u0012\u00020N\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010\t\"\u0004\bP\u0010\u000bR\u001a\u0010Q\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010!\"\u0004\bS\u0010#R\u001a\u0010T\u001a\u00020UX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010W\"\u0004\bX\u0010YR\u001a\u0010Z\u001a\u00020UX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010W\"\u0004\b\\\u0010YR\u001a\u0010]\u001a\u00020UX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010W\"\u0004\b_\u0010YR\u001a\u0010`\u001a\u00020UX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010W\"\u0004\bb\u0010YR\u001c\u0010c\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010\u001b\"\u0004\be\u0010\u001dR\u001c\u0010f\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010\u001b\"\u0004\bh\u0010\u001d\u00a8\u0006i"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerGroup$DataHolder;", "", "()V", "attributes", "", "Lorg/kingdoms/constants/group/model/relationships/KingdomRelation;", "", "Lorg/kingdoms/constants/group/model/relationships/RelationAttribute;", "getAttributes", "()Ljava/util/Map;", "setAttributes", "(Ljava/util/Map;)V", "bank", "", "getBank", "()D", "setBank", "(D)V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "setColor", "(Ljava/awt/Color;)V", "flag", "", "getFlag", "()Ljava/lang/String;", "setFlag", "(Ljava/lang/String;)V", "hidden", "", "getHidden", "()Z", "setHidden", "(Z)V", "home", "Lorg/bukkit/Location;", "getHome", "()Lorg/bukkit/Location;", "setHome", "(Lorg/bukkit/Location;)V", "logs", "Ljava/util/LinkedList;", "Lorg/kingdoms/constants/group/model/logs/AuditLog;", "getLogs", "()Ljava/util/LinkedList;", "setLogs", "(Ljava/util/LinkedList;)V", "name", "getName", "setName", "nexus", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "getNexus", "()Lorg/kingdoms/constants/land/location/SimpleLocation;", "setNexus", "(Lorg/kingdoms/constants/land/location/SimpleLocation;)V", "permanent", "getPermanent", "setPermanent", "publicHome", "getPublicHome", "setPublicHome", "publicHomeCost", "getPublicHomeCost", "setPublicHomeCost", "ranks", "Lorg/kingdoms/constants/player/RankMap;", "getRanks", "()Lorg/kingdoms/constants/player/RankMap;", "setRanks", "(Lorg/kingdoms/constants/player/RankMap;)V", "relations", "Ljava/util/UUID;", "getRelations", "setRelations", "relationshipRequests", "Lorg/kingdoms/constants/group/model/relationships/KingdomRelationshipRequest;", "getRelationshipRequests", "setRelationshipRequests", "requiresInvite", "getRequiresInvite", "setRequiresInvite", "resourcePoints", "", "getResourcePoints", "()J", "setResourcePoints", "(J)V", "shieldSince", "getShieldSince", "setShieldSince", "shieldTime", "getShieldTime", "setShieldTime", "since", "getSince", "setSince", "tag", "getTag", "setTag", "tax", "getTax", "setTax", "core"})
    public static final class DataHolder {
        public String name;
        @Nullable
        private String tag;
        @Nullable
        private String tax;
        @Nullable
        private String flag;
        @Nullable
        private Color color;
        private long since;
        private long shieldSince;
        private long shieldTime;
        private long resourcePoints;
        private double publicHomeCost;
        private double bank;
        @Nullable
        private Location home;
        @Nullable
        private SimpleLocation nexus;
        private boolean requiresInvite;
        private boolean hidden;
        private boolean permanent;
        private boolean publicHome;
        @Nullable
        private RankMap ranks;
        @Nullable
        private LinkedList<AuditLog> logs;
        @Nullable
        private Map<UUID, KingdomRelation> relations;
        @Nullable
        private Map<KingdomRelation, Set<RelationAttribute>> attributes;
        @Nullable
        private Map<UUID, KingdomRelationshipRequest> relationshipRequests;

        @NotNull
        public final String getName() {
            String string = this.name;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
            return null;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @Nullable
        public final String getTag() {
            return this.tag;
        }

        public final void setTag(@Nullable String string) {
            this.tag = string;
        }

        @Nullable
        public final String getTax() {
            return this.tax;
        }

        public final void setTax(@Nullable String string) {
            this.tax = string;
        }

        @Nullable
        public final String getFlag() {
            return this.flag;
        }

        public final void setFlag(@Nullable String string) {
            this.flag = string;
        }

        @Nullable
        public final Color getColor() {
            return this.color;
        }

        public final void setColor(@Nullable Color color) {
            this.color = color;
        }

        public final long getSince() {
            return this.since;
        }

        public final void setSince(long l) {
            this.since = l;
        }

        public final long getShieldSince() {
            return this.shieldSince;
        }

        public final void setShieldSince(long l) {
            this.shieldSince = l;
        }

        public final long getShieldTime() {
            return this.shieldTime;
        }

        public final void setShieldTime(long l) {
            this.shieldTime = l;
        }

        public final long getResourcePoints() {
            return this.resourcePoints;
        }

        public final void setResourcePoints(long l) {
            this.resourcePoints = l;
        }

        public final double getPublicHomeCost() {
            return this.publicHomeCost;
        }

        public final void setPublicHomeCost(double d) {
            this.publicHomeCost = d;
        }

        public final double getBank() {
            return this.bank;
        }

        public final void setBank(double d) {
            this.bank = d;
        }

        @Nullable
        public final Location getHome() {
            return this.home;
        }

        public final void setHome(@Nullable Location location) {
            this.home = location;
        }

        @Nullable
        public final SimpleLocation getNexus() {
            return this.nexus;
        }

        public final void setNexus(@Nullable SimpleLocation simpleLocation) {
            this.nexus = simpleLocation;
        }

        public final boolean getRequiresInvite() {
            return this.requiresInvite;
        }

        public final void setRequiresInvite(boolean bl) {
            this.requiresInvite = bl;
        }

        public final boolean getHidden() {
            return this.hidden;
        }

        public final void setHidden(boolean bl) {
            this.hidden = bl;
        }

        public final boolean getPermanent() {
            return this.permanent;
        }

        public final void setPermanent(boolean bl) {
            this.permanent = bl;
        }

        public final boolean getPublicHome() {
            return this.publicHome;
        }

        public final void setPublicHome(boolean bl) {
            this.publicHome = bl;
        }

        @Nullable
        public final RankMap getRanks() {
            return this.ranks;
        }

        public final void setRanks(@Nullable RankMap rankMap) {
            this.ranks = rankMap;
        }

        @Nullable
        public final LinkedList<AuditLog> getLogs() {
            return this.logs;
        }

        public final void setLogs(@Nullable LinkedList<AuditLog> linkedList) {
            this.logs = linkedList;
        }

        @Nullable
        public final Map<UUID, KingdomRelation> getRelations() {
            return this.relations;
        }

        public final void setRelations(@Nullable Map<UUID, KingdomRelation> map) {
            this.relations = map;
        }

        @Nullable
        public final Map<KingdomRelation, Set<RelationAttribute>> getAttributes() {
            return this.attributes;
        }

        public final void setAttributes(@Nullable Map<KingdomRelation, Set<RelationAttribute>> map) {
            this.attributes = map;
        }

        @Nullable
        public final Map<UUID, KingdomRelationshipRequest> getRelationshipRequests() {
            return this.relationshipRequests;
        }

        public final void setRelationshipRequests(@Nullable Map<UUID, KingdomRelationshipRequest> map) {
            this.relationshipRequests = map;
        }
    }
}

