/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerNation;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.string.QuantumString;

public final class NationManager
extends DataManager<UUID, Nation> {
    private static final Map<QuantumString, UUID> NAMES = new HashMap<QuantumString, UUID>();

    public NationManager(KingdomsDataCenter dataCenter) {
        super("nations", dataCenter.constructDatabase(KingdomsConfig.DATABASE_TABLES_NATIONS.getString(), "nations", new DataHandlerNation()));
        this.autoSave(Kingdoms.get());
    }

    public static Map<QuantumString, UUID> getNames() {
        return Collections.unmodifiableMap(NAMES);
    }

    public static QuantumString toQuantumName(String name) {
        return new QuantumString(name, !KingdomsConfig.NATION_NAME_CASE_SENSITIVE.getBoolean());
    }

    @Override
    public Nation getData(String name) {
        UUID id = NAMES.get(NationManager.toQuantumName(name));
        return id == null ? null : (Nation)this.getData(id);
    }

    public Collection<Nation> getNations() {
        return this.peekAllData();
    }

    public List<Nation> getTopNations(int skip, int limit) {
        return this.getNations().stream().sorted(Nation.getTopComparator().reversed()).skip(skip).limit(limit).collect(Collectors.toList());
    }

    public void renameNation(Nation nation, String rename) {
        this.remove(nation);
        NAMES.put(NationManager.toQuantumName(rename), nation.getId());
    }

    public void remove(Nation nation) {
        NAMES.remove(NationManager.toQuantumName(nation.getName()));
    }

    @Override
    protected void onLoad(Nation value) {
        NAMES.put(NationManager.toQuantumName(value.getName()), value.getId());
    }

    public void rename(Nation nation, String rename) {
        this.remove(nation);
        NAMES.put(NationManager.toQuantumName(rename), nation.getId());
    }
}

