/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.general;

import java.util.Objects;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;

public class GroupRelationshipChangeEvent
extends KingdomsEvent
implements Cancellable,
PlayerOperator {
    private static final HandlerList handlers = new HandlerList();
    private final Group first;
    private final Group second;
    private final KingdomRelation newRelation;
    private final @Nullable KingdomPlayer player;
    private boolean cancelled;

    public GroupRelationshipChangeEvent(@Nullable KingdomPlayer player, Group first, Group second, KingdomRelation newRelation) {
        this.player = player;
        this.first = Objects.requireNonNull(first);
        this.second = Objects.requireNonNull(second);
        this.newRelation = Objects.requireNonNull(newRelation);
        if (first.getClass() != second.getClass()) {
            throw new IllegalArgumentException("Relationship cannot change between two different group types: " + first.getClass().getName() + " - " + second.getClass().getName());
        }
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public KingdomRelation getOldRelation() {
        return this.first.getRelations().get(this.second.getId());
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public Group getFirst() {
        return this.first;
    }

    public Group getSecond() {
        return this.second;
    }

    public KingdomRelation getNewRelation() {
        return this.newRelation;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public @Nullable KingdomPlayer getPlayer() {
        return this.player;
    }
}

