/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.gui.GUILanguageSyncer;
import org.kingdoms.gui.GUIParser;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.objects.GUIObject;
import org.kingdoms.libs.snakeyaml.api.Load;
import org.kingdoms.libs.snakeyaml.api.LoadSettings;
import org.kingdoms.libs.snakeyaml.composer.Composer;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.Validator;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.adapters.YamlFiledDefaults;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

public final class GUIConfig {
    private static final Map<String, Function<CommandContext, InteractiveGUI>> INDEPENDENT_GUIS = new HashMap<String, Function<CommandContext, InteractiveGUI>>();
    protected static final NodeValidator SCHEMA;
    public static final String FOLDER_NAME = "guis";
    public static final Path FOLDER;
    private static final Function<String[], Boolean> SYNC_INCLUSION;

    public static Path getFolder() {
        return FOLDER;
    }

    public static void loadGUIs(Plugin owner) {
        String starter = "/guis";
        URI uri = null;
        try {
            uri = owner.getClass().getResource(starter).toURI();
        }
        catch (Exception ex) {
            MessageHandler.sendConsolePluginMessage("&cUnable to find plugin GUI with URI&8: &e" + starter);
            MessageHandler.sendConsolePluginMessage("&cUsing the default GUI config...");
            ex.printStackTrace();
        }
        try (FileSystem zipfs = FileSystems.newFileSystem(uri, new HashMap());){
            int len = starter.length() + 1;
            Files.walk(zipfs.getPath(starter, new String[0]), new FileVisitOption[0]).forEach(gui -> {
                String name = gui.toString();
                if (name.endsWith(".yml")) {
                    name = name.substring(len, name.length() - 4);
                    GUIConfig.registerGUI(owner, name, false);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void init() {
        GUIConfig.loadGUIs((Plugin)Kingdoms.get());
        for (String turret : TurretRegistry.getStyles().keySet()) {
            try {
                GUIConfig.registerGUI((Plugin)Kingdoms.get(), "turrets/" + turret, true);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        for (SupportedLanguage otherLangs : SupportedLanguage.VALUES) {
            if (otherLangs == SupportedLanguage.EN || !otherLangs.isInstalled()) continue;
            GUIConfig.registerGUIsFor(otherLangs);
        }
        GUIConfig.standardGUISync();
    }

    public static void standardGUISync() {
        if (!KingdomsConfig.UPDATES_SYNCHRONIZE_GUIS_AUTOMATIC.getBoolean()) {
            return;
        }
        String refLangName = KingdomsConfig.UPDATES_SYNCHRONIZE_GUIS_REFERENCE_LANGUAGE.getString();
        if (refLangName == null || refLangName.isEmpty()) {
            return;
        }
        SupportedLanguage refLang = SupportedLanguage.fromName(refLangName);
        if (refLang == null) {
            KLogger.error("Unknown reference language specified for GUI synchronization: " + refLangName);
            return;
        }
        if (!refLang.isInstalled()) {
            KLogger.error("The specified reference language for GUI synchronization is not installed: " + (Object)((Object)refLang));
            return;
        }
        KLogger.info("Synchronizing GUIs against " + (Object)((Object)refLang) + "...");
        int synced = GUIConfig.synchronizeAllGUIs(refLang);
        KLogger.info("Synchronized a total of " + synced + " GUIs.");
    }

    public static void registerIndependentGUI(KingdomsGUI gui, Function<CommandContext, InteractiveGUI> fn) {
        String name = gui.getGUIPath();
        if (INDEPENDENT_GUIS.containsKey(name)) {
            throw new IllegalArgumentException("Independent GUI already registered: " + name);
        }
        INDEPENDENT_GUIS.put(name, fn);
    }

    public static Map<String, Function<CommandContext, InteractiveGUI>> getIndependentGuis() {
        return INDEPENDENT_GUIS;
    }

    public static GUIObject getGUI(String name, SupportedLanguage locale) {
        GUIObject guiTemplate = locale.getGUIOrDefault(name);
        if (guiTemplate == null) {
            throw new IllegalArgumentException("Unknown GUI: " + name + " (for locale " + (Object)((Object)locale) + ')');
        }
        if (guiTemplate.getConfig().getFile() != null && !guiTemplate.getConfig().getFile().exists()) {
            KLogger.warn("The GUI file for '" + name + "' was deleted, regenerating a new one...");
            guiTemplate.getConfig().saveDefaultConfig();
            GUIConfig.reload(guiTemplate, locale);
        }
        return guiTemplate;
    }

    public static void reload(String name, SupportedLanguage locale) {
        GUIObject gui = locale.getGUIOrDefault(name);
        Objects.requireNonNull(gui, () -> "Cannot reload unknown GUI: " + name);
        GUIConfig.reload(gui, locale);
    }

    public static void reload(GUIObject gui, SupportedLanguage lang) {
        GUIConfig.reload(gui, lang, true);
    }

    public static void reload(GUIObject gui, SupportedLanguage lang, boolean sync) {
        Objects.requireNonNull(gui, () -> "Cannot reload null GUI for locale: " + (Object)((Object)lang));
        Objects.requireNonNull(lang, () -> "Cannot reload GUI for null locale: " + gui.getName());
        gui.getConfig().reload();
        GUIConfig.loadAndRegisterGUI(lang, gui.getConfig(), gui.getName());
        if (sync) {
            GUIConfig.synchronizeGUIs(gui, lang);
        }
    }

    public static int synchronizeAllGUIs(SupportedLanguage refLang) {
        int synced = 0;
        for (SupportedLanguage lang : SupportedLanguage.VALUES) {
            if (lang == refLang || !lang.isInstalled()) continue;
            for (GUIObject gui : lang.getGUIs().values()) {
                GUIObject refGUI = refLang.getGUIs().get(gui.getName());
                if (refGUI == null || !GUIConfig.synchronizeGUI(lang, gui, refGUI)) continue;
                ++synced;
            }
        }
        return synced;
    }

    public static void synchronizeGUIs(GUIObject refGUI, SupportedLanguage except) {
        if (!KingdomsConfig.UPDATES_SYNCHRONIZE_GUIS_AUTOMATIC.getBoolean()) {
            return;
        }
        for (SupportedLanguage lang : SupportedLanguage.VALUES) {
            GUIObject langGUI;
            if (!lang.isInstalled() || lang == except || (langGUI = lang.getGUIs().get(refGUI.getName())) == null) continue;
            GUIConfig.synchronizeGUI(lang, langGUI, refGUI);
        }
    }

    public static boolean synchronizeGUI(SupportedLanguage lang, GUIObject gui, GUIObject refGUI) {
        GUILanguageSyncer sync = new GUILanguageSyncer(gui.getName(), gui.getConfig().getConfig(), refGUI.getConfig().getConfig(), SYNC_INCLUSION);
        sync.update();
        if (sync.hasChanged()) {
            gui.getConfig().saveConfig();
            GUIConfig.reload(gui, lang, false);
        }
        return sync.hasChanged();
    }

    private static void registerGUI(Plugin owner, String name, boolean optional) {
        KLogger.debug((DebugNS)KingdomsDebug.GUIS_CONFIG, "Loading GUI&8: &9" + name);
        SupportedLanguage lang = SupportedLanguage.EN;
        String path = "guis/" + lang.getLowerCaseName() + '/' + name + ".yml";
        String resourcePath = "guis/" + name + ".yml";
        File localFile = new File(Kingdoms.get().getDataFolder(), path);
        if (!optional && !localFile.exists() && owner.getClass().getResource('/' + resourcePath) == null) {
            KLogger.error("Could not find default " + (Object)((Object)lang) + " GUI translation for " + name + " GUI.");
            return;
        }
        YamlResource adapter = new YamlResource(owner, localFile, resourcePath).load();
        adapter.setSchema(SCHEMA);
        GUIConfig.loadAndRegisterGUI(lang, adapter, name);
    }

    public static void loadAndRegisterGUI(SupportedLanguage lang, YamlWithDefaults adapter, String name) {
        if (!adapter.isLoaded()) {
            KLogger.debug((DebugNS)KingdomsDebug.GUIS_CONFIG, () -> "Removed " + lang.getLowerCaseName() + '/' + name + " GUI since its config was not loaded.");
            lang.getGUIs().remove(name);
            return;
        }
        ConfigManager.warnAboutValidation(adapter.getFile().toString(), adapter.validate());
        GUIObject gui = GUIParser.parse(adapter, name);
        if (gui != null) {
            lang.getGUIs().put(name, gui);
        } else {
            lang.getGUIs().remove(name);
            KLogger.debug((DebugNS)KingdomsDebug.GUIS_CONFIG, () -> "Did not load " + lang.getLowerCaseName() + '/' + name + " GUI because it was null");
        }
    }

    public static void registerGUIsFor(SupportedLanguage lang) {
        lang.ensureInstalled();
        Path guisRepoFolder = lang.getRepoPath().resolve(FOLDER_NAME);
        for (String gui : SupportedLanguage.getRegisteredGUINames()) {
            Path guiRepoPath = guisRepoFolder.resolve(gui + ".yml");
            File localFile = lang.getGUIFolder().resolve(gui + ".yml").toFile();
            if (!Files.exists(guiRepoPath, new LinkOption[0]) && !localFile.exists()) continue;
            YamlWithDefaults adapter = GUIConfig.createAdapter(localFile, guiRepoPath.toFile());
            GUIConfig.loadAndRegisterGUI(lang, adapter, gui);
        }
    }

    public static YamlWithDefaults createAdapter(File localFile, File repoFile) {
        YamlWithDefaults adapter = new YamlFiledDefaults(localFile, repoFile).load();
        adapter.setSchema(SCHEMA);
        return adapter;
    }

    public static void reloadAll() {
        for (SupportedLanguage lang : SupportedLanguage.VALUES) {
            if (!lang.isInstalled()) continue;
            for (GUIObject gui : lang.getGUIs().values()) {
                GUIConfig.reload(gui, lang);
            }
        }
        GUIConfig.standardGUISync();
    }

    static {
        FOLDER = Kingdoms.getPath(FOLDER_NAME);
        String schemaPath = "schemas/guis/schema.yml";
        InputStream is = Kingdoms.get().getResource(schemaPath);
        LoadSettings settings = new LoadSettings();
        settings.setLabel("GUI Schema");
        Load load2 = new Load(settings);
        Composer composer = load2.createComposer(is);
        MappingNode schemaYml = composer.getRoot();
        load2.construct(schemaYml);
        SCHEMA = Validator.parseSchema(schemaYml);
        SYNC_INCLUSION = currPath -> {
            String last;
            String first = currPath[0];
            if (first.equals("title")) {
                return true;
            }
            if (first.equals("options") && ((last = currPath[((String[])currPath).length - 1]).equals("name") || last.equals("lore"))) {
                return true;
            }
            return false;
        };
    }
}

