/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.MathUtils;

public final class GUIPagination {
    public static <T> Pair<ReusableOptionHandler, Collection<T>> paginate(InteractiveGUI gui, Collection<T> collection, String option, int page, Consumer<Integer> openPage) {
        ReusableOptionHandler holder = Objects.requireNonNull(gui.getReusableOption(option), () -> "Missing '" + option + "' option from '" + gui.getName() + "' GUI");
        int eachPage = holder.slotsCount();
        int maxPages = MathUtils.getPageNumbers(collection.size(), eachPage);
        gui.getSettings().raw("pages", maxPages);
        gui.getSettings().raw("page", page + 1);
        gui.option("previous-page").onNormalClicks(ctx -> {
            if (page == 0) {
                ctx.sendError(KingdomsLang.GUIS_PAGES_PREVIOUS_PAGE_NOT_AVAILABLE, new Object[0]);
                return;
            }
            openPage.accept(page - 1);
        }).done();
        gui.option("next-page").onNormalClicks(ctx -> {
            if (page + 1 >= maxPages) {
                ctx.sendError(KingdomsLang.GUIS_PAGES_NEXT_PAGE_NOT_AVAILABLE, new Object[0]);
                return;
            }
            openPage.accept(page + 1);
        }).done();
        return Pair.of(holder, (Collection)collection.stream().skip((long)page * (long)eachPage).limit(eachPage).collect(Collectors.toList()));
    }
}

