/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.bedrock.components;

import org.geysermc.cumulus.component.Component;
import org.geysermc.cumulus.component.util.ComponentType;
import org.geysermc.cumulus.form.ModalForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.kingdoms.gui.bedrock.components.FormComponentObject;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.provider.MessageBuilder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/gui/bedrock/components/ButtonObject;", "Lorg/kingdoms/gui/bedrock/components/FormComponentObject;", "text", "Lorg/kingdoms/locale/compiler/MessageObject;", "imageType", "Lorg/geysermc/cumulus/util/FormImage$Type;", "image", "", "(Lorg/kingdoms/locale/compiler/MessageObject;Lorg/geysermc/cumulus/util/FormImage$Type;Ljava/lang/String;)V", "getImage", "()Ljava/lang/String;", "getImageType", "()Lorg/geysermc/cumulus/util/FormImage$Type;", "getText", "()Lorg/kingdoms/locale/compiler/MessageObject;", "build", "Lorg/geysermc/cumulus/component/Component;", "settings", "Lorg/kingdoms/locale/provider/MessageBuilder;", "buildForModal", "", "form", "Lorg/geysermc/cumulus/form/ModalForm$Builder;", "first", "", "buildForSimple", "Lorg/geysermc/cumulus/form/SimpleForm$Builder;", "getType", "Lorg/geysermc/cumulus/component/util/ComponentType;", "core"})
public final class ButtonObject
extends FormComponentObject {
    @NotNull
    private final MessageObject text;
    @Nullable
    private final FormImage.Type imageType;
    @Nullable
    private final String image;

    public ButtonObject(@NotNull MessageObject text, @Nullable FormImage.Type imageType, @Nullable String image) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.imageType = imageType;
        this.image = image;
    }

    @NotNull
    public final MessageObject getText() {
        return this.text;
    }

    @Nullable
    public final FormImage.Type getImageType() {
        return this.imageType;
    }

    @Nullable
    public final String getImage() {
        return this.image;
    }

    @Override
    @NotNull
    public ComponentType getType() {
        return ComponentType.LABEL;
    }

    public final void buildForModal(@NotNull ModalForm.Builder form, @NotNull MessageBuilder settings, boolean first) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        String text = this.text.buildPlain(settings);
        if (first) {
            form.button1(text);
        } else {
            form.button2(text);
        }
    }

    public final void buildForSimple(@NotNull SimpleForm.Builder form, @NotNull MessageBuilder settings) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        String text = this.text.buildPlain(settings);
        if (this.imageType != null && this.image != null) {
            form.button(text, FormImage.of((FormImage.Type)this.imageType, (String)this.image));
        } else {
            form.button(text);
        }
    }

    @Override
    @NotNull
    public Component build(@NotNull MessageBuilder settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        throw new IllegalStateException("Buttons cannot be used for custom forms");
    }
}

