/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.objects;

import java.util.Objects;
import org.kingdoms.gui.objects.GUIOptionBuilder;
import org.kingdoms.gui.objects.GUIOptionObject;
import org.kingdoms.gui.objects.GUIOptionObjectCondition;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.ConditionProcessor;

public class ConditionalGUIOptionObject
implements GUIOptionBuilder {
    private final GUIOptionObject mainObject;
    protected final GUIOptionObjectCondition[] options;

    public ConditionalGUIOptionObject(GUIOptionObject mainObject, GUIOptionObjectCondition[] options) {
        this.mainObject = Objects.requireNonNull(mainObject, "Main settings of conditional option cannot be null");
        this.options = Objects.requireNonNull(options, "Conditional options cannot be null");
    }

    public GUIOptionObjectCondition[] getOptions() {
        return this.options;
    }

    @Override
    public GUIOptionObject getOption(PlaceholderContextProvider contextProvider) {
        for (GUIOptionObjectCondition option : this.options) {
            if (option.condition == null) {
                return option.option.getOption(contextProvider);
            }
            try {
                if (!ConditionProcessor.process(option.condition, contextProvider)) continue;
                return option.option.getOption(contextProvider);
            }
            catch (Exception ex) {
                KLogger.error("Error while evaluating condition for option '" + this.mainObject.getName() + "' " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return this.mainObject;
    }

    public GUIOptionObject getMainObject() {
        return this.mainObject;
    }
}

