/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.gui.objects.GUIInteractionType;
import org.kingdoms.gui.objects.GUIOptionBuilder;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.placeholders.PlaceholderContextProvider;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.string.StringUtils;

public class GUIOptionObject
implements GUIOptionBuilder {
    protected final String name;
    protected final int[] slots;
    protected final XSound.Record sound;
    protected final List<String> commands;
    protected final GUIInteractionType interactionType;
    protected final ItemStack item;
    protected final MessageObject itemName;
    protected final MessageObject[] lore;
    protected final MessageObject message;
    protected final ConfigSection config;

    public GUIOptionObject(String name, int[] slots, XSound.Record sound, List<String> commands, GUIInteractionType interactionType, ItemStack item, MessageObject itemName, MessageObject[] lore, MessageObject message, ConfigSection config) {
        this.name = Objects.requireNonNull(name);
        this.slots = Objects.requireNonNull(slots);
        this.sound = sound;
        this.commands = commands;
        this.interactionType = interactionType;
        this.item = Objects.requireNonNull(item);
        this.itemName = itemName;
        this.lore = lore;
        this.message = message;
        this.config = config;
    }

    public GUIInteractionType getInteractionType() {
        return this.interactionType;
    }

    public ConfigSection getConfig() {
        return this.config;
    }

    @Override
    public GUIOptionObject getOption(PlaceholderContextProvider contextProvider) {
        return this;
    }

    public int[] getSlots() {
        return this.slots;
    }

    public MessageObject getMessage() {
        return this.message;
    }

    public XSound.Record getSound() {
        return this.sound;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack defineVariables(MessageBuilder settings) {
        if (this.item.getType() == Material.AIR) {
            return new ItemStack(Material.AIR);
        }
        ItemStack item = this.item.clone();
        ItemMeta meta = item.getItemMeta();
        if (this.itemName != null) {
            meta.setDisplayName(this.itemName.buildPlain(settings));
        }
        if (this.lore != null) {
            ArrayList<String> translatedLores = new ArrayList<String>(this.lore.length);
            MessageObject lastColor = null;
            for (MessageObject messageObject : this.lore) {
                MessageObject loreLine = messageObject.evaluatePlaceholdersOnly(settings);
                MessageObject newLastColors = loreLine.findLastColors();
                if (lastColor != null) {
                    loreLine = lastColor.merge(loreLine);
                }
                if (newLastColors != null) {
                    lastColor = newLastColors;
                }
                translatedLores.addAll(StringUtils.split(loreLine.buildPlain(settings), '\n', true));
            }
            meta.setLore(translatedLores);
        }
        item.setItemMeta(meta);
        return item;
    }

    public String getName() {
        return this.name;
    }
}

