/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale;

import org.bukkit.Location;
import org.bukkit.World;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.LocationUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u0000 \u00152\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000f\u001a\u00020\u0004J\r\u0010\u0010\u001a\u00020\u0011H \u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/locale/LocationLocale;", "", "()V", "messageBuilder", "Lorg/kingdoms/locale/provider/MessageBuilder;", "getMessageBuilder$core", "()Lorg/kingdoms/locale/provider/MessageBuilder;", "setMessageBuilder$core", "(Lorg/kingdoms/locale/provider/MessageBuilder;)V", "prefix", "", "getPrefix$core", "()Ljava/lang/String;", "setPrefix$core", "(Ljava/lang/String;)V", "build", "parseEdits", "", "parseEdits$core", "withBuilder", "withPrefix", "Companion", "PreciseLocationLocale", "SimpleChunkLocationLocale", "SimpleLocationLocale", "core"})
public abstract class LocationLocale {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private MessageBuilder messageBuilder = new MessageBuilder();
    @NotNull
    private String prefix = "";

    @NotNull
    public final MessageBuilder getMessageBuilder$core() {
        return this.messageBuilder;
    }

    public final void setMessageBuilder$core(@NotNull MessageBuilder messageBuilder) {
        Intrinsics.checkNotNullParameter((Object)messageBuilder, (String)"<set-?>");
        this.messageBuilder = messageBuilder;
    }

    @NotNull
    public final String getPrefix$core() {
        return this.prefix;
    }

    public final void setPrefix$core(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.prefix = string;
    }

    @NotNull
    public final LocationLocale withPrefix(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
        return this;
    }

    @NotNull
    public final LocationLocale withBuilder(@NotNull MessageBuilder messageBuilder) {
        Intrinsics.checkNotNullParameter((Object)messageBuilder, (String)"messageBuilder");
        this.messageBuilder = messageBuilder;
        return this;
    }

    public abstract void parseEdits$core();

    @NotNull
    public final MessageBuilder build() {
        this.parseEdits$core();
        return this.messageBuilder;
    }

    @JvmStatic
    @NotNull
    public static final LocationLocale of(@NotNull SimpleLocation location) {
        return Companion.of(location);
    }

    @JvmStatic
    @NotNull
    public static final LocationLocale of(@NotNull Location location) {
        return Companion.of(location);
    }

    @JvmStatic
    @NotNull
    public static final LocationLocale of(@NotNull SimpleChunkLocation location) {
        return Companion.of(location);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/kingdoms/locale/LocationLocale$Companion;", "", "()V", "of", "Lorg/kingdoms/locale/LocationLocale;", "location", "Lorg/bukkit/Location;", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LocationLocale of(@NotNull SimpleLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return new SimpleLocationLocale(location);
        }

        @JvmStatic
        @NotNull
        public final LocationLocale of(@NotNull Location location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return new PreciseLocationLocale(location);
        }

        @JvmStatic
        @NotNull
        public final LocationLocale of(@NotNull SimpleChunkLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return new SimpleChunkLocationLocale(location);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kingdoms/locale/LocationLocale$SimpleLocationLocale;", "Lorg/kingdoms/locale/LocationLocale;", "location", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "(Lorg/kingdoms/constants/land/location/SimpleLocation;)V", "parseEdits", "", "parseEdits$core", "core"})
    public static final class SimpleLocationLocale
    extends LocationLocale {
        @NotNull
        private final SimpleLocation location;

        public SimpleLocationLocale(@NotNull SimpleLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            this.location = location;
        }

        @Override
        public void parseEdits$core() {
            SimpleLocation simpleLocation;
            SimpleLocation $this$parseEdits_u24lambda_u2d0 = simpleLocation = this.location;
            boolean bl = false;
            this.getMessageBuilder$core().raw(this.getPrefix$core() + "translated-world", LocationUtils.translateWorld($this$parseEdits_u24lambda_u2d0.getWorld())).raw(this.getPrefix$core() + "world", $this$parseEdits_u24lambda_u2d0.getWorld()).raw(this.getPrefix$core() + 'x', $this$parseEdits_u24lambda_u2d0.getX()).raw(this.getPrefix$core() + 'y', $this$parseEdits_u24lambda_u2d0.getY()).raw(this.getPrefix$core() + 'z', $this$parseEdits_u24lambda_u2d0.getZ());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kingdoms/locale/LocationLocale$PreciseLocationLocale;", "Lorg/kingdoms/locale/LocationLocale;", "location", "Lorg/bukkit/Location;", "(Lorg/bukkit/Location;)V", "parseEdits", "", "parseEdits$core", "core"})
    public static final class PreciseLocationLocale
    extends LocationLocale {
        @NotNull
        private final Location location;

        public PreciseLocationLocale(@NotNull Location location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            this.location = location;
        }

        @Override
        public void parseEdits$core() {
            Location location;
            Location $this$parseEdits_u24lambda_u2d0 = location = this.location;
            boolean bl = false;
            World world = $this$parseEdits_u24lambda_u2d0.getWorld();
            String string = world != null ? world.getName() : null;
            if (string == null) {
                string = "";
            }
            String worldName = string;
            this.getMessageBuilder$core().raw(this.getPrefix$core() + "translated-world", LocationUtils.translateWorld(worldName)).raw(this.getPrefix$core() + "world", worldName).raw(this.getPrefix$core() + 'x', (int)$this$parseEdits_u24lambda_u2d0.getX()).raw(this.getPrefix$core() + 'y', (int)$this$parseEdits_u24lambda_u2d0.getY()).raw(this.getPrefix$core() + 'z', (int)$this$parseEdits_u24lambda_u2d0.getZ()).raw(this.getPrefix$core() + "yaw", (int)$this$parseEdits_u24lambda_u2d0.getYaw()).raw(this.getPrefix$core() + "pitch", (int)$this$parseEdits_u24lambda_u2d0.getPitch());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0006H\u0010\u00a2\u0006\u0002\b\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/kingdoms/locale/LocationLocale$SimpleChunkLocationLocale;", "Lorg/kingdoms/locale/LocationLocale;", "location", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "(Lorg/kingdoms/constants/land/location/SimpleChunkLocation;)V", "parseEdits", "", "parseEdits$core", "core"})
    public static final class SimpleChunkLocationLocale
    extends LocationLocale {
        @NotNull
        private final SimpleChunkLocation location;

        public SimpleChunkLocationLocale(@NotNull SimpleChunkLocation location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            this.location = location;
        }

        @Override
        public void parseEdits$core() {
            SimpleChunkLocation simpleChunkLocation;
            SimpleChunkLocation $this$parseEdits_u24lambda_u2d0 = simpleChunkLocation = this.location;
            boolean bl = false;
            this.getMessageBuilder$core().raw(this.getPrefix$core() + "translated-world", LocationUtils.translateWorld($this$parseEdits_u24lambda_u2d0.getWorld())).raw(this.getPrefix$core() + "world", $this$parseEdits_u24lambda_u2d0.getWorld()).raw(this.getPrefix$core() + 'x', $this$parseEdits_u24lambda_u2d0.getX()).raw(this.getPrefix$core() + 'z', $this$parseEdits_u24lambda_u2d0.getZ());
        }
    }
}

