/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.compiler.builders.context;

import java.util.ArrayList;
import java.util.List;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessagePiece;
import org.kingdoms.locale.compiler.builders.context.MessageBuilderContextProvider;
import org.kingdoms.locale.provider.MessageBuilder;

public final class PlainMessageBuilderContextProvider
extends MessageBuilderContextProvider {
    private final List<StringBuilder> builders = new ArrayList<StringBuilder>(3);
    private StringBuilder currentBuilder = new StringBuilder(10);

    public PlainMessageBuilderContextProvider(MessageBuilder settings, MessageCompilerSettings compilerSettings) {
        super(compilerSettings, settings);
    }

    public StringBuilder getBuilder() {
        return this.currentBuilder;
    }

    public void newBuilder() {
        this.currentBuilder = new StringBuilder();
    }

    public String merge() {
        this.builders.add(this.currentBuilder);
        StringBuilder first = this.builders.get(0);
        for (StringBuilder builder : this.builders) {
            if (first == builder) continue;
            first.append('\n').append((CharSequence)builder);
        }
        return first.toString();
    }

    public List<StringBuilder> getBuilders() {
        return this.builders;
    }

    @Override
    public void build(MessagePiece messagePiece) {
        messagePiece.build(this);
    }
}

