/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale.provider;

import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.messages.ActionBar;
import org.kingdoms.libs.xseries.messages.Titles;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.ConfigSection;

public final class AdvancedMessageProvider
extends MessageProvider {
    private final MessageObject actionbar;
    private final Titles titles;
    private XSound.Record sound;

    public AdvancedMessageProvider(MessageObject obj, MessageObject actionbar, Titles titles) {
        super(obj);
        this.actionbar = actionbar;
        this.titles = titles;
    }

    public AdvancedMessageProvider(ConfigSection accessor) {
        super(AdvancedMessageProvider.compileMain(accessor));
        String actionbar = accessor.getString("actionbar");
        this.actionbar = actionbar == null ? null : MessageCompiler.compile(actionbar);
        String sound = accessor.getString("sound");
        this.sound = sound == null ? null : XSound.parse(sound);
        ConfigSection titleSection = accessor.getSection("titles");
        this.titles = titleSection != null ? Titles.parseTitle(titleSection.toBukkitConfigurationSection()) : null;
    }

    static MessageObject compileMain(ConfigSection accessor) {
        Objects.requireNonNull(accessor, "Config accessor is null");
        String msg = accessor.getString("message");
        return msg == null ? null : MessageCompiler.compile(msg);
    }

    public AdvancedMessageProvider withSound(XSound.Record sound) {
        this.sound = sound;
        return this;
    }

    public AdvancedMessageProvider err() {
        this.sound = XSound.parse(KingdomsConfig.ERROR_SOUND.getString());
        return this;
    }

    @Override
    public void handleExtraServices(CommandSender receiver, MessageBuilder builder) {
        if (receiver instanceof Player) {
            Player player = (Player)receiver;
            if (this.sound != null) {
                this.sound.forPlayer(player).play();
            }
            if (this.actionbar != null) {
                ActionBar.sendActionBar((Plugin)Kingdoms.get(), player, this.actionbar.buildPlain(builder));
            }
            if (this.titles != null) {
                Titles titles = this.titles.clone();
                if (titles.getTitle() != null) {
                    titles.setTitle(MessageCompiler.compile(titles.getTitle()).buildPlain(builder));
                }
                if (titles.getSubtitle() != null) {
                    titles.setSubtitle(MessageCompiler.compile(titles.getSubtitle()).buildPlain(builder));
                }
                titles.send(player);
            }
        }
    }
}

