/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers;

import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.managers.ChairSession;
import org.kingdoms.utils.internal.integer.IntHashMap;
import org.spigotmc.event.entity.EntityDismountEvent;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Lorg/kingdoms/managers/ChairManager;", "Lorg/bukkit/event/Listener;", "()V", "onCannonStandUp", "", "event", "Lorg/spigotmc/event/entity/EntityDismountEvent;", "onLeave", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onTeleport", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "Companion", "core"})
public final class ChairManager
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IntHashMap<ChairSession<Object>> HANDLERS = new IntHashMap();

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onCannonStandUp(@NotNull EntityDismountEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"event.entity");
        Companion.standUp(entity);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onTeleport(@NotNull PlayerTeleportEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        Companion.standUp((Entity)player);
    }

    @EventHandler
    public final void onLeave(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"event.player");
        Companion.standUp((Entity)player);
    }

    @JvmStatic
    public static final void sit(@NotNull Entity player, @NotNull ChairSession<Object> obj) {
        Companion.sit(player, obj);
    }

    @JvmStatic
    public static final void removeAll() {
        Companion.removeAll();
    }

    @JvmStatic
    @Nullable
    public static final ChairSession<Object> standUp(@NotNull Entity player) {
        return Companion.standUp(player);
    }

    @JvmStatic
    @Nullable
    public static final ChairSession<Object> getHandler(@NotNull Entity entity) {
        return Companion.getHandler(entity);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u0005\"\u0006\b\u0000\u0010\b\u0018\u00012\u0006\u0010\t\u001a\u00020\nH\u0086\nJ\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0007J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\nH\u0007R\"\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/managers/ChairManager$Companion;", "", "()V", "HANDLERS", "Lorg/kingdoms/utils/internal/integer/IntHashMap;", "Lorg/kingdoms/managers/ChairSession;", "getHANDLERS$annotations", "get", "T", "entity", "Lorg/bukkit/entity/Entity;", "getHandler", "removeAll", "", "sit", "player", "obj", "standUp", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getHANDLERS$annotations() {
        }

        @JvmStatic
        public final void sit(@NotNull Entity player, @NotNull ChairSession<Object> obj) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(obj, (String)"obj");
            HANDLERS.put(player.getEntityId(), obj);
        }

        @JvmStatic
        public final void removeAll() {
            Intrinsics.checkNotNullExpressionValue((Object)HANDLERS.values, (String)"HANDLERS.values");
            for (Object handler : HANDLERS.values) {
                if (handler == null) continue;
                ChairSession session = (ChairSession)handler;
                Runnable runnable = session.getOnDismount();
                if (runnable != null) {
                    runnable.run();
                }
                session.getChair().remove();
            }
        }

        @JvmStatic
        @Nullable
        public final ChairSession<Object> standUp(@NotNull Entity player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            ChairSession chairSession = (ChairSession)HANDLERS.remove(player.getEntityId());
            if (chairSession == null) {
                return null;
            }
            ChairSession session = chairSession;
            Runnable runnable = session.getOnDismount();
            if (runnable != null) {
                runnable.run();
            }
            session.getChair().remove();
            return session;
        }

        @JvmStatic
        @Nullable
        public final ChairSession<Object> getHandler(@NotNull Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return (ChairSession)HANDLERS.get(entity.getEntityId());
        }

        public final /* synthetic */ <T> ChairSession<T> get(Entity entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            boolean $i$f$get = false;
            ChairSession<Object> chairSession = this.getHandler(entity);
            if (chairSession == null) {
                return null;
            }
            ChairSession<Object> session = chairSession;
            Object object = session.getSession();
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            return object instanceof Object ? session : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

