/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.chat;

import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageTokenHandler;
import org.kingdoms.locale.compiler.MessageTokenResult;
import org.kingdoms.managers.chat.TagMessagePiece;

public final class ChatTagManager
extends MessageTokenHandler {
    public static final ChatTagManager INSTANCE = new ChatTagManager();

    private ChatTagManager() {
    }

    public static String getPrefix() {
        return KingdomsConfig.Chat.TAGGING_PREFIX.getManager().getString();
    }

    @Override
    public MessageTokenResult consumeUntil(MessageCompiler compiler) {
        char ch;
        int i;
        String tagPrefix = ChatTagManager.getPrefix();
        if (tagPrefix.length() + compiler.getIndex() + 1 > compiler.getChars().length) {
            return null;
        }
        String portion = new String(compiler.getChars(), compiler.getIndex(), tagPrefix.length());
        if (!tagPrefix.equals(portion)) {
            return null;
        }
        StringBuilder name = new StringBuilder(16);
        char[] chars = compiler.getChars();
        for (i = compiler.getIndex() + 1; i < chars.length && ((ch = chars[i]) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch >= '0' && ch <= '9'); ++i) {
            name.append(ch);
        }
        if (name.length() < 3) {
            return null;
        }
        if (name.length() > 16) {
            return null;
        }
        return new MessageTokenResult(i - 1, new TagMessagePiece(name.toString()));
    }
}

