/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.daily;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.abstraction.ProlongedTask;
import org.kingdoms.managers.daily.TimeZoneHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.time.TimeUtils;

public final class ElectionsManager
extends ProlongedTask {
    private static final ElectionsManager INSTANCE = new ElectionsManager();
    private static BukkitTask concludeTask;
    public static final Map<UUID, CandidateDetails> CANDIDATE_DETAILS;
    public static final Map<UUID, UUID> VOTES;

    public static ElectionsManager getInstance() {
        return INSTANCE;
    }

    public static CandidateDetails getCandidate(UUID id) {
        return CANDIDATE_DETAILS.computeIfAbsent(id, k -> new CandidateDetails(null, 0));
    }

    public static OfflinePlayer vote(Player voter, UUID candidate) {
        UUID previous = VOTES.put(voter.getUniqueId(), candidate);
        ++ElectionsManager.getCandidate((UUID)candidate).votes;
        --ElectionsManager.getCandidate((UUID)previous).votes;
        return previous == null ? null : Bukkit.getOfflinePlayer((UUID)previous);
    }

    public static boolean isAcceptingVotes() {
        return concludeTask != null;
    }

    private ElectionsManager() {
        super(Duration.ofDays(KingdomsConfig.DAILY_CHECKS_ELECTIONS_INTERVAL.getInt()), TimeZoneHandler.DAILY_CHECKS, "daily checks", new String[]{"prolonged-tasks", "elections"}, null);
    }

    @Override
    public void remind(String formattedTime) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void run() {
        KingdomsLang.ELECTIONS_BEGIN.sendEveryoneMessage(new Object[0]);
        concludeTask = new BukkitRunnable(){

            public void run() {
                ElectionsManager.this.conclude();
                concludeTask = null;
            }
        }.runTaskLaterAsynchronously((Plugin)Kingdoms.get(), TimeUtils.millisToTicks(KingdomsConfig.DAILY_CHECKS_ELECTIONS_DURATION.getTimeMillis(TimeUnit.HOURS)));
    }

    public void conclude() {
        HashMap<UUID, KingdomElectionResult> topVotes = new HashMap<UUID, KingdomElectionResult>();
        for (Map.Entry<UUID, CandidateDetails> entry : CANDIDATE_DETAILS.entrySet()) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(entry.getKey());
            if (!kp.hasKingdom()) continue;
            KingdomElectionResult detail = (KingdomElectionResult)topVotes.get(kp.getKingdomId());
            if (detail == null) {
                topVotes.put(kp.getKingdomId(), new KingdomElectionResult(entry.getValue(), entry.getKey()));
                continue;
            }
            if (entry.getValue().votes > detail.details.votes) {
                detail.change(entry);
            }
            detail.plusVotes();
        }
        for (Map.Entry<UUID, CandidateDetails> entry : topVotes.entrySet()) {
            OfflinePlayer chosenCandidate = Bukkit.getOfflinePlayer((UUID)((KingdomElectionResult)((Object)entry.getValue())).candidate);
            CandidateDetails candidateDetails = ((KingdomElectionResult)((Object)entry.getValue())).details;
            Kingdom kingdom = Kingdom.getKingdom(entry.getKey());
            double votePercentage = KingdomsConfig.DAILY_CHECKS_ELECTIONS_VOTE_PERCENTAGE.getDouble();
            double percent = MathUtils.getPercent(((KingdomElectionResult)((Object)entry.getValue())).totalVotes, kingdom.getMembers().size());
            KingdomsLang lang = percent < votePercentage ? KingdomsLang.ELECTIONS_RESULTS : KingdomsLang.ELECTIONS_NOT_ENOUGH_DATA;
            if (kingdom.setKing(KingdomPlayer.getKingdomPlayer(chosenCandidate), KingdomKingChangeEvent.Reason.ELECTIONS).isCancelled()) {
                return;
            }
            for (Player member : kingdom.getOnlineMembers()) {
                lang.sendMessage((CommandSender)member, "candidate", chosenCandidate.getName(), "votes", candidateDetails.votes, "statement", candidateDetails.statement);
            }
        }
    }

    static {
        CANDIDATE_DETAILS = new NonNullMap<UUID, CandidateDetails>();
        VOTES = new NonNullMap<UUID, UUID>();
    }

    public static final class CandidateDetails {
        public String statement;
        public int votes;

        public CandidateDetails(String statement, int votes) {
            this.statement = statement;
            this.votes = votes;
        }
    }

    private static final class KingdomElectionResult {
        public CandidateDetails details;
        public UUID candidate;
        public int totalVotes;

        private KingdomElectionResult(CandidateDetails details, UUID candidate) {
            this.details = details;
            this.candidate = candidate;
        }

        public void plusVotes() {
            ++this.totalVotes;
        }

        public void change(Map.Entry<UUID, CandidateDetails> candidate) {
            this.candidate = candidate.getKey();
            this.details = candidate.getValue();
        }
    }
}

