/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.land.claiming.AbstractClaimProcessor;
import org.kingdoms.managers.land.claiming.ClaimClipboard;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.Compass;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.NationZone;
import org.kingdoms.utils.XScoreboard;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.string.StringUtils;

public class KingdomsMap {
    public static final Map<UUID, XScoreboard> SCOREBOARDS = NonNullMap.of(new ConcurrentHashMap());
    private Player player;
    private KingdomPlayer kp;
    private Kingdom kpKingdom;
    private int height;
    private int width;
    private boolean clipboardMode;
    private ClaimClipboard clipboard;
    private final String beginMain = KingdomsConfig.Map.BEGIN.getManager().getString();
    private final String distanceMain = KingdomsConfig.Map.DISTANCE.getManager().getString();
    private SimpleChunkLocation center;
    protected SimpleChunkLocation chunk;
    protected Structure structure;
    protected Land land;
    protected Kingdom kingdom;
    private boolean showHidden;
    private final MessageBuilder settings = new MessageBuilder();
    private String failReason = "&cNone";

    public KingdomsMap setSize(int height, int width) {
        this.height = height;
        this.width = width;
        return this;
    }

    public KingdomsMap clipboardMode() {
        this.clipboardMode = true;
        this.clipboard = ClaimClipboard.getClipboards().get(this.player.getUniqueId());
        this.clipboardMode = this.clipboard != null;
        return this;
    }

    public KingdomsMap forPlayer(Player player) {
        this.player = Objects.requireNonNull(player, "Cannot show map to null player");
        this.kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        this.kpKingdom = this.kp.getKingdom();
        this.center = SimpleChunkLocation.of(player.getLocation());
        this.showHidden = KingdomsPluginPermission.SHOW_HIDDEN_GROUPS.hasPermission((CommandSender)player);
        this.settings.withContext(player);
        return this;
    }

    void currentChunk(SimpleChunkLocation chunk) {
        this.chunk = chunk;
        this.land = chunk.getLand();
        this.kingdom = this.land == null || !this.land.isClaimed() ? null : this.land.getKingdom();
    }

    String getCurrentChunkOptionName() {
        this.structure = null;
        if (this.chunk.equalsIgnoreWorld(this.center)) {
            return "you";
        }
        if (ServiceHandler.isInRegion(this.chunk)) {
            return "protected";
        }
        if (this.kingdom == null || !this.showHidden && this.kingdom.isHidden() && !this.kingdom.isMember(this.kp)) {
            NationZone nationZone = Land.getNationZone(this.chunk);
            if (!(nationZone == null || this.showHidden && nationZone.getNation().isHidden() && nationZone.getNation().isMember(this.kp))) {
                KingdomRelation relation = this.kpKingdom == null ? KingdomRelation.NEUTRAL : nationZone.getKingdom().getRelationWith(this.kpKingdom);
                return "nation-zone." + relation.name().toLowerCase(Locale.ENGLISH);
            }
            if (this.clipboardMode) {
                AbstractClaimProcessor result = this.clipboard.getClaims().get(this.chunk.worldlessWrapper());
                if (result != null) {
                    if (!result.isSuccessful()) {
                        this.failReason = result.getIssue().getProvider(this.kp.getLanguage()).getMessage().buildPlain(result.getContextHolder());
                    }
                    return "clipboard." + (result.isSuccessful() ? "added" : "failed");
                }
                return "clipboard.wilderness";
            }
            return "wilderness";
        }
        if (this.land.isBeingInvaded()) {
            return "invasion";
        }
        String property = null;
        if (this.land.getStructures().isEmpty()) {
            property = "land";
        } else {
            int lastPriority = Integer.MAX_VALUE;
            for (Structure struct : this.land.getStructures().values()) {
                StructureType type = (StructureType)((StructureStyle)struct.getStyle()).getType();
                String tempProp = type.getName().toLowerCase(Locale.ENGLISH);
                ConfigSection section = KingdomsConfig.MAP.getConfig().getSection("elements", tempProp);
                int priority = section.getInt("priority");
                if (priority < lastPriority) {
                    property = tempProp;
                    this.structure = struct;
                    lastPriority = priority;
                }
                if (priority != 1) continue;
                break;
            }
            Objects.requireNonNull(property);
        }
        KingdomRelation relation = this.kpKingdom == null ? KingdomRelation.NEUTRAL : this.kingdom.getRelationWith(this.kpKingdom);
        return property + '.' + relation.name().toLowerCase(Locale.ENGLISH);
    }

    public void displayAsync() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), this::display);
    }

    public void display() {
        this.displayHeader();
        this.process();
        this.displayFooter();
    }

    public static boolean isUsingScoreboard(Player player) {
        return SCOREBOARDS.containsKey(player.getUniqueId());
    }

    public void displayAsScoreboard() {
        XScoreboard scoreboard = SCOREBOARDS.get(this.player.getUniqueId());
        if (scoreboard == null) {
            scoreboard = new XScoreboard("lands", MessageCompiler.compile(KingdomsConfig.Map.HEADER.getManager().getString()), this.settings);
            scoreboard.setAlignRight(this.beginMain);
        } else {
            scoreboard.clearLines();
        }
        this.settings.raw("compass", Compass.translateCardinalDirection(this.player));
        int height = Math.min(this.height, 7);
        for (int y = -height; y <= height; ++y) {
            StringBuilder row = new StringBuilder();
            for (int x = -this.width; x <= this.width; ++x) {
                this.currentChunk(this.center.getRelative(x, y));
                String property = this.getCurrentChunkOptionName();
                ConfigSection section = KingdomsConfig.MAP.getConfig().getSection(ConfigPath.buildRaw("elements." + property));
                if (section == null) {
                    throw new IllegalStateException("Cannot find map section for property: " + property);
                }
                this.settings.raw("reason", this.failReason).raw("X", this.chunk.getX()).raw("Z", this.chunk.getZ()).other(this.kingdom);
                String icon = section.getString("icon");
                if (icon == null) {
                    throw new IllegalStateException("Cannot find map icon section for property: " + property);
                }
                row.append(icon);
            }
            scoreboard.addLine(MessageCompiler.compile(row.toString()));
        }
        scoreboard.buildLines(this.settings);
        scoreboard.setForPlayer(this.player);
        SCOREBOARDS.put(this.player.getUniqueId(), scoreboard);
    }

    public void displayAsGUI() {
        InteractiveGUI gui = GUIAccessor.prepare(this.player, KingdomsGUI.MAP);
        ReusableOptionHandler elementOption = gui.getReusableOption("element");
        this.settings.raw("compass", Compass.translateCardinalDirection(this.player));
        block0: for (int y = -3; y <= 2; ++y) {
            for (int x = -4; x <= 4; ++x) {
                this.currentChunk(this.center.getRelative(x, y));
                String property = this.getCurrentChunkOptionName();
                ConfigSection section = KingdomsConfig.MAP.getConfig().getSection(ConfigPath.buildRaw("elements." + property));
                if (section == null) {
                    throw new IllegalStateException("Cannot find map section for property: " + property);
                }
                this.settings.raw("reason", this.failReason).raw("X", this.chunk.getX()).raw("Z", this.chunk.getZ()).other(this.kingdom);
                List<String> hovers = section.getStringList("hover");
                String icon = section.getString("icon");
                if (icon == null) {
                    throw new IllegalStateException("Cannot find map icon section for property: " + property);
                }
                elementOption.editItem(item -> {
                    ConfigSection itemSection = section.getSection("item");
                    if (itemSection != null) {
                        item = XItemStack.edit(item, itemSection.toBukkitConfigurationSection(), Function.identity(), null);
                    }
                    if (this.structure != null) {
                        item.setType(this.structure.getBlock().getType());
                    }
                    ItemMeta meta = item.getItemMeta();
                    meta.setDisplayName(icon + ' ' + (hovers.isEmpty() ? "" : (String)hovers.get(0)));
                    meta.setLore(hovers.stream().skip(1L).collect(Collectors.toList()));
                    ItemUtil.translate(meta, this.settings);
                    item.setItemMeta(meta);
                    return item;
                });
                String action = section.getString("action");
                if (!(Strings.isNullOrEmpty((String)action) || action.startsWith("url:") || action.startsWith("|"))) {
                    String cmd = MessageCompiler.compile(action).buildPlain(this.settings);
                    elementOption.onNormalClicks(() -> {
                        StringUtils.performCommands((OfflinePlayer)this.player, Collections.singletonList(cmd));
                        this.displayAsGUI();
                    });
                }
                elementOption.done();
                if (!elementOption.hasNext()) break block0;
            }
        }
        gui.open();
    }

    void displayHeader() {
        MessageCompiler.compile(KingdomsConfig.Map.HEADER.getManager().getString()).getSimpleProvider().send((CommandSender)this.player, this.settings);
    }

    void displayFooter() {
        MessageCompiler.compile(KingdomsConfig.Map.FOOTER.getManager().getString()).getSimpleProvider().send((CommandSender)this.player, this.settings);
    }

    public void process() {
        ArrayList<TextComponent> rows = new ArrayList<TextComponent>();
        for (int y = -this.height; y <= this.height; ++y) {
            TextComponent rowComponent = new TextComponent();
            rowComponent.addExtra(this.beginMain);
            boolean first = true;
            for (int x = -this.width; x <= this.width; ++x) {
                String icon;
                String action;
                this.currentChunk(this.center.getRelative(x, y));
                String property = this.getCurrentChunkOptionName();
                ConfigSection section = KingdomsConfig.MAP.getConfig().getSection(ConfigPath.buildRaw("elements." + property));
                if (section == null) {
                    throw new IllegalStateException("Cannot find map section for property: " + property);
                }
                this.settings.raw("compass", Compass.translateCardinalDirection(this.player)).raw("reason", this.failReason).raw("X", this.chunk.getX()).raw("Z", this.chunk.getZ()).other(this.kingdom);
                TextComponent element = new TextComponent();
                TextComponent hover = new TextComponent();
                List<String> hovers = section.getStringList("hover");
                if (!hovers.isEmpty()) {
                    int i = 1;
                    for (String hoverMsg : hovers) {
                        hoverMsg = MessageCompiler.compile(hoverMsg).buildPlain(this.settings);
                        if (i++ != hovers.size()) {
                            hoverMsg = hoverMsg + '\n';
                        }
                        hover.addExtra(hoverMsg);
                    }
                    HoverEvent hoverEvent = MessageCompiler.constructHoverEvent((BaseComponent[])new TextComponent[]{hover});
                    element.setHoverEvent(hoverEvent);
                }
                if (!Strings.isNullOrEmpty((String)(action = section.getString("action")))) {
                    ClickEvent.Action eventAction = ClickEvent.Action.RUN_COMMAND;
                    if (action.startsWith("url:")) {
                        eventAction = ClickEvent.Action.OPEN_FILE;
                        action = action.substring(4);
                    } else if (action.startsWith("|")) {
                        eventAction = ClickEvent.Action.SUGGEST_COMMAND;
                        action = action.substring(1);
                    }
                    action = MessageCompiler.compile(action).buildPlain(this.settings);
                    ClickEvent clickEvent = new ClickEvent(eventAction, action);
                    element.setClickEvent(clickEvent);
                }
                if ((icon = section.getString("icon")) == null) {
                    throw new IllegalStateException("Cannot find map icon section for property: " + property);
                }
                icon = MessageCompiler.compile(icon).buildPlain(this.settings);
                String distance = first ? "" : MessageCompiler.compile(this.distanceMain).buildPlain(this.settings);
                element.addExtra(distance + icon);
                rowComponent.addExtra((BaseComponent)element);
                if (y == 0 && x == this.width) {
                    String comp = MessageCompiler.compile(KingdomsConfig.Map.COMPASS.getManager().getString()).buildPlain(this.settings);
                    rowComponent.addExtra(comp);
                }
                first = false;
            }
            rows.add(rowComponent);
        }
        rows.forEach(component -> this.player.spigot().sendMessage((BaseComponent)component));
    }
}

