/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.FlyManager;
import org.kingdoms.managers.land.KingdomsMap;
import org.kingdoms.managers.land.claiming.AutoClaimManager;
import org.kingdoms.managers.land.indicator.LandVisualizer;
import org.kingdoms.managers.land.protection.KingdomGuardManager;
import org.kingdoms.managers.land.protection.MiscUpgradeManager;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

public final class LandChangeWatcher
implements Listener {
    private static void preparedLandIndicator(Player player, KingdomPlayer kp, Kingdom playersKingdom, LandChangeEvent event) {
        if (playersKingdom == null && !KingdomsConfig.Claims.INDICATOR_KINGDOMLESS_ENABLED.getManager().getBoolean()) {
            return;
        }
        if (KingdomsConfig.Claims.INDICATOR_IGNORE_WORLDGUARD_REGIONS.getManager().getBoolean() && ServiceHandler.isInRegion(event.getToChunk())) {
            return;
        }
        Kingdom fromLandKingdom = event.getFromLand() == null ? null : event.getFromLand().getKingdom();
        Kingdom toLandKingdom = event.getToLand() == null ? null : event.getToLand().getKingdom();
        String fromLandRelation = LandVisualizer.getRelationOf(event.getFromChunk(), fromLandKingdom, playersKingdom);
        String toLandRelation = LandVisualizer.getRelationOf(event.getToChunk(), toLandKingdom, playersKingdom);
        LandVisualizer visualizer = new LandVisualizer().forPlayer(player, kp).forLand(event.getToLand(), event.getToChunk().toChunk());
        if (kp.isUsingMarkers()) {
            visualizer.displayIndicators();
        }
        if (Objects.equals(fromLandKingdom, toLandKingdom) && !KingdomsConfig.Claims.INDICATOR_SEND_MESSAGES_FOR_SAME_LAND_TYPE.getManager().withOption("relation", toLandRelation).getBoolean() && fromLandRelation.equals(toLandRelation)) {
            return;
        }
        KLogger.debug((DebugNS)KingdomsDebug.LAND$VISUALIZERS, () -> fromLandRelation + " -> " + toLandRelation);
        visualizer.displayMessages();
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onLandChange(LandChangeEvent event) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            Player player = event.getPlayer();
            if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player, null)) {
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            MiscUpgradeManager.onEnemyEnterAlert(event);
            KingdomGuardManager.onGuardSpawn(event);
            AutoClaimManager.autoUnclaim(event, kingdom, kp);
            AutoClaimManager.autoClaim(event, kingdom, kp);
            if (kp.isAutoMap()) {
                kp.buildMap().display();
            }
            if (KingdomsMap.isUsingScoreboard(player)) {
                KingdomsMap map = kp.buildMap();
                Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), map::displayAsScoreboard);
            }
            LandChangeWatcher.preparedLandIndicator(player, kp, kingdom, event);
            if (KingdomsConfig.KINGDOM_FLY_ENABLED.getBoolean()) {
                FlyManager.onFlyLandChange(event);
            }
        });
    }
}

