/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land;

import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.plugin.Plugin;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.ranks.RankDeleteEvent;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.lands.LandChangeEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XTag;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.protectionsign.ProtectionSignManager;
import org.kingdoms.managers.structures.StructureManager;
import org.kingdoms.managers.turrets.TurretManager;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.NationZone;
import org.kingdoms.utils.nbt.ItemNBT;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;
import org.kingdoms.utils.string.StringUtils;
import org.spigotmc.event.entity.EntityMountEvent;

public final class LandProtectionManager
implements Listener {
    public LandProtectionManager() {
        if (XMaterial.supports(16)) {
            Bukkit.getPluginManager().registerEvents((Listener)new BerryBushHandler(), (Plugin)Kingdoms.get());
        }
    }

    public static void openKingdomItemGUI(Player player, KingdomItem<?> item, KingdomItemInteractEvent<?> event) {
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.UNCLAIMED$KINGDOM$ITEM.getGUIPath(), new MessageBuilder().raw("kingdom-item-name", ((KingdomItemStyle)item.getStyle()).getDisplayName()));
        if (gui != null) {
            KingdomItemGUIContext.addBreakButton(event, gui);
            KingdomItemGUIContext.putGUI(event);
            gui.open();
        }
    }

    private static boolean hasBuildPerms(Land land, KingdomPlayer kp, Player player) {
        StandardKingdomPermission permission;
        StandardKingdomPermission standardKingdomPermission = permission = land.isNexusLand() ? StandardKingdomPermission.NEXUS_BUILD : StandardKingdomPermission.BUILD;
        if (kp.hasPermission(permission)) {
            return true;
        }
        if (kp.hasPermission(StandardKingdomPermission.BUILD_OWNED)) {
            if (land.getClaimedBy().equals(kp.getId())) {
                return true;
            }
            KingdomsLang.LANDS_BUILD_OWN_ONLY.sendError((CommandSender)player, new Object[0]);
            return false;
        }
        permission.sendDeniedMessage(player);
        return false;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onRankDelete(RankDeleteEvent event) {
        Group group = event.getGroup();
        if (group instanceof Kingdom) {
            Kingdom kingdom = (Kingdom)group;
            String node = event.getRank().getNode();
            for (KingdomPlayer member : kingdom.getKingdomPlayers()) {
                if (!member.getRankNode().equals(node)) continue;
                member.setRankInternal(null);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityBlockChange(EntityChangeBlockEvent event) {
        Player player;
        KingdomPlayer kp;
        Kingdom playerKingdom;
        switch (event.getEntityType()) {
            case WITHER: 
            case FALLING_BLOCK: 
            case VILLAGER: {
                return;
            }
        }
        Land land = Land.getLand(event.getBlock());
        if (land == null) {
            return;
        }
        Kingdom landKingdom = land.getKingdom();
        if (landKingdom == null) {
            return;
        }
        if (event.getEntity() instanceof Player && landKingdom.hasAttribute(playerKingdom = (kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)(player = (Player)event.getEntity()))).getKingdom(), (RelationAttribute)StandardRelationAttribute.BUILD)) {
            return;
        }
        if (landKingdom.getUpgradeLevel(MiscUpgrade.ANTI_TRAMPLE) > 1) {
            event.setCancelled(true);
        }
    }

    public static boolean buildInClaimedOnly(Player player, KingdomPlayer kp, SimpleChunkLocation chunk, boolean placing) {
        boolean isInRange;
        KingdomsConfig.Claims enabledOption;
        KingdomsConfig.Claims claims = enabledOption = placing ? KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_PLACE : KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_BREAK;
        if (!enabledOption.getManager().getBoolean()) {
            return false;
        }
        boolean charges = KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_ENABLED.getManager().getBoolean();
        int unclaimedBuildRadius = KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_UNCLAIMED_BUILD_RADIUS.getManager().getInt();
        if (!charges && unclaimedBuildRadius <= 0) {
            (placing ? KingdomsLang.IN_CLAIM_ONLY_PLACING_GENERAL : KingdomsLang.IN_CLAIM_ONLY_BREAKING_GENERAL).sendError((CommandSender)player, new Object[0]);
            return true;
        }
        Kingdom kingdom = kp.getKingdom();
        if (unclaimedBuildRadius <= 0) {
            isInRange = false;
        } else {
            if (kingdom == null) {
                (placing ? KingdomsLang.IN_CLAIM_ONLY_PLACING_GENERAL : KingdomsLang.IN_CLAIM_ONLY_BREAKING_GENERAL).sendError((CommandSender)player, new Object[0]);
                return true;
            }
            isInRange = chunk.findFromSurroundingChunks(unclaimedBuildRadius, false, currentChunk -> kingdom.isClaimed((SimpleChunkLocation)currentChunk) ? Boolean.valueOf(true) : null);
        }
        if (!charges) {
            if (!isInRange) {
                (placing ? KingdomsLang.IN_CLAIM_ONLY_PLACING_RADIUS : KingdomsLang.IN_CLAIM_ONLY_BREAKING_RADIUS).sendError((CommandSender)player, "radius", unclaimedBuildRadius);
                return true;
            }
            return false;
        }
        boolean inRange = KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_IN_RANGE.getManager().getBoolean();
        if (inRange == isInRange) {
            return LandProtectionManager.chargeBuilding(player, kingdom, placing);
        }
        if (isInRange) {
            return false;
        }
        (placing ? KingdomsLang.IN_CLAIM_ONLY_PLACING_RADIUS : KingdomsLang.IN_CLAIM_ONLY_BREAKING_RADIUS).sendError((CommandSender)player, "radius", unclaimedBuildRadius);
        return true;
    }

    public static boolean chargeBuilding(Player player, Kingdom kingdom, boolean placing) {
        KingdomsConfig.Claims rpOpt = placing ? KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_PLACING_RESOURCE_POINTS : KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_BREAKING_RESOURCE_POINTS;
        KingdomsConfig.Claims moneyOpt = placing ? KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_PLACING_MONEY : KingdomsConfig.Claims.BUILD_IN_CLAIMED_ONLY_CHARGES_BREAKING_MONEY;
        long rp = rpOpt.getManager().getLong();
        double money = moneyOpt.getManager().getDouble();
        Runnable notifier = () -> (placing ? KingdomsLang.IN_CLAIM_ONLY_PLACING_CHARGES : KingdomsLang.IN_CLAIM_ONLY_BREAKING_CHARGES).sendError((CommandSender)player, "money", StringUtils.toFancyNumber(rp), "rp", StringUtils.toFancyNumber(rp));
        if (rp > 0L && kingdom == null) {
            notifier.run();
            return true;
        }
        if (rp != 0L && kingdom != null && !kingdom.hasResourcePoints(rp)) {
            notifier.run();
            return true;
        }
        if (money != 0.0 && ServiceHandler.bankServiceAvailable() && !ServiceVault.hasMoney((OfflinePlayer)player, money)) {
            notifier.run();
            return true;
        }
        if (rp != 0L) {
            kingdom.addResourcePoints(-rp);
        }
        if (money != 0.0 && ServiceHandler.bankServiceAvailable()) {
            ServiceVault.withdraw((OfflinePlayer)player, money);
        }
        return false;
    }

    private static boolean handleBuilding(Player player, KingdomPlayer kp, SimpleChunkLocation chunk, boolean placing) {
        Boolean attr;
        if (kp.isAdmin()) {
            return false;
        }
        if ((placing ? KingdomsPluginPermission.LAND_BUILD_PLACE : KingdomsPluginPermission.LAND_BUILD_BREAK).hasPermission((CommandSender)player)) {
            return false;
        }
        if (KingdomsConfig.Invasions.ALLOW_BUILDING.getManager().getBoolean() && kp.isInvading() && kp.getInvasion().isAffected(chunk)) {
            return false;
        }
        Land land = chunk.getLand();
        if (land == null || !land.isClaimed()) {
            if (LandProtectionManager.buildInClaimedOnly(player, kp, chunk, placing)) {
                return true;
            }
            Nation nationZone = LandProtectionManager.disallowedNationZone(kp, chunk);
            if (nationZone != null) {
                (placing ? KingdomsLang.LANDS_NATION_ZONE_PLACE : KingdomsLang.LANDS_NATION_ZONE_BREAK).sendError((CommandSender)player, "nation", nationZone.getName());
                return true;
            }
            return false;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && (attr = regulator.hasAttribute((OfflinePlayer)player, Regulator.Attribute.BUILD)) != null) {
            return attr;
        }
        Kingdom kingdom = kp.getKingdom();
        if (kingdom != null && !LandProtectionManager.hasBuildPerms(land, kp, player)) {
            return true;
        }
        if (!StandardRelationAttribute.BUILD.hasAttribute(kingdom, land.getKingdom())) {
            (placing ? KingdomsLang.OTHER_KINGDOMS_PLACE : KingdomsLang.OTHER_KINGDOMS_BREAK).sendError((CommandSender)player, new Object[0]);
            return true;
        }
        return false;
    }

    public static boolean onEntityBreak(EntityDamageByEntityEvent event, Player player) {
        boolean innocent;
        Entity entity = event.getEntity();
        boolean bl = innocent = entity instanceof Animals || entity instanceof NPC || entity instanceof WaterMob;
        if (!innocent && !LandProtectionManager.shouldCheckEntityInteraction(event.getEntityType())) {
            return false;
        }
        Land land = Land.getLand(entity.getLocation());
        if (land == null) {
            return false;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return false;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return false;
        }
        if (!innocent) {
            if (LandProtectionManager.handleBuilding(player, kp, SimpleChunkLocation.of(entity.getLocation()), false)) {
                event.setCancelled(true);
                return true;
            }
            return false;
        }
        if (kingdom.getMiscUpgrades().getOrDefault(MiscUpgrade.ANTI_TRAMPLE, 0) >= 3 && !MiscUpgrade.ANTI_TRAMPLE.getConfig().getStringList("blacklisted-animals").contains(entity.getType().name()) && !StandardRelationAttribute.CEASEFIRE.hasAttribute(kp.getKingdom(), kingdom)) {
            KingdomsLang.OTHER_KINGDOMS_KILL.sendError((CommandSender)player, "entity", entity.getName());
            if (event.getDamager() instanceof Projectile) {
                event.getDamager().remove();
            }
            event.setCancelled(true);
            return true;
        }
        return false;
    }

    public static boolean shouldCheckEntityInteraction(EntityType type) {
        switch (type) {
            case VILLAGER: 
            case ARMOR_STAND: 
            case PAINTING: 
            case ITEM_FRAME: 
            case ENDER_CRYSTAL: 
            case BOAT: {
                return true;
            }
        }
        return false;
    }

    private static void handleEntityInteraction(PlayerInteractEntityEvent event) {
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        if (KingdomsPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player)) {
            return;
        }
        Land land = Land.getLand(entity.getLocation());
        if (land == null) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        if (!StandardRelationAttribute.INTERACT.hasAttribute(kp.getKingdom(), kingdom)) {
            KingdomsLang.OTHER_KINGDOMS_INTERACT.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void bucketEmpty(PlayerBucketEmptyEvent event) {
        LandProtectionManager.handleBucket((PlayerBucketEvent)event);
    }

    @EventHandler(ignoreCancelled=true)
    public void bucketFill(PlayerBucketFillEvent event) {
        LandProtectionManager.handleBucket((PlayerBucketEvent)event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onKingdomItemBurn(BlockBurnEvent event) {
        Block block = event.getBlock();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(block)) {
            return;
        }
        SimpleLocation location = SimpleLocation.of(block);
        SimpleChunkLocation chunk = location.toSimpleChunkLocation();
        Land land = chunk.getLand();
        if (land == null || !land.isClaimed()) {
            return;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && regulator.hasRule(Regulator.Rule.ALLOW_FIRE)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockFireSpread(BlockIgniteEvent event) {
        if (event.getCause() == BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL || event.getCause() == BlockIgniteEvent.IgniteCause.FIREBALL) {
            return;
        }
        Block block = event.getBlock();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(block)) {
            return;
        }
        SimpleLocation location = SimpleLocation.of(block);
        SimpleChunkLocation chunk = location.toSimpleChunkLocation();
        Land land = chunk.getLand();
        if (land == null || !land.isClaimed()) {
            return;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && regulator.hasRule(Regulator.Rule.ALLOW_FIRE)) {
            return;
        }
        event.setCancelled(true);
    }

    private static void handleBucket(PlayerBucketEvent event) {
        Block block = event.getBlockClicked();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(block.getWorld())) {
            return;
        }
        Land land = Land.getLand(block);
        if (land == null) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return;
        }
        Player player = event.getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        if (!kp.hasKingdom()) {
            event.setCancelled(true);
            KingdomsLang.OTHER_KINGDOMS_PLACE.sendError((CommandSender)player, new Object[0]);
            return;
        }
        Kingdom kpKingdom = kp.getKingdom();
        if (!kingdom.hasAttribute(kpKingdom, (RelationAttribute)StandardRelationAttribute.BUILD)) {
            KingdomsLang.OTHER_KINGDOMS_PLACE.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockFromTo(BlockFromToEvent event) {
        Kingdom kingdom;
        SimpleLocation to = SimpleLocation.of(event.getToBlock());
        Land toLand = to.toSimpleChunkLocation().getLand();
        if (toLand == null || !toLand.isClaimed()) {
            return;
        }
        if (toLand.getStructures().containsKey(to)) {
            event.setCancelled(true);
            return;
        }
        if (toLand.getTurrets().containsKey(to)) {
            event.setCancelled(true);
            return;
        }
        Land fromLand = Land.getLand(event.getBlock());
        Kingdom kingdom2 = kingdom = fromLand == null ? null : fromLand.getKingdom();
        if (!toLand.getKingdom().hasAttribute(kingdom, (RelationAttribute)StandardRelationAttribute.BUILD)) {
            event.setCancelled(true);
        }
    }

    private static Nation disallowedNationZone(KingdomPlayer kp, SimpleChunkLocation chunk) {
        NationZone nationZone = Land.getNationZone(chunk);
        if (nationZone == null) {
            return null;
        }
        Nation nation = nationZone.getNation();
        return nation.isMember(kp.getKingdomId()) ? null : nation;
    }

    private static boolean handleEntityRemove(Entity entity, SimpleChunkLocation chunk) {
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(entity)) {
            return false;
        }
        Land land = chunk.getLand();
        if (!(entity instanceof Player)) {
            return land != null && land.isClaimed();
        }
        Player player = (Player)entity;
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        return LandProtectionManager.handleBuilding(player, kp, chunk, false);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public static void onPlace(BlockPlaceEvent event) {
        SimpleChunkLocation chunk;
        Player player = event.getPlayer();
        if (KingdomsConfig.Claims.DISABLE_PROTECTION_SYSTEM.getManager().getBoolean()) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (LandProtectionManager.handleBuilding(player, kp, chunk = SimpleChunkLocation.of(event.getBlock()), true)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public static void onBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        SimpleLocation location = SimpleLocation.of(event.getBlock());
        SimpleChunkLocation chunk = location.toSimpleChunkLocation();
        Land land = chunk.getLand();
        if (land != null) {
            Structure structure = land.getStructures().get(location);
            if (structure != null && structure.getLocation().equals(location)) {
                StructureManager.onStructureBreak(event, kp, structure, land);
                return;
            }
            Turret turret = land.getTurrets().get(location);
            if (turret != null) {
                TurretManager.onTurretBreak(event, kp, turret);
                return;
            }
        }
        if (KingdomsConfig.Claims.DISABLE_PROTECTION_SYSTEM.getManager().getBoolean()) {
            return;
        }
        if (LandProtectionManager.handleBuilding(player, kp, chunk, false)) {
            event.setCancelled(true);
        }
    }

    public static boolean isItemEntity(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case ARMOR_STAND: 
            case ITEM_FRAME: 
            case PAINTING: 
            case END_CRYSTAL: {
                return true;
            }
        }
        if (type.name().endsWith("BOAT")) {
            return true;
        }
        return item.getItemMeta() instanceof SpawnEggMeta || type.name().endsWith("MINECART");
    }

    private static void cancelInteraction(PlayerInteractEvent event) {
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onRide(EntityMountEvent event) {
        if (KingdomsConfig.Claims.DISABLE_PROTECTION_SYSTEM.getManager().getBoolean()) {
            return;
        }
        Entity entity = event.getMount();
        if (entity.getType() != EntityType.MINECART) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (KingdomsPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player)) {
            return;
        }
        Land land = Land.getLand(entity.getLocation());
        if (land == null) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        if (!StandardRelationAttribute.INTERACT.hasAttribute(kp.getKingdom(), kingdom)) {
            KingdomsLang.OTHER_KINGDOMS_INTERACT.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        if (event.getAttacker() == null) {
            return;
        }
        if (LandProtectionManager.handleEntityRemove(event.getAttacker(), SimpleChunkLocation.of(event.getVehicle().getLocation()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Kingdom landKingdom;
        Player player = event.getPlayer();
        if (event.getNewGameMode() != GameMode.CREATIVE) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin()) {
            return;
        }
        Land land = Land.getLand(player.getLocation());
        if (land == null || !land.isClaimed()) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        if (LandProtectionManager.preventedGameMode(player, kingdom, landKingdom = land.getKingdom())) {
            KingdomsLang.LANDS_GAMEMODE_PROTECTION_ACTIVATED.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    private static boolean preventedGameMode(Player player, Kingdom kingdom, Kingdom landKingdom) {
        if (KingdomsPluginPermission.LAND_BYPASS_CREATIVE.hasPermission((CommandSender)player)) {
            return false;
        }
        if (!KingdomsConfig.Relations.FORCE_SURVIVAL_MODE.getManager().getBoolean()) {
            return false;
        }
        if (StandardRelationAttribute.CEASEFIRE.hasAttribute(kingdom, landKingdom) && StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(kingdom, landKingdom)) {
            return false;
        }
        boolean wasAllowedToFly = player.isFlying();
        player.setGameMode(GameMode.SURVIVAL);
        if (wasAllowedToFly) {
            player.setAllowFlight(true);
            player.setFlying(true);
        }
        return true;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onTeleportProtection(LandChangeEvent event) {
        Kingdom landKingdom;
        Player player = event.getPlayer();
        if (player.getGameMode() != GameMode.CREATIVE) {
            return;
        }
        Land land = event.getToLand();
        if (land == null || !land.isClaimed()) {
            return;
        }
        KingdomPlayer kp = event.getKingdomPlayer();
        if (kp.isAdmin()) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        boolean prevented = LandProtectionManager.preventedGameMode(player, kingdom, landKingdom = land.getKingdom());
        if (prevented) {
            KingdomsLang.LANDS_GAMEMODE_PROTECTION.sendError((CommandSender)player, new Object[0]);
        }
        if (!(!prevented || event.getCause() != PlayerTeleportEvent.TeleportCause.NETHER_PORTAL || StandardRelationAttribute.CEASEFIRE.hasAttribute(kingdom, landKingdom) && StandardRelationAttribute.TURRET_CEASEFIRE.hasAttribute(kingdom, landKingdom))) {
            KingdomsLang.LANDS_PORTAL_PROTECTION.sendError((CommandSender)player, new Object[0]);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        boolean isConsumableInHand;
        Boolean interact;
        boolean notPlate;
        KingdomPlayer kp;
        boolean handInteraction;
        Block block = event.getClickedBlock();
        boolean bl = handInteraction = event.getAction() == Action.RIGHT_CLICK_BLOCK || block != null && block.getType() == Material.DRAGON_EGG;
        if (!handInteraction && event.getAction() != Action.PHYSICAL) {
            return;
        }
        Player player = event.getPlayer();
        Land land = Land.getLand(block);
        ItemStack item = event.getItem();
        boolean isInDisabledWorld = KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player);
        if (handInteraction) {
            Nation nationZone;
            SimpleLocation location = SimpleLocation.of(block);
            boolean exceedsBuildLimit = LocationUtils.exceedsBuildLimit(event);
            if (!exceedsBuildLimit && item != null) {
                NBTWrappers.NBTTagCompound nbt = ItemNBT.getTag(item);
                if ((nbt = nbt.getCompound("Kingdoms")) != null) {
                    String tag = nbt.get("Structure", NBTType.STRING);
                    if (tag != null) {
                        if (isInDisabledWorld) {
                            KingdomsLang.STRUCTURES_DISABLED_WORLD.sendError((CommandSender)player, new Object[0]);
                            event.setCancelled(true);
                            return;
                        }
                        StructureManager.onStructurePlace(event, nbt, tag);
                        return;
                    }
                    tag = nbt.get("Turret", NBTType.STRING);
                    if (tag != null) {
                        if (isInDisabledWorld) {
                            KingdomsLang.TURRETS_DISABLED_WORLD.sendError((CommandSender)player, new Object[0]);
                            event.setCancelled(true);
                            return;
                        }
                        TurretManager.onTurretPlace(event, nbt, tag);
                        return;
                    }
                }
            }
            if (land == null) {
                return;
            }
            if (isInDisabledWorld) {
                return;
            }
            if (event.getHand() == EquipmentSlot.HAND) {
                Structure structure = land.getStructures().get(location);
                if (structure != null) {
                    StructureManager.onStructureInteract(event, structure);
                    return;
                }
                Turret turret = land.getTurrets().get(location);
                if (turret != null) {
                    TurretManager.onTurretInteract(event, land, turret);
                    return;
                }
            }
            if (KingdomsConfig.Claims.DISABLE_PROTECTION_SYSTEM.getManager().getBoolean()) {
                return;
            }
            kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            if (!kp.isAdmin() && !KingdomsPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player) && (nationZone = LandProtectionManager.disallowedNationZone(kp, land.getLocation())) != null) {
                KingdomsLang.LANDS_NATION_ZONE_INTERACT.sendMessage((CommandSender)player, "nation", nationZone.getName());
                event.setCancelled(true);
                return;
            }
            if (!exceedsBuildLimit && item != null && LandProtectionManager.isItemEntity(item) && LandProtectionManager.handleBuilding(player, kp, SimpleChunkLocation.of(block.getRelative(event.getBlockFace())), true)) {
                event.setCancelled(true);
                return;
            }
        }
        if (isInDisabledWorld) {
            return;
        }
        if (land == null || !land.isClaimed() && !KingdomsConfig.ProtectionSigns.PROTECT_UNCLAIMED.getManager().getBoolean()) {
            return;
        }
        boolean bl2 = notPlate = event.getAction() != Action.PHYSICAL || !block.getType().name().endsWith("_PLATE");
        if (notPlate) {
            Optional<ProtectionSign> protectionOpt;
            XMaterial mat = XMaterial.matchXMaterial(block.getType());
            if (!XTag.FENCES.isTagged(mat) && !XTag.isInteractable(mat)) {
                return;
            }
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK && (protectionOpt = ProtectionSign.getProtection(block)).isPresent()) {
                ProtectionSignManager.handleProtectedBlock(event, protectionOpt.get());
                return;
            }
        }
        if (!land.isClaimed()) {
            return;
        }
        Regulator regulator = land.getStructure(Regulator.class);
        if (regulator != null && (interact = regulator.canInteract((OfflinePlayer)player, block)) != null) {
            if (interact.booleanValue()) {
                return;
            }
            event.setCancelled(true);
            return;
        }
        kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (kp.isAdmin() || KingdomsPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player)) {
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        boolean bl3 = isConsumableInHand = item != null && item.getType().isEdible();
        if (!isConsumableInHand && item != null) {
            XMaterial mat = XMaterial.matchXMaterial(item);
            isConsumableInHand = mat == XMaterial.SHIELD || mat == XMaterial.BOW || mat == XMaterial.CROSSBOW;
        }
        boolean showMessage = notPlate && !isConsumableInHand;
        List<String> list2 = KingdomsConfig.Ranks.INTERACT_BLOCKS.getManager().getStringList();
        XMaterial mat = XMaterial.matchXMaterial(block.getType());
        if (mat.isOneOf(list2)) {
            if (!StandardRelationAttribute.INTERACT.hasAttribute(kingdom, land.getKingdom())) {
                event.setUseInteractedBlock(Event.Result.DENY);
                if (showMessage) {
                    KingdomsLang.OTHER_KINGDOMS_INTERACT.sendMessage((CommandSender)player);
                }
            } else if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.INTERACT)) {
                if (showMessage) {
                    StandardKingdomPermission.INTERACT.sendDeniedMessage(player);
                }
                event.setUseInteractedBlock(Event.Result.DENY);
            }
        } else if (!StandardRelationAttribute.USE.hasAttribute(kingdom, land.getKingdom())) {
            event.setUseInteractedBlock(Event.Result.DENY);
            if (showMessage) {
                KingdomsLang.OTHER_KINGDOMS_USE.sendMessage((CommandSender)player);
            }
        } else if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.USE)) {
            if (showMessage) {
                StandardKingdomPermission.USE.sendDeniedMessage(player);
            }
            event.setUseInteractedBlock(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakByEntityEvent event) {
        if (KingdomsConfig.Claims.DISABLE_PROTECTION_SYSTEM.getManager().getBoolean()) {
            return;
        }
        if (LandProtectionManager.handleEntityRemove(event.getRemover(), SimpleChunkLocation.of(event.getEntity().getLocation()))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void entityInteract(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() instanceof Minecart || LandProtectionManager.shouldCheckEntityInteraction(event.getRightClicked().getType())) {
            LandProtectionManager.handleEntityInteraction(event);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void entityInteractAt(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked() instanceof ArmorStand) {
            LandProtectionManager.handleEntityInteraction((PlayerInteractEntityEvent)event);
        }
    }

    public static final class BerryBushHandler
    implements Listener {
        @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
        public void onSweetBerryHarvesting(PlayerHarvestBlockEvent event) {
            if (event.getHarvestedBlock().getType() != Material.SWEET_BERRY_BUSH) {
                return;
            }
            Player player = event.getPlayer();
            if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld((Entity)player)) {
                return;
            }
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            if (kp.isAdmin() || KingdomsPluginPermission.LAND_INTERACT.hasPermission((CommandSender)player)) {
                return;
            }
            Block block = event.getHarvestedBlock();
            SimpleChunkLocation chunk = SimpleChunkLocation.of(block);
            Land land = chunk.getLand();
            if (land == null) {
                return;
            }
            Kingdom kingdom = kp.getKingdom();
            if (!StandardRelationAttribute.USE.hasAttribute(kingdom, land.getKingdom())) {
                KingdomsLang.OTHER_KINGDOMS_USE.sendMessage((CommandSender)player);
            } else if (kingdom != null && !kp.hasPermission(StandardKingdomPermission.USE)) {
                StandardKingdomPermission.USE.sendDeniedMessage(player);
            } else {
                return;
            }
            event.setCancelled(true);
        }
    }
}

