/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.managers.land.protection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.KingdomItemStyle;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.land.structures.objects.SiegeCannon;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.ReflectionUtils;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.structures.SiegeCannonAmmo;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.integer.IntHashSet;
import org.kingdoms.utils.string.StringUtils;

public final class LandExplosionManager
implements Listener {
    public static final boolean REGENERATE = ReflectionUtils.supports(13) && KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_AUTO_REGENERATE_ENABLED.getManager().getBoolean();
    private static final double HEIGHT_MIN;
    private static final double HEIGHT_MAX;
    private static final double SPREAD_MIN;
    private static final double SPREAD_MAX;
    private static final IntHashSet EXPLOSION_BLOCKS;
    private static final Map<Integer, List<Entity>> EXPLODED_ENTITIES;
    private static final Set<ExplosionHandler> ONGOING_REGENERATIONS;
    private static final Map<SimpleLocation, Hanging> BLOCKS_HOLDING_HANGING;

    public static void forceOngoingRegenerations() {
        for (ExplosionHandler regen : ONGOING_REGENERATIONS) {
            regen.forceFinishRegeneration();
        }
    }

    private static void customExplosion(SiegeCannon cannon, List<Block> blocks, Block center, int radius, boolean hollow) {
        blocks.clear();
        int bx = center.getX();
        int by = center.getY();
        int bz = center.getZ();
        for (int x = bx - radius; x <= bx + radius; ++x) {
            for (int y = by - radius; y <= by + radius; ++y) {
                for (int z = bz - radius; z <= bz + radius; ++z) {
                    Block block;
                    double distance = (bx - x) * (bx - x) + (bz - z) * (bz - z) + (by - y) * (by - y);
                    if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1)) || XBlock.isAir((block = center.getWorld().getBlockAt(x, y, z)).getType()) || LandExplosionManager.isUnbreakable(block.getType())) continue;
                    Material type = block.getType();
                    if (!cannon.canDamage(BlockType.OTHER, "others", () -> XMaterial.matchXMaterial(block.getType()).name())) continue;
                    blocks.add(block);
                }
            }
        }
    }

    private static boolean isUnbreakable(Material material) {
        switch (material) {
            case BEDROCK: 
            case BARRIER: 
            case COMMAND_BLOCK: 
            case END_PORTAL_FRAME: 
            case STRUCTURE_BLOCK: 
            case STRUCTURE_VOID: {
                return true;
            }
        }
        return false;
    }

    private static void fancyExplode(Block block) {
        if (XMaterial.supports(13) && block.isPassable()) {
            return;
        }
        ThreadLocalRandom random = ThreadLocalRandom.current();
        Vector vector = new Vector(random.nextDouble(SPREAD_MIN, SPREAD_MAX), random.nextDouble(HEIGHT_MIN, HEIGHT_MAX), random.nextDouble(SPREAD_MIN, SPREAD_MAX));
        FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), block.getType().createBlockData());
        EXPLOSION_BLOCKS.add(falling.getEntityId());
        falling.setDropItem(false);
        falling.setVelocity(vector);
    }

    private static ItemStack[] getContainerContent(BlockState state) {
        ItemStack[] items = null;
        if (state instanceof InventoryHolder) {
            InventoryHolder inv = (InventoryHolder)state;
            if (inv instanceof Chest) {
                Chest chest = (Chest)inv;
                items = chest.getBlockInventory().getContents();
                chest.getBlockInventory().clear();
            } else {
                items = inv.getInventory().getStorageContents();
                inv.getInventory().clear();
            }
        }
        return items;
    }

    private static boolean isAttachableOrHangingBlock(BlockState state) {
        if (state instanceof Banner) {
            return true;
        }
        if (state instanceof Sign) {
            return true;
        }
        XMaterial material = XMaterial.matchXMaterial(state.getType());
        switch (material) {
            case TWISTING_VINES_PLANT: 
            case VINE: 
            case TWISTING_VINES: 
            case WEEPING_VINES_PLANT: 
            case WEEPING_VINES: 
            case LANTERN: 
            case SOUL_LANTERN: 
            case LADDER: {
                return true;
            }
        }
        String name = material.name();
        if (name.endsWith("TORCH")) {
            return true;
        }
        if (name.endsWith("BUTTON")) {
            return true;
        }
        return name.contains("CORAL");
    }

    private static boolean handleEntities(Entity target) {
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(target)) {
            return false;
        }
        if (!MiscUpgrade.ANTI_EXPLOSION.isEnabled()) {
            return false;
        }
        SimpleChunkLocation targetChunk = SimpleChunkLocation.of(target.getLocation());
        Land targetLand = targetChunk.getLand();
        if (targetLand == null) {
            return false;
        }
        Kingdom kingdom = targetLand.getKingdom();
        if (kingdom == null) {
            return false;
        }
        return kingdom.getMiscUpgrades().getOrDefault(MiscUpgrade.ANTI_EXPLOSION, 0) >= 3;
    }

    private static void fuckPaintings(Painting painting, boolean add) {
        Block adjustedCenter;
        int height = painting.getArt().getBlockHeight();
        int width = painting.getArt().getBlockWidth();
        BlockFace facing = painting.getAttachedFace();
        BlockFace leftFace = LandExplosionManager.getFacingOnLeft(facing);
        Block center = painting.getLocation().getBlock().getRelative(facing, 1);
        Block block = adjustedCenter = (facing == BlockFace.EAST || facing == BlockFace.NORTH) && width > 1 ? center.getRelative(leftFace) : center;
        Block topLeftCorner = height < 3 && width < 3 ? adjustedCenter : adjustedCenter.getRelative(BlockFace.UP, height > 2 ? 1 : 0).getRelative(leftFace);
        for (int y = 0; y < height; ++y) {
            Block currentY = topLeftCorner.getRelative(BlockFace.DOWN, y);
            for (int x = 0; x < width; ++x) {
                Block current = currentY.getRelative(leftFace.getOppositeFace(), x);
                SimpleLocation loc = SimpleLocation.of(current);
                if (add) {
                    BLOCKS_HOLDING_HANGING.put(loc, (Hanging)painting);
                    continue;
                }
                BLOCKS_HOLDING_HANGING.remove(loc);
            }
        }
    }

    private static BlockFace getFacingOnLeft(BlockFace face) {
        switch (face) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        throw new AssertionError((Object)("Unknown hanging attached face: " + face));
    }

    private static SimpleLocation getSupportingBlock(Hanging hanging) {
        return SimpleLocation.of(hanging.getLocation().add(hanging.getAttachedFace().getDirection()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onFancyExplosionFall(EntityChangeBlockEvent event) {
        Entity entity = event.getEntity();
        if (entity.getType() != EntityType.FALLING_BLOCK) {
            return;
        }
        if (EXPLOSION_BLOCKS.remove(entity.getEntityId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void hangingBreak(HangingBreakEvent event) {
        Hanging hanging = event.getEntity();
        if (event.getCause() != HangingBreakEvent.RemoveCause.EXPLOSION) {
            if (hanging instanceof ItemFrame) {
                BLOCKS_HOLDING_HANGING.remove(LandExplosionManager.getSupportingBlock(hanging));
            } else if (hanging instanceof Painting) {
                LandExplosionManager.fuckPaintings((Painting)hanging, false);
            }
            return;
        }
        if (hanging instanceof ItemFrame) {
            BLOCKS_HOLDING_HANGING.put(LandExplosionManager.getSupportingBlock(hanging), hanging);
        } else if (hanging instanceof Painting) {
            LandExplosionManager.fuckPaintings((Painting)hanging, true);
        }
        if (LandExplosionManager.handleEntities((Entity)hanging)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityExplosionDamage(EntityDamageByEntityEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            if (event.getCause() != EntityDamageEvent.DamageCause.PROJECTILE) {
                return;
            }
            Entity entity = event.getEntity();
            if (SiegeCannon.getSiegeCannonFromProjectile(entity) == null) {
                return;
            }
        }
        if (event.getEntity().getType() == EntityType.ARMOR_STAND) {
            return;
        }
        LandExplosionManager.protectEntityFromExplosion((Cancellable)event, event.getDamager(), event.getEntity());
    }

    public static void protectEntityFromExplosion(Cancellable event, Entity damager, Entity entity) {
        if (LandExplosionManager.handleEntities(entity)) {
            if (event != null) {
                event.setCancelled(true);
            }
            if (REGENERATE && entity.hasGravity() && !(entity instanceof Player)) {
                entity.setGravity(false);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).setAI(false);
                    if (XMaterial.supports(17)) {
                        ((LivingEntity)entity).setInvisible(true);
                    }
                }
                EXPLODED_ENTITIES.computeIfAbsent(damager.getEntityId(), k -> new ArrayList()).add(entity);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onUnknownExplosion(BlockExplodeEvent event) {
        if (event.blockList().isEmpty()) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(event.getBlock())) {
            return;
        }
        new ExplosionHandler((Event)event, event.blockList(), null, null);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onEntityAntiExplosion(EntityExplodeEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (KingdomsConfig.DISABLED_WORLDS.isInDisabledWorld(event.getEntity())) {
            return;
        }
        new ExplosionHandler((Event)event, event.blockList(), event.getEntity(), SiegeCannon.getSiegeCannonFromProjectile(event.getEntity()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onWitherSkullExplosion(EntityChangeBlockEvent event) {
        if (event.getEntityType() != EntityType.WITHER) {
            return;
        }
        Land land = Land.getLand(event.getBlock());
        if (land == null) {
            return;
        }
        Kingdom kingdom = land.getKingdom();
        if (kingdom == null) {
            return;
        }
        if (kingdom.getUpgradeLevel(MiscUpgrade.ANTI_EXPLOSION) > 1) {
            event.setCancelled(true);
        }
    }

    static {
        EXPLOSION_BLOCKS = new IntHashSet();
        EXPLODED_ENTITIES = new HashMap<Integer, List<Entity>>();
        ONGOING_REGENERATIONS = Collections.newSetFromMap(new IdentityHashMap());
        BLOCKS_HOLDING_HANGING = new HashMap<SimpleLocation, Hanging>();
        HEIGHT_MIN = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_HEIGHT_MIN.getManager().getDouble();
        HEIGHT_MAX = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_HEIGHT_MAX.getManager().getDouble();
        SPREAD_MIN = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_SPREAD_MIN.getManager().getDouble();
        SPREAD_MAX = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_SPREAD_MAX.getManager().getDouble();
    }

    private static final class ExplosionHandler {
        final BlockState[] states;
        final ArrayList<BlockState> requireBaseStates;
        final Map<SimpleLocation, ItemStack[]> containers;
        final @Nullable SiegeCannon cannon;
        final boolean antiExplosionEnabled = MiscUpgrade.ANTI_EXPLOSION.isEnabled();
        final boolean regenerate = REGENERATE && this.antiExplosionEnabled;
        final boolean fancyExplosions = XMaterial.supports(13) && KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_FANCY_EXPLOSIONS_ENABLED.getManager().getBoolean();
        final boolean protectionSigns = KingdomsConfig.ProtectionSigns.PROTECTIONS_EXPLOSION.getManager().getBoolean();
        final boolean allowExplosionDuringInvasions = KingdomsConfig.Invasions.ALLOW_EXPLOSION.getManager().getBoolean();
        final boolean dontDropKingdomItems = KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_DROP_DESTROYED_KINGDOM_ITEMS.getManager().getBoolean();
        final Iterator<Block> iterator;
        final @Nullable Entity source;
        int stateIndex = 0;
        Block block;
        SimpleLocation location;
        Land land;
        Kingdom kingdom;
        private final Kingdom cannonKingdom;
        BukkitTask regenerationTask;
        boolean baseBlocksBuilt;
        private final KLogger logger = new KLogger(KingdomsDebug.EXPLOSIONS);
        private int regulatorCaused;
        private int kingdomCaused;
        private final Event cause;

        ExplosionHandler(Event cause, List<Block> blocks, @Nullable Entity source, @Nullable Pair<SiegeCannon, SiegeCannonAmmo> cannonProps) {
            int requiredLevel;
            IdentityHashMap<Land, Kingdom> trusted = new IdentityHashMap<Land, Kingdom>(9);
            if (this.regenerate) {
                ONGOING_REGENERATIONS.add(this);
            }
            SiegeCannon siegeCannon = this.cannon = cannonProps == null ? null : cannonProps.getKey();
            if (this.cannon != null) {
                LandExplosionManager.customExplosion(this.cannon, blocks, source.getLocation().getBlock(), this.cannon.getExplosionRadius(cannonProps.getValue()), false);
                this.cannonKingdom = this.cannon.getLand().getKingdom();
            } else {
                this.cannonKingdom = null;
            }
            this.cause = cause;
            this.source = source;
            this.iterator = blocks.iterator();
            this.states = this.regenerate ? new BlockState[blocks.size()] : null;
            this.requireBaseStates = this.regenerate ? new ArrayList() : null;
            this.containers = this.regenerate ? new HashMap() : null;
            int n = requiredLevel = source != null && source.getType() == EntityType.CREEPER ? 0 : 1;
            if (KLogger.isDebugging()) {
                this.logger.property((Object)"Source", source);
                this.logger.property((Object)"Blocks", blocks.size());
                this.logger.property((Object)"Has Cannon", this.cannon);
                this.logger.property((Object)"Fancy", this.fancyExplosions);
                this.logger.property((Object)"Regenerate", this.regenerate);
                this.logger.property((Object)"Anti-Explosion", this.antiExplosionEnabled);
                this.logger.property((Object)"Allow Explosion During Invasions", this.allowExplosionDuringInvasions);
            }
            while (this.iterator.hasNext()) {
                this.block = this.iterator.next();
                this.location = SimpleLocation.of(this.block);
                this.land = Land.getLand(this.location);
                this.kingdom = null;
                if (this.land == null) {
                    this.animateBlock();
                    continue;
                }
                this.kingdom = (Kingdom)trusted.get(this.land);
                if (this.kingdom != null) {
                    this.handleTrustedLand();
                    continue;
                }
                this.kingdom = this.land.getKingdom();
                if (this.kingdom == null) {
                    this.handleKingdomItems(true);
                    continue;
                }
                if (this.protectionSigns && ProtectionSign.isProtected(this.block)) {
                    if (this.canBreak(BlockType.PROTECTED_BLOCK, () -> "everyone?")) continue;
                    this.iterator.remove();
                    continue;
                }
                if (this.kingdom.isPacifist() || this.antiExplosionEnabled && this.kingdom.getMiscUpgrades().getOrDefault(MiscUpgrade.ANTI_EXPLOSION, 0) > requiredLevel) {
                    Regulator regulator = this.land.getStructure(Regulator.class);
                    if (regulator != null && regulator.hasRule(Regulator.Rule.ALLOW_EXPLOSIONS)) {
                        ++this.regulatorCaused;
                        this.animateBlock();
                        this.handleKingdomItems(false);
                        continue;
                    }
                    trusted.put(this.land, this.kingdom);
                    this.handleTrustedLand();
                    continue;
                }
                ++this.kingdomCaused;
                this.handleKingdomItems(true);
                this.animateBlock();
            }
            if (this.kingdomCaused > 0) {
                this.logger.property((Object)"Blocks broken due to normal causes", this.kingdomCaused);
            }
            if (this.regulatorCaused > 0) {
                this.logger.property((Object)"Regulatored", this.regulatorCaused);
            }
            this.logger.property((Object)"Left Blocks", blocks.size());
            if (this.regenerate) {
                this.regenerateBlocks();
            }
            if (!this.regenerate) {
                this.logger.end();
            }
        }

        private void animateBlock() {
            if (this.fancyExplosions) {
                LandExplosionManager.fancyExplode(this.block);
            }
        }

        void handleTrustedLand() {
            if (!this.kingdom.isPacifist()) {
                if (this.allowExplosionDuringInvasions && this.land.isBeingInvaded()) {
                    this.animateBlock();
                    this.handleKingdomItems(true);
                    return;
                }
                if (this.handleKingdomItems(false)) {
                    return;
                }
            }
            if (this.kingdom.isPacifist() || !this.canBreak(BlockType.OTHER, () -> XMaterial.matchXMaterial(this.block.getType()).name())) {
                if (this.regenerate && !this.block.getType().name().contains("CHEST")) {
                    if (BLOCKS_HOLDING_HANGING.containsKey(this.location)) {
                        this.iterator.remove();
                        return;
                    }
                    this.animateBlock();
                    this.handleGeneration(this.block);
                } else {
                    this.iterator.remove();
                }
            }
        }

        boolean handleKingdomItems(boolean force) {
            KingdomItem kingdomItem = null;
            BlockType blockType = null;
            Structure structure = this.land.getStructures().get(this.location);
            if (structure != null) {
                kingdomItem = structure;
                blockType = BlockType.STRUCTURE;
            } else {
                Turret turret = this.land.getTurrets().get(this.location);
                if (turret != null) {
                    kingdomItem = turret;
                    blockType = BlockType.TURRET;
                }
            }
            if (kingdomItem != null) {
                Structure finalItem = kingdomItem;
                if (force || this.canBreak(blockType, () -> ((KingdomItemStyle)finalItem.getStyle()).getName())) {
                    Structure finalKingdomItem = kingdomItem;
                    this.logger.log(() -> "Kingdom item " + finalKingdomItem + " (" + ((KingdomItemStyle)finalKingdomItem.getStyle()).getName() + ") broke naturally: " + force);
                    if (!this.dontDropKingdomItems) {
                        kingdomItem.remove(this.getBreakContext());
                    }
                }
                this.iterator.remove();
                return true;
            }
            return false;
        }

        private KingdomItemRemoveContext getBreakContext() {
            KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
            ctx.setCause(this.cause);
            ctx.setPlayer(this.getResponsiblePlayer());
            if (this.cannon != null) {
                ctx.setModifier(event -> event.getMetadata().put(SiegeCannon.NS, this.cannon));
            }
            return ctx;
        }

        KingdomPlayer getResponsiblePlayer() {
            return this.cannon == null ? null : KingdomPlayer.getKingdomPlayer((OfflinePlayer)this.cannon.getHandler());
        }

        boolean canBreak(BlockType blockType, Supplier<String> type) {
            if (this.cannon == null) {
                return false;
            }
            if (this.kingdom.getShieldTimeLeft() > 0L) {
                return false;
            }
            if (StandardRelationAttribute.BUILD.hasAttribute(this.kingdom, this.cannonKingdom)) {
                return false;
            }
            return this.cannon.canDamage(blockType, StringUtils.configOption(blockType) + 's', type);
        }

        void handleGeneration(Block block) {
            BlockState state = block.getState();
            ItemStack[] content = LandExplosionManager.getContainerContent(state);
            if (content != null) {
                this.containers.put(SimpleLocation.of(block), content);
            }
            if (LandExplosionManager.isAttachableOrHangingBlock(state)) {
                this.requireBaseStates.add(state);
            } else {
                this.states[this.stateIndex++] = state;
            }
            block.setType(Material.AIR, false);
        }

        void onRegenerationEnd() {
            if (this.regenerate) {
                ONGOING_REGENERATIONS.remove(this);
            }
            this.regenerateEntities();
            this.logger.end();
        }

        void regenerateEntities() {
            if (this.source == null) {
                return;
            }
            List entities = (List)EXPLODED_ENTITIES.remove(this.source.getEntityId());
            if (entities == null) {
                return;
            }
            for (Entity entity : entities) {
                entity.setGravity(true);
                if (!(entity instanceof LivingEntity)) continue;
                ((LivingEntity)entity).setAI(true);
                if (!XMaterial.supports(17)) continue;
                ((LivingEntity)entity).setInvisible(false);
                ParticleDisplay.of(Particle.CLOUD).withCount(50).offset(1.0).spawn(entity.getLocation().add(0.0, 0.5, 0.0));
            }
            this.logger.property((Object)"Regenerated entities", entities.size());
        }

        public void forceFinishRegeneration() {
            if (this.regenerate && this.regenerationTask != null) {
                this.regenerationTask.cancel();
            }
            if (!this.baseBlocksBuilt) {
                while (this.stateIndex >= 0) {
                    BlockState state = this.states[this.stateIndex];
                    state.update(true);
                    this.handleChest(state);
                    if (--this.stateIndex >= 0) continue;
                    this.baseBlocksBuilt = true;
                    ++this.stateIndex;
                    break;
                }
            }
            while (this.stateIndex < this.requireBaseStates.size()) {
                this.requireBaseStates.get(this.stateIndex++).update(true);
            }
            this.regenerateEntities();
        }

        void handleChest(BlockState state) {
            if (state instanceof InventoryHolder) {
                InventoryHolder inv = (InventoryHolder)state;
                ItemStack[] content = this.containers.get(SimpleLocation.of(state.getLocation()));
                if (inv instanceof Chest) {
                    Chest chest = (Chest)inv;
                    chest.getBlockInventory().setContents(content);
                } else {
                    inv.getInventory().setContents(content);
                }
            }
        }

        void regenerateBlocks() {
            boolean bl = this.baseBlocksBuilt = this.stateIndex == 0;
            if (this.stateIndex == 0 && this.requireBaseStates.isEmpty()) {
                this.onRegenerationEnd();
                return;
            }
            if (this.stateIndex > 0) {
                --this.stateIndex;
            }
            Arrays.sort(this.states, (s1, s2) -> {
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 == null) {
                    return 1;
                }
                if (s2 == null) {
                    return -1;
                }
                return Integer.compare(s2.getY(), s1.getY());
            });
            this.logger.log(() -> "Starting the regeneration of " + this.states.length + " blocks with " + this.requireBaseStates.size() + " bases.");
            this.regenerationTask = new BukkitRunnable(){

                public void run() {
                    BlockState state;
                    if (baseBlocksBuilt) {
                        BlockState state2;
                        try {
                            state2 = requireBaseStates.get(stateIndex++);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            return;
                        }
                        if (!state2.update(true)) {
                            MessageHandler.sendConsolePluginMessage("&4Failed to update state for derived block regeneration: " + state2.getBlock());
                        }
                        if (stateIndex >= requireBaseStates.size()) {
                            this.cancel();
                        }
                        return;
                    }
                    try {
                        state = states[stateIndex];
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return;
                    }
                    if (state == null) {
                        if (requireBaseStates.isEmpty()) {
                            this.cancel();
                        } else {
                            baseBlocksBuilt = true;
                            stateIndex = 0;
                        }
                        return;
                    }
                    if (!state.update(true)) {
                        MessageHandler.sendConsolePluginMessage("&4Failed to update state for block regeneration: " + state.getBlock());
                    }
                    this.handleChest(state);
                    if (--stateIndex < 0) {
                        if (requireBaseStates.isEmpty()) {
                            this.cancel();
                        } else {
                            baseBlocksBuilt = true;
                            ++stateIndex;
                        }
                    }
                }

                public synchronized void cancel() throws IllegalStateException {
                    super.cancel();
                    this.onRegenerationEnd();
                }
            }.runTaskTimer((Plugin)Kingdoms.get(), (long)KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_AUTO_REGENERATE_DELAY.getManager().getInt() * 20L, KingdomsConfig.MiscUpgrades.ANTI_EXPLOSION_AUTO_REGENERATE_INTERVAL.getManager().getLong());
        }
    }

    public static enum BlockType {
        OTHER,
        TURRET,
        STRUCTURE,
        PROTECTED_BLOCK;

    }
}

